/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.marklogic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.ecm.core.storage.marklogic.MarkLogicHelper;
import org.nuxeo.ecm.core.storage.marklogic.MarkLogicRangeElementIndexDescriptor;
import org.nuxeo.ecm.core.storage.marklogic.MarkLogicStateSerializer;
import org.nuxeo.ecm.core.storage.marklogic.RangeElementIndexPredicate;

class MarkLogicQuerySimpleBuilder {
    private final List<String> queries = new ArrayList<String>();
    private final List<MarkLogicRangeElementIndexDescriptor> rangeElementIndexes;
    protected int limit;
    protected int offset;

    public MarkLogicQuerySimpleBuilder(List<MarkLogicRangeElementIndexDescriptor> rangeElementIndexes) {
        this.rangeElementIndexes = rangeElementIndexes;
    }

    public MarkLogicQuerySimpleBuilder eq(String key, Object value) {
        Type type = DBSSession.getType((String)key);
        String k = key;
        if (type instanceof ListType) {
            k = k + "__item";
        }
        MarkLogicHelper.ElementType markLogicType = MarkLogicHelper.ElementType.getType(value);
        if (this.rangeElementIndexes.stream().anyMatch(new RangeElementIndexPredicate(key, markLogicType.getWithoutNamespace()))) {
            this.queries.add(this.elementRangeQuery(k, "=", markLogicType, value));
        } else {
            this.queries.add(this.elementValueQuery(k, value));
        }
        return this;
    }

    public MarkLogicQuerySimpleBuilder notIn(String key, Collection<?> values) {
        if (!values.isEmpty()) {
            String query = this.elementValueQuery(key, values.toArray());
            String notQuery = String.format("cts:not-query(%s)", query);
            this.queries.add(notQuery);
        }
        return this;
    }

    private String elementValueQuery(String key, Object ... values) {
        String serializedKey = MarkLogicHelper.serializeKey(key);
        String serializedValue = this.serializeValues(values);
        return String.format("cts:element-value-query(fn:QName(\"\",\"%s\"),%s)", serializedKey, serializedValue);
    }

    private String elementRangeQuery(String key, String operator, MarkLogicHelper.ElementType valueType, Object ... values) {
        String serializedKey = MarkLogicHelper.serializeKey(key);
        String serializedValue = this.serializeValues(valueType, values);
        return String.format("cts:element-range-query(fn:QName(\"\",\"%s\"),\"%s\",%s)", serializedKey, operator, serializedValue);
    }

    private String serializeValues(Object ... values) {
        return this.serializeValues((String value) -> "\"" + value + "\"", values);
    }

    private String serializeValues(MarkLogicHelper.ElementType type, Object ... values) {
        return this.serializeValues((String value) -> type.get() + "(\"" + value + "\")", values);
    }

    private String serializeValues(Function<String, String> format, Object ... values) {
        Function<Object, String> serializeValue = MarkLogicStateSerializer::serializeValue;
        Function<String, String> escapeXml = StringEscapeUtils::escapeXml;
        Function<Object, String> serializer = serializeValue.andThen(escapeXml).andThen(format);
        if (values.length == 1) {
            return serializer.apply(values[0]);
        }
        return Arrays.stream(values).map(serializer).collect(Collectors.joining(",", "(", ")"));
    }

    public MarkLogicQuerySimpleBuilder limit(int limit) {
        this.limit = limit;
        return this;
    }

    public MarkLogicQuerySimpleBuilder offset(int offset) {
        this.offset = offset;
        return this;
    }

    public String build() {
        String searchQuery = String.format("cts:search(fn:doc(),cts:and-query((%s)))", String.join((CharSequence)",", this.queries));
        if (this.limit != 0) {
            searchQuery = String.format("%s[%s to %s]", searchQuery, this.offset + 1, this.offset + this.limit);
        }
        return searchQuery;
    }
}

