/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.http;

import com.marklogic.http.BoyerMoore;
import com.marklogic.http.MultipartSplitter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BMBoundaryPartSplitter
implements MultipartSplitter {
    private static final int MIN_BUFFER_SIZE = 2048;
    private static final int MAX_BUFFER_SIZE = 0xA00000;
    private static final byte[] BOUNDARY_LEADIN = "\n--".getBytes();
    private static final byte[] BOUNDARY_INTERPART_LEADOUT = "\n".getBytes();
    private static final byte[] BOUNDARY_TERMINAL_LEADOUT = "--\n".getBytes();
    private final InputStream httpStream;
    private final BoyerMoore baseBoundaryMatcher;
    private final BoyerMoore interPartBoundaryMatcher;
    private final int interPartBoundaryLength;
    private final BoyerMoore terminalBoundaryMatcher;
    private final int terminalBoundaryLength;
    private final Logger logger;
    private final byte[] bufferBytes;
    private final ByteBuffer byteBuffer;
    private final int lowWaterMark;
    private boolean streamEOS = false;
    private int readableBytes = 0;
    private boolean atTerminalBoundary = false;
    private boolean atBoundary = false;
    private long totalBytesRead = 0L;

    public BMBoundaryPartSplitter(InputStream inputStream, byte[] boundary, int bufSize, Logger loggerArg) throws IOException {
        this.logger = loggerArg == null ? Logger.getLogger(this.getClass().getName()) : loggerArg;
        this.httpStream = inputStream;
        int bufferSize = this.bufferSize(bufSize);
        this.bufferBytes = new byte[bufferSize];
        this.byteBuffer = ByteBuffer.wrap(this.bufferBytes);
        this.byteBuffer.limit(0);
        byte[] bytes = new byte[boundary.length + BOUNDARY_LEADIN.length];
        System.arraycopy(BOUNDARY_LEADIN, 0, bytes, 0, BOUNDARY_LEADIN.length);
        System.arraycopy(boundary, 0, bytes, BOUNDARY_LEADIN.length, boundary.length);
        this.baseBoundaryMatcher = new BoyerMoore(bytes);
        bytes = new byte[boundary.length + BOUNDARY_LEADIN.length + BOUNDARY_INTERPART_LEADOUT.length];
        System.arraycopy(BOUNDARY_LEADIN, 0, bytes, 0, BOUNDARY_LEADIN.length);
        System.arraycopy(boundary, 0, bytes, BOUNDARY_LEADIN.length, boundary.length);
        System.arraycopy(BOUNDARY_INTERPART_LEADOUT, 0, bytes, BOUNDARY_LEADIN.length + boundary.length, BOUNDARY_INTERPART_LEADOUT.length);
        this.interPartBoundaryMatcher = new BoyerMoore(bytes);
        this.interPartBoundaryLength = bytes.length;
        bytes = new byte[boundary.length + BOUNDARY_LEADIN.length + BOUNDARY_TERMINAL_LEADOUT.length];
        System.arraycopy(BOUNDARY_LEADIN, 0, bytes, 0, BOUNDARY_LEADIN.length);
        System.arraycopy(boundary, 0, bytes, BOUNDARY_LEADIN.length, boundary.length);
        System.arraycopy(BOUNDARY_TERMINAL_LEADOUT, 0, bytes, BOUNDARY_LEADIN.length + boundary.length, BOUNDARY_TERMINAL_LEADOUT.length);
        this.terminalBoundaryMatcher = new BoyerMoore(bytes);
        this.terminalBoundaryLength = bytes.length;
        this.lowWaterMark = this.terminalBoundaryLength * 2;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Constructed: bufsize=" + bufferSize + ", boundary='" + new String(boundary) + "'");
        }
        this.fillBuffer();
    }

    public BMBoundaryPartSplitter(InputStream inputStream, byte[] boundary, int bufSize) throws IOException {
        this(inputStream, boundary, bufSize, null);
    }

    @Override
    public long getTotalBytesRead() {
        return this.totalBytesRead;
    }

    private int bufferSize(int bufSize) {
        if (bufSize == 0) {
            return 16384;
        }
        if (bufSize < 2048) {
            return 2048;
        }
        if (bufSize > 0xA00000) {
            return 0xA00000;
        }
        return bufSize;
    }

    @Override
    public void close() throws IOException {
        long skipped = this.httpStream.skip(Long.MAX_VALUE);
        if (skipped > 0L) {
            this.totalBytesRead += skipped;
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("flushed " + skipped + " bytes on close");
            }
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        this.flushToBoundary();
        return !this.atTerminalBoundary;
    }

    @Override
    public void next() throws IOException {
        if (!this.atBoundary) {
            this.flushToBoundary();
        }
        if (this.atTerminalBoundary) {
            this.logger.finest("at terminal boundary");
            return;
        }
        this.stepOverBoundary();
    }

    @Override
    public int read() throws IOException {
        if (this.readableBytes < 1) {
            this.fillBuffer();
        }
        if (this.readableBytes < 1) {
            return -1;
        }
        byte b = this.byteBuffer.get();
        --this.readableBytes;
        ++this.totalBytesRead;
        return b & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int offsetArg, int length) throws IOException {
        boolean logFinest = this.logger.isLoggable(Level.FINEST);
        int remaining = length;
        int offset = offsetArg;
        int totalRead = 0;
        if (logFinest) {
            this.logger.finest("enter");
        }
        while (remaining > 0) {
            this.fillBuffer();
            if (this.readableBytes == 0) {
                if (!this.atBoundary) {
                    throw new IOException("Premature End-Of-Stream on read.  Server connection lost?");
                }
                if (!logFinest) break;
                this.logger.finest("readableBytes=0, break");
                break;
            }
            int rc = this.copyOutBytes(buffer, offset, remaining);
            remaining -= rc;
            offset += rc;
            totalRead += rc;
        }
        if (logFinest) {
            this.logger.finest("exit: totalRead=" + totalRead);
        }
        if (totalRead == 0) {
            return -1;
        }
        this.totalBytesRead += (long)totalRead;
        return totalRead;
    }

    private int copyOutBytes(byte[] buffer, int offset, int length) {
        int toCopy = this.readableBytes < length ? this.readableBytes : length;
        this.byteBuffer.get(buffer, offset, toCopy);
        this.readableBytes -= toCopy;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("copied out " + toCopy + " bytes");
        }
        return toCopy;
    }

    private void fillBuffer() throws IOException {
        boolean logFinest = this.logger.isLoggable(Level.FINEST);
        if (this.streamEOS || this.byteBuffer.remaining() > this.lowWaterMark) {
            if (logFinest) {
                this.logger.finest("no read: EOS=" + this.streamEOS + ", remain=" + this.byteBuffer.remaining() + ", low-water=" + this.lowWaterMark);
            }
            if (this.readableBytes == 0) {
                this.checkForBoundary();
            }
            return;
        }
        if (logFinest) {
            this.logger.finest("compacting buffer, remaining=" + this.byteBuffer.remaining());
        }
        this.byteBuffer.compact();
        while (!this.streamEOS && this.byteBuffer.hasRemaining()) {
            int position = this.byteBuffer.position();
            int rc = this.httpStream.read(this.bufferBytes, position, this.byteBuffer.remaining());
            if (logFinest) {
                this.logger.finest("read: rc=" + rc);
            }
            if (rc == -1) {
                if (logFinest) {
                    this.logger.finest("EOS, setting streamEOS flag, break");
                }
                this.streamEOS = true;
                break;
            }
            this.byteBuffer.position(position + rc);
            if (!logFinest) continue;
            this.logger.finest(" added " + rc + " bytes to buffer: pos=" + this.byteBuffer.position() + ", remaining=" + this.byteBuffer.remaining());
        }
        this.byteBuffer.flip();
        this.checkForBoundary();
    }

    private void checkForBoundary() {
        this.atTerminalBoundary = false;
        this.atBoundary = false;
        boolean logFinest = this.logger.isLoggable(Level.FINEST);
        int position = this.byteBuffer.position();
        int limit = this.byteBuffer.limit();
        int boundaryPos = this.baseBoundaryMatcher.search(this.bufferBytes, position, limit);
        if (logFinest) {
            this.logger.finest("boundaryPos=" + boundaryPos);
        }
        if (boundaryPos == -1) {
            this.readableBytes = limit - this.baseBoundaryMatcher.partialMatch() - position;
            if (logFinest) {
                this.logger.finest("no boundary, readableBytes=" + this.readableBytes);
            }
            return;
        }
        this.readableBytes = boundaryPos - position;
        if (logFinest) {
            this.logger.finest("possible boundary seen at " + boundaryPos + ", readableBytes=" + this.readableBytes);
        }
        if (boundaryPos == position) {
            if (this.terminalBoundaryMatcher.search(this.bufferBytes, boundaryPos, boundaryPos + this.terminalBoundaryLength) == position) {
                this.totalBytesRead += (long)this.terminalBoundaryLength;
                this.atTerminalBoundary = true;
                this.atBoundary = true;
                if (logFinest) {
                    this.logger.finest("terminal boundary at " + boundaryPos);
                }
            } else if (this.interPartBoundaryMatcher.search(this.bufferBytes, boundaryPos, boundaryPos + this.interPartBoundaryLength) == position) {
                this.atBoundary = true;
                if (logFinest) {
                    this.logger.finest("inter-part boundary at " + boundaryPos);
                }
            }
        }
    }

    private void flushToBoundary() throws IOException {
        while (!this.atBoundary) {
            this.totalBytesRead += (long)this.readableBytes;
            this.byteBuffer.position(this.byteBuffer.position() + this.readableBytes);
            this.fillBuffer();
            this.checkForBoundary();
            if (this.readableBytes != 0 || this.atBoundary) continue;
            throw new IOException("Premature End-Of-Stream on flush.  Server connection lost?");
        }
    }

    private void stepOverBoundary() {
        if (this.atTerminalBoundary) {
            throw new IllegalStateException("Attempt to step over terminal boundary");
        }
        this.totalBytesRead += (long)this.interPartBoundaryLength;
        this.byteBuffer.position(this.byteBuffer.position() + this.interPartBoundaryLength);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("stepped over boundary, new position=" + this.byteBuffer.position());
        }
        this.checkForBoundary();
    }
}

