/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl;

import com.marklogic.xcc.ResultItem;
import com.marklogic.xcc.types.ItemType;
import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.XdmItem;
import com.marklogic.xcc.types.impl.StreamableItem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class ResultItemImpl
implements ResultItem {
    private final XdmItem value;
    private final int index;
    private final String uri;
    private final String path;

    public ResultItemImpl(XdmItem value, int index, String uri, String path) {
        this.value = value;
        this.index = index;
        this.uri = uri;
        this.path = uri != null && path == null ? "/" : path;
    }

    @Override
    public String getDocumentURI() {
        return this.uri;
    }

    @Override
    public String getNodePath() {
        return this.path;
    }

    @Override
    public XdmItem getItem() {
        return this.value;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isFetchable() {
        if (this.value.isCached()) {
            return true;
        }
        if (this.value instanceof StreamableItem) {
            StreamableItem sitem = (StreamableItem)((Object)this.value);
            return sitem.isFetchable();
        }
        return false;
    }

    @Override
    public void cache() {
        if (!this.value.isCached()) {
            this.asString();
        }
    }

    @Override
    public ItemType getItemType() {
        return this.value.getItemType();
    }

    @Override
    public Reader asReader() {
        return this.value.asReader();
    }

    @Override
    public InputStream asInputStream() {
        return this.value.asInputStream();
    }

    @Override
    public String asString() {
        return this.value.asString();
    }

    @Override
    public boolean isCached() {
        return this.value.isCached();
    }

    @Override
    public void writeTo(Writer writer) throws IOException {
        this.value.writeTo(writer);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        this.value.writeTo(outputStream);
    }

    @Override
    public ValueType getValueType() {
        return this.value.getValueType();
    }
}

