/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc;

import com.marklogic.xcc.ContentCapability;

public class ContentPermission {
    public static final ContentCapability READ = ContentCapability.READ;
    public static final ContentCapability INSERT = ContentCapability.INSERT;
    public static final ContentCapability UPDATE = ContentCapability.UPDATE;
    public static final ContentCapability EXECUTE = ContentCapability.EXECUTE;
    private ContentCapability capability;
    private String role;

    public ContentPermission(ContentCapability capability, String role) {
        if (role == null) {
            throw new IllegalArgumentException("Role may not be null");
        }
        String trimmedRole = role.trim();
        if (trimmedRole.length() == 0) {
            throw new IllegalArgumentException("Role may not be empty");
        }
        this.capability = capability;
        this.role = trimmedRole;
    }

    public static ContentPermission newReadPermission(String role) {
        return new ContentPermission(READ, role);
    }

    public static ContentPermission newInsertPermission(String role) {
        return new ContentPermission(INSERT, role);
    }

    public static ContentPermission newUpdatePermission(String role) {
        return new ContentPermission(UPDATE, role);
    }

    public static ContentPermission newExecutePermission(String role) {
        return new ContentPermission(EXECUTE, role);
    }

    public ContentCapability getCapability() {
        return this.capability;
    }

    public String getRole() {
        return this.role;
    }

    public String toString() {
        return "[DocPermission: role=" + this.role + ", capability=" + this.capability + "]";
    }

    public boolean equals(Object obj) {
        ContentPermission p;
        if (this == obj) {
            return true;
        }
        return obj instanceof ContentPermission && this.role.equals((p = (ContentPermission)obj).getRole()) && this.capability == p.getCapability();
    }

    public int hashCode() {
        return (this.role + this.capability.toString()).hashCode();
    }
}

