/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.types.impl;

import com.marklogic.xcc.types.CtsPoint;
import com.marklogic.xcc.types.CtsPolygon;
import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.impl.AbstractStringItem;
import com.marklogic.xcc.types.impl.CtsPointImpl;
import java.util.ArrayList;
import java.util.List;

public class CtsPolygonImpl
extends AbstractStringItem
implements CtsPolygon {
    private List<CtsPoint> vertices;

    public CtsPolygonImpl(String value) {
        super(ValueType.CTS_POLYGON, value);
    }

    public CtsPolygonImpl(List<CtsPoint> vertices) {
        super(ValueType.CTS_POLYGON, vertices.size() > 0 ? null : "");
        this.vertices = vertices;
    }

    private void parse() {
        int count = 0;
        int i = 0;
        while ((i = this.value.indexOf(32, i) + 1) > 0) {
            ++count;
        }
        this.vertices = new ArrayList<CtsPoint>(count);
        i = 0;
        while (count-- > 0) {
            int j = this.value.indexOf(32, i);
            this.vertices.add(new CtsPointImpl(this.value.substring(i, j)));
            i = j + 1;
        }
        if (i > 0) {
            this.vertices.add(new CtsPointImpl(this.value.substring(i)));
        }
    }

    @Override
    public String asString() {
        if (this.value == null) {
            StringBuilder sb = new StringBuilder();
            for (CtsPoint vertex : this.vertices) {
                sb.append(vertex.getLatitude());
                sb.append(",");
                sb.append(vertex.getLongitude());
                sb.append(" ");
            }
            this.value = sb.substring(0, sb.length() - 1);
        }
        return this.value;
    }

    @Override
    public List<CtsPoint> getVertices() {
        if (this.vertices == null) {
            this.parse();
        }
        return this.vertices;
    }
}

