/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.marklogic;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.joda.time.DateTime;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.marklogic.MarkLogicHelper;

final class MarkLogicStateSerializer {
    private MarkLogicStateSerializer() {
    }

    public static String serialize(State state) {
        Element root = MarkLogicStateSerializer.serialize("document", state);
        MarkLogicStateSerializer.addDefaultNamespaces(root);
        return DocumentHelper.createDocument((Element)root).asXML();
    }

    private static Element serialize(String key, State state) {
        boolean update = state instanceof State.StateDiff;
        Element element = DocumentHelper.createElement((String)MarkLogicHelper.serializeKey(key));
        for (Map.Entry entry : state.entrySet()) {
            Optional<Element> child = MarkLogicStateSerializer.serialize((String)entry.getKey(), entry.getValue());
            if (child.isPresent()) {
                element.add(child.get());
                continue;
            }
            if (!update) continue;
            element.add(MarkLogicStateSerializer.createNullElement((String)entry.getKey()));
        }
        return element;
    }

    private static Optional<Element> serialize(String key, Object value) {
        Optional<Object> result;
        if (value == null) {
            result = Optional.empty();
        } else if (value instanceof State) {
            State state = (State)value;
            result = state.isEmpty() ? Optional.empty() : Optional.of(MarkLogicStateSerializer.serialize(key, state));
        } else if (value instanceof State.ListDiff) {
            result = Optional.of(MarkLogicStateSerializer.serialize(key, (State.ListDiff)value));
        } else if (value instanceof List) {
            List values = (List)value;
            result = values.isEmpty() ? Optional.empty() : Optional.of(MarkLogicStateSerializer.serialize(key, values));
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            result = array.length == 0 ? Optional.empty() : Optional.of(MarkLogicStateSerializer.serialize(key, Arrays.asList(array)));
        } else {
            String nodeValue = MarkLogicStateSerializer.serializeValue(value);
            Element element = DocumentHelper.createElement((String)MarkLogicHelper.serializeKey(key));
            element.addAttribute("xsi:type", MarkLogicHelper.ElementType.getType(value).get());
            element.setText(nodeValue);
            result = Optional.of(element);
        }
        return result;
    }

    private static Element serialize(String key, State.ListDiff listDiff) {
        Element diffParent = DocumentHelper.createElement((String)MarkLogicHelper.serializeKey(key));
        Element diff = DocumentHelper.createElement((String)MarkLogicHelper.serializeKey("diff"));
        if (listDiff.diff != null) {
            for (Object object : listDiff.diff) {
                diff.add(MarkLogicStateSerializer.serialize(key + "__item", object).orElseGet(() -> MarkLogicStateSerializer.createNullElement(key + "__item")));
            }
        }
        diffParent.add(diff);
        List<Object> rpush = listDiff.rpush;
        if (rpush == null) {
            rpush = Collections.emptyList();
        }
        diffParent.add(MarkLogicStateSerializer.serialize("rpush", key + "__item", rpush));
        return diffParent;
    }

    private static Element serialize(String key, List<Object> list) {
        return MarkLogicStateSerializer.serialize(key, key + "__item", list);
    }

    private static Element serialize(String key, String itemKey, List<Object> list) {
        Element array = DocumentHelper.createElement((String)MarkLogicHelper.serializeKey(key));
        for (Object object : list) {
            MarkLogicStateSerializer.serialize(itemKey, object).ifPresent(arg_0 -> ((Element)array).add(arg_0));
        }
        return array;
    }

    public static String serializeValue(Object value) {
        String serializedValue = value instanceof Calendar ? MarkLogicHelper.serializeCalendar((Calendar)value) : (value instanceof DateTime ? ((DateTime)value).toString(MarkLogicHelper.DATE_TIME_FORMATTER) : value.toString());
        return serializedValue;
    }

    private static void addDefaultNamespaces(Element root) {
        root.addNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        root.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    private static Element createNullElement(String key) {
        Element element = DocumentHelper.createElement((String)MarkLogicHelper.serializeKey(key));
        element.setText("NULL");
        return element;
    }
}

