/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.media.asset.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import nuxeo.media.asset.service.MediaAssetService;
import nuxeo.media.asset.service.MediaTypeDescriptor;
import nuxeo.media.asset.service.MimetypeListDescriptor;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class MediaAssetServiceImpl
extends DefaultComponent
implements MediaAssetService {
    public static final String MIMETYPE_ZIP = "application/zip";
    public static String MEDIA_TYPE_EXT_POINT = "mediatype";
    public static String SUPPORTED_ZIP_CONTENT_EXT_POINT = "supportedZipContent";
    public static String INPUT_FILTER_KEY = "nuxeo.media.asset.service.default.filter.name";
    public List<String> allMediaFacets = new ArrayList<String>();
    protected Map<String, MediaTypeDescriptor> mediatypes = new HashMap<String, MediaTypeDescriptor>();
    protected MimetypeListDescriptor supportedZipContent;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (MEDIA_TYPE_EXT_POINT.equals(extensionPoint)) {
            MediaTypeDescriptor descriptor = (MediaTypeDescriptor)contribution;
            this.mediatypes.put(descriptor.name, descriptor);
            for (String facet : descriptor.getFacets()) {
                if (this.allMediaFacets.contains(facet)) continue;
                this.allMediaFacets.add(facet);
            }
        } else if (SUPPORTED_ZIP_CONTENT_EXT_POINT.equals(extensionPoint)) {
            this.supportedZipContent = (MimetypeListDescriptor)contribution;
        }
    }

    @Override
    public boolean isDocumentSupported(DocumentModel doc) {
        ActionManager actionService = (ActionManager)Framework.getService(ActionManager.class);
        ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        ELActionContext actionContext = new ELActionContext();
        actionContext.setCurrentDocument(doc);
        Optional filterId = configurationService.getString(INPUT_FILTER_KEY);
        return filterId.isPresent() && actionService.checkFilter((String)filterId.get(), (ActionContext)actionContext);
    }

    @Override
    public boolean isBlobSupported(Blob blob) {
        if (blob == null) {
            return false;
        }
        MimetypeRegistry registry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        String mimetype = registry.getMimetypeFromFilenameAndBlobWithDefault(blob.getFilename(), blob, null);
        if (MIMETYPE_ZIP.equals(mimetype)) {
            return this.getZipContentMimetype(blob) != null;
        }
        return true;
    }

    @Override
    public DocumentModel updateDocumentMediaFacet(DocumentModel doc) {
        Blob blob = (Blob)doc.getPropertyValue("file:content");
        List<String> facets = this.getMediaFacets(blob);
        for (String mediaFacet : this.allMediaFacets) {
            if (facets.contains(mediaFacet)) {
                doc.addFacet(mediaFacet);
                continue;
            }
            if (!doc.hasFacet(mediaFacet)) continue;
            doc.removeFacet(mediaFacet);
        }
        return doc;
    }

    @Override
    public List<String> getMediaFacets(Blob blob) {
        if (blob == null) {
            return new ArrayList<String>();
        }
        String extension = FileUtils.getFileExtension((String)blob.getFilename());
        MimetypeRegistry registry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        String mimetype = registry.getMimetypeFromFilenameAndBlobWithDefault(blob.getFilename(), blob, null);
        if (MIMETYPE_ZIP.equals(mimetype)) {
            mimetype = this.getZipContentMimetype(blob);
        }
        return mimetype != null || extension != null ? this.getMediaFacets(mimetype, extension) : new ArrayList();
    }

    @Override
    public List<String> getMediaFacets(String mimetype, String extension) {
        ArrayList<MediaTypeDescriptor> types = new ArrayList<MediaTypeDescriptor>(this.mediatypes.values());
        types.sort(Comparator.comparingInt(MediaTypeDescriptor::getOrder));
        List<String> facets = new ArrayList<String>();
        Iterator iterator = types.iterator();
        while (facets.size() == 0 && iterator.hasNext()) {
            MediaTypeDescriptor type = (MediaTypeDescriptor)iterator.next();
            if (!type.isEnabled() || !this.doesMimetypeMatchesType(mimetype, type) && !this.doesMatchExtension(extension, type.getExtensions())) continue;
            facets = type.getFacets();
        }
        return facets;
    }

    protected boolean doesMimetypeMatchesType(String mimetype, MediaTypeDescriptor type) {
        if (mimetype != null) {
            for (String mimetypePattern : type.mimetypes) {
                Pattern pattern = Pattern.compile(mimetypePattern);
                if (!pattern.matcher(mimetype).matches()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean doesMatchExtension(String extension, List<String> extensions) {
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            for (String typeExtension : extensions) {
                if (!typeExtension.equalsIgnoreCase(extension)) continue;
                return true;
            }
        }
        return false;
    }

    protected String getZipContentMimetype(Blob zipBlob) {
        MimetypeRegistry registry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        String mimetype = null;
        try (ZipInputStream zipInputStream = new ZipInputStream(zipBlob.getStream());){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory() || zipEntry.getName().startsWith(".")) continue;
                String name = FileManagerUtils.fetchTitle((String)zipEntry.getName());
                String extension = FileUtils.getFileExtension((String)name);
                String entryMimetype = registry.getMimetypeFromFilename(name);
                if (this.supportedZipContent == null || !this.supportedZipContent.getMimetypes().contains(entryMimetype) && !this.doesMatchExtension(extension, this.supportedZipContent.getExtensions())) continue;
                mimetype = entryMimetype;
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mimetype;
    }
}

