/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.media.asset.listener;

import nuxeo.media.asset.service.MediaAssetService;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class MediaAssetListener
implements EventListener {
    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        MediaAssetService mediaAssetService = (MediaAssetService)Framework.getService(MediaAssetService.class);
        if (!mediaAssetService.isDocumentSupported(doc)) {
            return;
        }
        if ("aboutToCreate".equals(event.getName()) || "aboutToImport".equals(event.getName())) {
            mediaAssetService.updateDocumentMediaFacet(doc);
        } else if ("beforeDocumentModification".equals(event.getName())) {
            Property contentProperty = doc.getProperty("file:content");
            if (!contentProperty.isDirty()) {
                return;
            }
            mediaAssetService.updateDocumentMediaFacet(doc);
        }
    }
}

