/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.media.publishing;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.media.publishing.MediaPublishingProvider;
import org.nuxeo.ecm.media.publishing.MediaPublishingProviderDescriptor;
import org.nuxeo.ecm.media.publishing.MediaPublishingService;
import org.nuxeo.ecm.media.publishing.adapter.PublishableMedia;
import org.nuxeo.ecm.media.publishing.upload.MediaPublishingProgressListener;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class MediaPublishingServiceImpl
extends DefaultComponent
implements MediaPublishingService {
    public static final String PROVIDER_EP = "providers";
    protected static final Log log = LogFactory.getLog(MediaPublishingServiceImpl.class);
    protected Map<String, MediaPublishingProvider> providers = new HashMap<String, MediaPublishingProvider>();

    @Override
    public List<String> getAvailableProviders() {
        return new ArrayList<String>(this.providers.keySet());
    }

    @Override
    public MediaPublishingProvider getProvider(String provider) {
        return this.providers.get(provider);
    }

    @Override
    public String publish(DocumentModel doc, String providerId, String account, Map<String, String> options, MediaPublishingProgressListener listener) {
        PublishableMedia media = (PublishableMedia)doc.getAdapter(PublishableMedia.class);
        MediaPublishingProvider provider = ((MediaPublishingService)Framework.getService(MediaPublishingService.class)).getProvider(providerId);
        try {
            String mediaId = provider.upload(media, listener, account, options);
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("externalId", mediaId);
            entry.put("provider", providerId);
            entry.put("account", account);
            entry.put("permalink", provider.getPublishedUrl(mediaId, account));
            media.putProvider(entry);
            CoreSession session = doc.getCoreSession();
            doc.putContextData("VersioningOption", (Serializable)VersioningOption.NONE);
            doc.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
            DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), doc);
            ctx.setComment("Published to " + providerId);
            ctx.setCategory("eventDocumentCategory");
            EventProducer evtProducer = (EventProducer)Framework.getService(EventProducer.class);
            Event event = ctx.newEvent("documentPublished");
            evtProducer.fireEvent(event);
            return mediaId;
        }
        catch (IOException e) {
            log.warn((Object)e);
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public void unpublish(DocumentModel doc, String providerId) {
        MediaPublishingProvider provider = this.getProvider(providerId);
        PublishableMedia media = (PublishableMedia)doc.getAdapter(PublishableMedia.class);
        try {
            if (provider.unpublish(media)) {
                media.removeProvider(providerId);
                CoreSession session = doc.getCoreSession();
                DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), doc);
                ctx.setComment("Video unpublished from " + provider);
                ctx.setCategory("eventDocumentCategory");
                Event event = ctx.newEvent("documentPublished");
                EventProducer evtProducer = (EventProducer)Framework.getService(EventProducer.class);
                evtProducer.fireEvent(event);
            }
        }
        catch (IOException e) {
            log.warn((Object)e);
            throw new NuxeoException("Failed to unpublish media", (Throwable)e);
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (PROVIDER_EP.equals(extensionPoint)) {
            MediaPublishingProviderDescriptor provider = (MediaPublishingProviderDescriptor)contribution;
            try {
                this.providers.put(provider.getId(), (MediaPublishingProvider)provider.getService().getConstructor(String.class).newInstance(provider.getId()));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
    }
}

