/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.media.publishing.automation;

import java.util.Map;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.media.publishing.MediaPublishingService;
import org.nuxeo.ecm.media.publishing.upload.MediaPublishingProgressListener;

@Operation(id="MediaPublish", category="Services", label="Publish Media", description="Publish a Media File to an external service")
public class MediaPublishOp {
    public static final String ID = "MediaPublish";
    @Context
    protected CoreSession session;
    @Context
    protected MediaPublishingService mediaPublishingService;
    @Param(name="xpath", required=false, description="File xpath")
    protected String xpath = "file:content";
    @Param(name="service", description="External service ID")
    protected String service;
    @Param(name="serviceLogin", description="External service ID")
    protected String serviceLogin;
    @Param(name="options", required=false, description="Publishing options")
    protected Properties options = new Properties();

    @OperationMethod
    public DocumentModel run(DocumentModel doc) {
        this.mediaPublishingService.publish(doc, this.service, this.serviceLogin, (Map<String, String>)this.options, new MediaPublishingProgressListener(){

            @Override
            public void onStart() {
            }

            @Override
            public void onProgress(double progress) {
            }

            @Override
            public void onComplete() {
            }

            @Override
            public void onError() {
            }
        });
        this.session.saveDocument(doc);
        return doc;
    }
}

