/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.media.publishing.automation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.media.publishing.MediaPublishingService;

@Operation(id="MediaUnpublish", category="Services", label="Unpublish Media", description="Unpublish a Media File from an external service")
public class MediaUnpublishOp {
    public static final String ID = "MediaUnpublish";
    @Context
    protected CoreSession session;
    @Context
    protected MediaPublishingService mediaPublishingService;
    @Param(name="service", description="External service ID")
    protected String service;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) {
        this.mediaPublishingService.unpublish(doc, this.service);
        this.session.saveDocument(doc);
        return doc;
    }
}

