/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.media.publishing.wistia;

import com.google.api.client.auth.oauth2.Credential;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.media.publishing.OAuth2MediaPublishingProvider;
import org.nuxeo.ecm.media.publishing.adapter.PublishableMedia;
import org.nuxeo.ecm.media.publishing.upload.MediaPublishingProgressListener;
import org.nuxeo.ecm.media.publishing.wistia.WistiaClient;
import org.nuxeo.ecm.media.publishing.wistia.model.Media;
import org.nuxeo.ecm.media.publishing.wistia.model.Project;
import org.nuxeo.ecm.media.publishing.wistia.model.Stats;

public class WistiaService
extends OAuth2MediaPublishingProvider {
    private static final Log log = LogFactory.getLog(WistiaService.class);

    public WistiaService(String providerName) {
        super(providerName);
    }

    public WistiaClient getWistiaClient(String account) {
        Credential credential = this.getCredential(account);
        if (credential == null) {
            return null;
        }
        try {
            Long expiresIn = credential.getExpiresInSeconds();
            if (credential.getAccessToken() == null || expiresIn != null && expiresIn <= 60L) {
                credential.refreshToken();
                if (credential.getAccessToken() == null) {
                    throw new NuxeoException("Failed to refresh access token");
                }
            }
        }
        catch (IOException e) {
            throw new NuxeoException(e.getMessage(), (Throwable)e);
        }
        return new WistiaClient(credential.getAccessToken());
    }

    public String upload(PublishableMedia media, MediaPublishingProgressListener progressListener, String account, Map<String, String> options) throws IOException {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.putSingle((Object)"name", (Object)media.getTitle());
        params.putSingle((Object)"description", (Object)media.getDescription());
        for (Map.Entry<String, String> entry : options.entrySet()) {
            if (entry.getValue() == null || entry.getValue().length() <= 0) continue;
            params.putSingle((Object)entry.getKey(), (Object)entry.getValue());
        }
        Blob blob = media.getBlob();
        Media video = this.getWistiaClient(account).upload(blob.getFilename(), blob.getStream(), (MultivaluedMap<String, String>)params);
        return video.getHashedId();
    }

    public boolean unpublish(PublishableMedia media) {
        String account = media.getAccount(this.providerName);
        String mediaId = media.getId(this.providerName);
        return this.getWistiaClient(account).deleteMedia(mediaId) != null;
    }

    public String getPublishedUrl(String mediaId, String account) {
        WistiaClient client = this.getWistiaClient(account);
        return client == null ? null : client.getAccount().getUrl() + "/medias/" + mediaId;
    }

    public String getEmbedCode(String mediaId, String account) {
        WistiaClient client = this.getWistiaClient(account);
        return client == null ? null : client.getEmbedCode(this.getPublishedUrl(mediaId, account));
    }

    public Map<String, String> getStats(String mediaId, String account) {
        WistiaClient client = this.getWistiaClient(account);
        if (client == null) {
            return null;
        }
        Stats stats = client.getMediaStats(mediaId);
        if (stats == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("label.mediaPublishing.stats.visitors", Integer.toString(stats.getVisitors()));
        map.put("label.mediaPublishing.stats.plays", Integer.toString(stats.getPlays()));
        map.put("label.mediaPublishing.stats.averagePercentWatched", Integer.toString(stats.getAveragePercentWatched()));
        map.put("label.mediaPublishing.stats.pageLoads", Integer.toString(stats.getPageLoads()));
        map.put("label.mediaPublishing.stats.percentOfVisitorsClickingPlay", Integer.toString(stats.getPercentOfVisitorsClickingPlay()));
        return map;
    }

    public boolean isMediaPublished(String mediaId, String account) {
        WistiaClient client = this.getWistiaClient(account);
        if (client == null) {
            return false;
        }
        Media media = client.getMedia(mediaId);
        return media != null;
    }

    public List<Project> getProjects(String account) {
        WistiaClient client = this.getWistiaClient(account);
        return client == null ? Collections.emptyList() : client.getProjects();
    }
}

