/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.media.publishing.facebook;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;

public class FacebookClient {
    public static final String PAGE_ID_KEY = "pageId";
    public static final String TITLE_KEY = "title";
    public static final String DESCRIPTION_KEY = "description";
    public static final String PHOTO_UPLOAD_URL = "https://graph.facebook.com/v11.0/%s/photos";
    public static final String VIDEO_UPLOAD_URL = "https://graph-video.facebook.com/v11.0/%s/videos";
    public static final String GET_POST_URL = "https://graph.facebook.com/v11.0/%s";
    public static int timeoutInMs = 10000;
    protected static CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(timeoutInMs).setConnectionRequestTimeout(timeoutInMs).setSocketTimeout(timeoutInMs).build()).build();
    protected String accessToken;

    public FacebookClient(String accessToken) {
        this.accessToken = accessToken;
    }

    public JSONArray getAccounts() {
        JSONArray jSONArray;
        block9: {
            URIBuilder builder = new URIBuilder("https://graph.facebook.com/v11.0/me/accounts");
            builder.setParameter("access_token", this.accessToken);
            HttpGet httpGet = new HttpGet(builder.build().toString());
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            try {
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new NuxeoException("Couldn't get account. " + IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
                }
                JSONObject object = new JSONObject(new JSONTokener(response.getEntity().getContent()));
                jSONArray = object.getJSONArray("data");
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | URISyntaxException e) {
                    throw new NuxeoException((Throwable)e);
                }
            }
            response.close();
        }
        return jSONArray;
    }

    public String getPageToken(String pageId) {
        JSONArray data = this.getAccounts();
        if (data.length() == 0) {
            throw new NuxeoException(String.format("Page %s not found", pageId));
        }
        Optional<JSONObject> page = IntStream.range(0, data.length()).mapToObj(arg_0 -> ((JSONArray)data).getJSONObject(arg_0)).filter(element -> pageId.equals(element.get("id"))).findFirst();
        if (page.isPresent()) {
            return page.get().getString("access_token");
        }
        throw new NuxeoException(String.format("Couldn't find access token for page %s", pageId));
    }

    public String uploadPhoto(Blob blob, Map<String, String> options) {
        String string;
        block10: {
            String pageId = options.get(PAGE_ID_KEY);
            String pageAccessToken = this.getPageToken(pageId);
            URIBuilder builder = new URIBuilder(String.format(PHOTO_UPLOAD_URL, pageId));
            builder.setParameter("access_token", pageAccessToken);
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().addBinaryBody("source", blob.getStream(), ContentType.create((String)blob.getMimeType()), blob.getFilename());
            String message = options.get(DESCRIPTION_KEY);
            if (StringUtils.isNotBlank((CharSequence)message)) {
                multipartEntityBuilder.addTextBody("message", message);
            }
            HttpPost httpPost = new HttpPost(builder.build().toString());
            httpPost.setEntity(multipartEntityBuilder.build());
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            try {
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new NuxeoException("Couldn't upload photo. " + IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
                }
                JSONObject json = new JSONObject(new JSONTokener(response.getEntity().getContent()));
                string = json.getString("post_id");
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | URISyntaxException e) {
                    throw new NuxeoException((Throwable)e);
                }
            }
            response.close();
        }
        return string;
    }

    public String uploadVideo(Blob blob, Map<String, String> options) {
        String string;
        block10: {
            String pageId = options.get(PAGE_ID_KEY);
            String pageAccessToken = this.getPageToken(pageId);
            URIBuilder builder = new URIBuilder(String.format(VIDEO_UPLOAD_URL, pageId));
            builder.setParameter("access_token", pageAccessToken);
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().addBinaryBody("source", blob.getStream(), ContentType.create((String)blob.getMimeType()), blob.getFilename());
            String message = options.get(DESCRIPTION_KEY);
            if (StringUtils.isNotBlank((CharSequence)message)) {
                multipartEntityBuilder.addTextBody(DESCRIPTION_KEY, message);
            }
            HttpPost httpPost = new HttpPost(builder.build().toString());
            httpPost.setEntity(multipartEntityBuilder.build());
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            try {
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new NuxeoException("Couldn't upload video. " + IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
                }
                JSONObject json = new JSONObject(new JSONTokener(response.getEntity().getContent()));
                string = json.getString("id");
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | URISyntaxException e) {
                    throw new NuxeoException((Throwable)e);
                }
            }
            response.close();
        }
        return string;
    }

    public String getPostPermalink(String postId) {
        String string;
        block10: {
            URIBuilder builder = new URIBuilder(String.format(GET_POST_URL, postId));
            builder.setParameter("access_token", this.accessToken);
            builder.setParameter("fields", "permalink_url");
            HttpGet httpGet = new HttpGet(builder.build().toString());
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            try {
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new NuxeoException("Couldn't get permalink " + IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
                }
                JSONObject object = new JSONObject(new JSONTokener(response.getEntity().getContent()));
                Object url = object.getString("permalink_url");
                if (url != null && ((String)url).startsWith("/")) {
                    url = "https://facebook.com" + (String)url;
                }
                string = url;
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | URISyntaxException e) {
                    throw new NuxeoException((Throwable)e);
                }
            }
            response.close();
        }
        return string;
    }

    public void deletePost(String postId) {
        try {
            URIBuilder builder = new URIBuilder(String.format(GET_POST_URL, postId));
            builder.setParameter("access_token", this.accessToken);
            HttpDelete httpDelete = new HttpDelete(builder.build().toString());
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpDelete);){
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new NuxeoException("Couldn't delete post " + IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new NuxeoException((Throwable)e);
        }
    }
}

