/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.media.publishing.facebook;

import com.google.api.client.auth.oauth2.Credential;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.media.publishing.OAuth2MediaPublishingProvider;
import org.nuxeo.ecm.media.publishing.adapter.PublishableMedia;
import org.nuxeo.ecm.media.publishing.facebook.FacebookClient;
import org.nuxeo.ecm.media.publishing.upload.MediaPublishingProgressListener;

public class FacebookProvider
extends OAuth2MediaPublishingProvider {
    public FacebookProvider(String providerName) {
        super(providerName);
    }

    public FacebookClient getClient(String account) {
        Credential credential = this.getCredential(account);
        String accessToken = credential.getAccessToken();
        return new FacebookClient(accessToken);
    }

    public String upload(PublishableMedia media, MediaPublishingProgressListener progressListener, String account, Map<String, String> options) {
        FacebookClient client = this.getClient(account);
        String renditionName = options.get("renditionName");
        if (media.isPicture()) {
            Blob blob = StringUtils.isNotEmpty((CharSequence)renditionName) ? media.getPictureView(renditionName).getBlob() : media.getBlob();
            return client.uploadPhoto(blob, options);
        }
        if (media.isVideo()) {
            Blob blob = StringUtils.isNotEmpty((CharSequence)renditionName) ? media.getTranscodedVideo(renditionName).getBlob() : media.getBlob();
            return client.uploadVideo(blob, options);
        }
        throw new NuxeoException("Unsupported media type");
    }

    public boolean unpublish(PublishableMedia media) {
        String account = media.getAccount(this.providerName);
        String mediaId = media.getId(this.providerName);
        FacebookClient client = this.getClient(account);
        if (this.isMediaPublished(mediaId, account)) {
            client.deletePost(mediaId);
        }
        return true;
    }

    public String getPublishedUrl(String mediaId, String account) {
        FacebookClient client = this.getClient(account);
        return client.getPostPermalink(mediaId);
    }

    public String getEmbedCode(String mediaId, String account) {
        return null;
    }

    public Map<String, String> getStats(String mediaId, String account) {
        return null;
    }

    public boolean isMediaPublished(String mediaId, String account) {
        return StringUtils.isNotEmpty((CharSequence)this.getPublishedUrl(mediaId, account));
    }
}

