/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.media.publishing.youtube;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.media.MediaHttpUploaderProgressListener;
import com.google.api.client.util.DateTime;
import com.google.api.services.youtube.model.Video;
import com.google.api.services.youtube.model.VideoListResponse;
import com.google.api.services.youtube.model.VideoSnippet;
import com.google.api.services.youtube.model.VideoStatistics;
import com.google.api.services.youtube.model.VideoStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.media.publishing.OAuth2MediaPublishingProvider;
import org.nuxeo.ecm.media.publishing.adapter.PublishableMedia;
import org.nuxeo.ecm.media.publishing.upload.MediaPublishingProgressListener;
import org.nuxeo.ecm.media.publishing.youtube.YouTubeClient;

public class YouTubeService
extends OAuth2MediaPublishingProvider {
    private static final Log log = LogFactory.getLog(YouTubeService.class);

    public YouTubeService(String providerName) {
        super(providerName);
    }

    public YouTubeClient getYouTubeClient(String account) {
        Credential credential = this.getCredential(account);
        return credential != null && credential.getAccessToken() != null ? new YouTubeClient(credential) : null;
    }

    public String upload(PublishableMedia media, MediaPublishingProgressListener progressListener, String account, Map<String, String> options) throws IOException {
        MediaHttpUploaderProgressListener mediaUploaderListener = uploader -> {
            switch (uploader.getUploadState()) {
                case INITIATION_STARTED: 
                case INITIATION_COMPLETE: {
                    progressListener.onStart();
                    break;
                }
                case MEDIA_IN_PROGRESS: {
                    progressListener.onProgress(uploader.getProgress());
                    break;
                }
                case MEDIA_COMPLETE: {
                    progressListener.onComplete();
                    break;
                }
                case NOT_STARTED: {
                    log.info((Object)"Upload Not Started!");
                }
            }
        };
        Video youtubeVideo = new Video();
        VideoStatus status = new VideoStatus();
        String privacyStatus = options.get("privacyStatus");
        status.setPrivacyStatus(StringUtils.isNotEmpty((CharSequence)privacyStatus) ? privacyStatus : "unlisted");
        String publishAt = options.get("publishAt");
        if (StringUtils.isNotEmpty((CharSequence)publishAt)) {
            status.setPublishAt(DateTime.parseRfc3339((String)publishAt));
        }
        youtubeVideo.setStatus(status);
        VideoSnippet snippet = new VideoSnippet();
        String title = options.get("title");
        snippet.setTitle(StringUtils.isNotEmpty((CharSequence)title) ? title : media.getTitle());
        String description = options.get("description");
        snippet.setDescription(StringUtils.isNotEmpty((CharSequence)description) ? description : media.getDescription());
        ArrayList<String> tags = new ArrayList<String>();
        String inputTags = options.get("tags");
        if (inputTags != null) {
            tags.addAll(Arrays.asList(inputTags.split("\\s*,\\s*")));
        }
        snippet.setTags(tags);
        youtubeVideo.setSnippet(snippet);
        String renditionName = options.get("renditionName");
        Blob blob = StringUtils.isNotEmpty((CharSequence)renditionName) ? media.getTranscodedVideo(renditionName).getBlob() : media.getBlob();
        String mimeType = blob.getMimeType();
        long length = blob.getLength();
        youtubeVideo = this.getYouTubeClient(account).upload(youtubeVideo, blob.getStream(), mimeType, length, mediaUploaderListener);
        return youtubeVideo.getId();
    }

    public boolean unpublish(PublishableMedia media) throws IOException {
        String account = media.getAccount(this.providerName);
        String mediaId = media.getId(this.providerName);
        if (!this.isMediaPublished(mediaId, account)) {
            return true;
        }
        return this.getYouTubeClient(account).delete(mediaId);
    }

    public String getPublishedUrl(String mediaId, String account) {
        return "https://www.youtube.com/watch?v=" + mediaId;
    }

    public String getEmbedCode(String mediaId, String account) {
        return mediaId == null ? null : "https://www.youtube.com/embed/" + mediaId;
    }

    public Map<String, String> getStats(String mediaId, String account) {
        YouTubeClient client = this.getYouTubeClient(account);
        if (client == null) {
            return Collections.emptyMap();
        }
        try {
            VideoStatistics stats = client.getStatistics(mediaId);
            if (stats == null) {
                return null;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("label.mediaPublishing.stats.views", stats.getViewCount().toString());
            map.put("label.mediaPublishing.stats.comments", stats.getCommentCount().toString());
            map.put("label.mediaPublishing.stats.likes", stats.getLikeCount().toString());
            map.put("label.mediaPublishing.stats.dislikes", stats.getDislikeCount().toString());
            map.put("label.mediaPublishing.stats.favorites", stats.getFavoriteCount().toString());
            return map;
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isMediaPublished(String mediaId, String account) {
        YouTubeClient client = this.getYouTubeClient(account);
        if (client == null) {
            return false;
        }
        try {
            VideoListResponse list = (VideoListResponse)client.getYouTube().videos().list("id").setId(mediaId).execute();
            return list.getItems().size() > 0;
        }
        catch (IOException e) {
            return false;
        }
    }
}

