/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.media.publishing;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.media.publishing.MediaPublishingProvider;
import org.nuxeo.ecm.media.publishing.MediaPublishingProviderDescriptor;
import org.nuxeo.ecm.media.publishing.MediaPublishingProviderRegistry;
import org.nuxeo.ecm.media.publishing.MediaPublishingService;
import org.nuxeo.ecm.media.publishing.upload.MediaPublishingUploadWork;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class MediaPublishingServiceImpl
extends DefaultComponent
implements MediaPublishingService {
    protected static final Log log = LogFactory.getLog(MediaPublishingServiceImpl.class);
    public static final String PROVIDER_EP = "providers";
    protected MediaPublishingProviderRegistry providers = new MediaPublishingProviderRegistry();

    @Override
    public String[] getAvailableProviders(DocumentModel doc) {
        return this.providers.getServices().toArray(new String[0]);
    }

    @Override
    public MediaPublishingProvider getProvider(String provider) {
        MediaPublishingProviderDescriptor descriptor = this.providers.lookup(provider);
        return (MediaPublishingProvider)Framework.getService((Class)descriptor.getService());
    }

    @Override
    public String publish(DocumentModel doc, String serviceId, String account, Map<String, String> options) {
        MediaPublishingProvider service = this.getProvider(serviceId);
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        if (workManager == null) {
            throw new RuntimeException("No WorkManager available");
        }
        MediaPublishingUploadWork work = new MediaPublishingUploadWork(serviceId, service, doc.getRepositoryName(), doc.getId(), doc.getCoreSession(), account, options);
        workManager.schedule((Work)work, WorkManager.Scheduling.IF_NOT_RUNNING_OR_SCHEDULED);
        return work.getId();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (PROVIDER_EP.equals(extensionPoint)) {
            MediaPublishingProviderDescriptor provider = (MediaPublishingProviderDescriptor)contribution;
            this.providers.addContribution(provider);
        }
    }
}

