/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.media.publishing.adapter;

import java.util.ArrayList;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.media.publishing.MediaPublishingProvider;
import org.nuxeo.ecm.media.publishing.MediaPublishingService;
import org.nuxeo.ecm.media.publishing.adapter.PublishableMedia;
import org.nuxeo.runtime.api.Framework;

public class PublishableMediaAdapter
implements PublishableMedia {
    final DocumentModel doc;

    public PublishableMediaAdapter(DocumentModel doc) {
        this.doc = doc;
    }

    @Override
    public String getProvider() throws ClientException {
        return (String)((Object)this.doc.getPropertyValue("provider"));
    }

    @Override
    public boolean isPublishedByProvider(String provider) throws ClientException {
        ArrayList providers = this.getProviders();
        for (Map entry : providers) {
            if (!entry.containsValue(provider)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList getProviders() throws ClientException {
        return (ArrayList)this.doc.getPropertyValue("pm:providers");
    }

    @Override
    public void setProvider(String name) throws ClientException {
    }

    @Override
    public String getId(String provider) throws ClientException {
        Map<String, Object> entry = this.getProviderEntry(provider);
        if (entry == null) {
            return null;
        }
        return (String)entry.get("externalId");
    }

    @Override
    public String getAccount(String provider) throws ClientException {
        Map<String, Object> entry = this.getProviderEntry(provider);
        if (entry == null) {
            return null;
        }
        return (String)entry.get("account");
    }

    @Override
    public void setId(String id) throws ClientException {
    }

    @Override
    public String getTitle() {
        return this.doc.getTitle();
    }

    @Override
    public String getDescription() {
        return (String)((Object)this.doc.getPropertyValue("dc:description"));
    }

    @Override
    public Blob getBlob() {
        return ((BlobHolder)this.doc.getAdapter(BlobHolder.class)).getBlob();
    }

    @Override
    public String getUrl(String provider) {
        return this.getMediaPublishingProvider(provider).getPublishedUrl(this.getId(provider), this.getAccount(provider));
    }

    @Override
    public String getEmbedCode(String provider) {
        return this.getMediaPublishingProvider(provider).getEmbedCode(this.getId(provider), this.getAccount(provider));
    }

    @Override
    public Map<String, String> getStats(String provider) {
        return this.getMediaPublishingProvider(provider).getStats(this.getId(provider), this.getAccount(provider));
    }

    private MediaPublishingProvider getMediaPublishingProvider(String provider) {
        return this.getMediaPublishingService().getProvider(provider);
    }

    private MediaPublishingService getMediaPublishingService() {
        return (MediaPublishingService)Framework.getService(MediaPublishingService.class);
    }

    private Map<String, Object> getProviderEntry(String provider) {
        ArrayList providers = (ArrayList)this.doc.getPropertyValue("pm:providers");
        for (Map entry : providers) {
            if (!entry.containsValue(provider)) continue;
            return entry;
        }
        return null;
    }
}

