/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.media.publishing.upload;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.media.publishing.MediaPublishingProvider;
import org.nuxeo.ecm.media.publishing.adapter.PublishableMedia;
import org.nuxeo.ecm.media.publishing.upload.MediaPublishingProgressListener;
import org.nuxeo.runtime.api.Framework;

public class MediaPublishingUploadWork
extends AbstractWork {
    public static final String CATEGORY_VIDEO_UPLOAD = "mediaPublishingUpload";
    private final String serviceId;
    private final MediaPublishingProvider service;
    private CoreSession loginSession;
    private String account;
    private Map<String, String> options;
    private static final Log log = LogFactory.getLog(MediaPublishingUploadWork.class);

    public MediaPublishingUploadWork(String serviceId, MediaPublishingProvider service, String repositoryName, String docId, CoreSession loginSession, String account, Map<String, String> options) {
        super(MediaPublishingUploadWork.getIdFor(repositoryName, docId, serviceId));
        this.serviceId = serviceId;
        this.service = service;
        this.loginSession = loginSession;
        this.account = account;
        this.options = options;
        this.setDocument(repositoryName, docId);
    }

    public static String getIdFor(String repositoryName, String docId, String provider) {
        return "media_" + provider + "_upload_" + repositoryName + "_" + docId;
    }

    public String getCategory() {
        return CATEGORY_VIDEO_UPLOAD;
    }

    public String getTitle() {
        return "Video Upload: " + this.docId;
    }

    public void work() {
        final IdRef idRef = new IdRef(this.docId);
        new UnrestrictedSessionRunner(this.repositoryName){

            public void run() throws ClientException {
                DocumentModel doc = this.session.getDocument((DocumentRef)idRef);
                PublishableMedia media = (PublishableMedia)doc.getAdapter(PublishableMedia.class);
                MediaPublishingProgressListener listener = new MediaPublishingProgressListener(){

                    @Override
                    public void onStart() {
                        MediaPublishingUploadWork.this.setProgress(Work.Progress.PROGRESS_0_PC);
                    }

                    @Override
                    public void onProgress(double progress) {
                        MediaPublishingUploadWork.this.setProgress(new Work.Progress(new Float(progress).floatValue()));
                    }

                    @Override
                    public void onComplete() {
                        MediaPublishingUploadWork.this.setProgress(Work.Progress.PROGRESS_100_PC);
                    }

                    @Override
                    public void onError() {
                        MediaPublishingUploadWork.this.setStatus("Error");
                    }
                };
                try {
                    String mediaId = MediaPublishingUploadWork.this.service.upload(media, listener, MediaPublishingUploadWork.this.account, MediaPublishingUploadWork.this.options);
                    ArrayList providers = media.getProviders();
                    HashMap<String, String> entry = new HashMap<String, String>(3);
                    entry.put("externalId", mediaId);
                    entry.put("provider", MediaPublishingUploadWork.this.serviceId);
                    entry.put("account", MediaPublishingUploadWork.this.account);
                    boolean providerExists = false;
                    for (Map e : providers) {
                        if (!e.containsValue(MediaPublishingUploadWork.this.serviceId)) continue;
                        e.replace("externalId", mediaId);
                        e.replace("account", MediaPublishingUploadWork.this.account);
                        providerExists = true;
                    }
                    if (!providerExists) {
                        providers.add(entry);
                    }
                    doc.setPropertyValue("pm:providers", (Serializable)providers);
                    doc.putContextData("VersioningOption", (Serializable)VersioningOption.NONE);
                    doc.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
                    DocumentEventContext ctx = new DocumentEventContext(MediaPublishingUploadWork.this.loginSession, MediaPublishingUploadWork.this.loginSession.getPrincipal(), doc);
                    ctx.setComment("Published to " + MediaPublishingUploadWork.this.serviceId);
                    ctx.setCategory("eventDocumentCategory");
                    EventProducer evtProducer = (EventProducer)Framework.getService(EventProducer.class);
                    Event event = ctx.newEvent("documentPublished");
                    try {
                        evtProducer.fireEvent(event);
                    }
                    catch (ClientException e) {
                        log.error((Object)"Error while sending event", (Throwable)e);
                    }
                    doc.getCoreSession().saveDocument(doc);
                    this.session.save();
                }
                catch (IOException e) {
                    throw new ClientException("Failed to upload media", (Throwable)e);
                }
            }
        }.runUnrestricted();
    }
}

