/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.media.publishing.wistia.rest;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.multipart.MultiPart;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.nuxeo.ecm.media.publishing.wistia.rest.RequestType;
import org.nuxeo.ecm.media.publishing.wistia.rest.RestResponse;

public class RestRequest {
    protected WebResource service;
    protected String path;
    protected RequestType requestType = RequestType.GET;
    protected String data;
    protected Map<String, Object> headers = new HashMap<String, Object>();
    protected MultivaluedMap<String, String> queryParams = new MultivaluedMapImpl();
    protected String contentType = "application/json";

    public RestRequest(WebResource service, String path) {
        this.service = service;
        this.path = path;
    }

    public RestRequest header(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public RestRequest headers(Map<String, Object> headers) {
        this.headers = headers;
        return this;
    }

    public RestRequest queryParam(String key, String value) {
        this.queryParams.add((Object)key, (Object)value);
        return this;
    }

    public RestRequest queryParams(MultivaluedMap<String, String> queryParams) {
        if (queryParams != null) {
            this.queryParams = queryParams;
        }
        return this;
    }

    public RestRequest requestType(RequestType requestType) {
        this.requestType = requestType;
        return this;
    }

    public RestRequest contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public String getData() {
        return this.data;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public MultivaluedMap<String, String> getQueryParams() {
        return this.queryParams;
    }

    public String getContentType() {
        return this.contentType;
    }

    public RestResponse execute(MultiPart multiPart) {
        WebResource wr = this.service;
        wr = wr.path(this.path);
        if (this.queryParams != null && !this.queryParams.isEmpty()) {
            wr = wr.queryParams(this.queryParams);
        }
        WebResource.Builder builder = wr.type(this.contentType);
        for (Map.Entry<String, Object> header : this.headers.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        ClientResponse response = null;
        switch (this.requestType) {
            case GET: {
                response = (ClientResponse)builder.get(ClientResponse.class);
                break;
            }
            case POST: {
                if (multiPart != null) {
                    response = (ClientResponse)builder.post(ClientResponse.class, (Object)multiPart);
                    break;
                }
                response = (ClientResponse)builder.post(ClientResponse.class, (Object)this.data);
                break;
            }
            case PUT: {
                response = (ClientResponse)builder.put(ClientResponse.class, (Object)this.data);
                break;
            }
            case DELETE: {
                response = (ClientResponse)builder.delete(ClientResponse.class, (Object)this.data);
            }
        }
        return new RestResponse(response);
    }

    public RestResponse execute() {
        return this.execute(null);
    }
}

