/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.media.publishing;

import com.google.api.client.auth.oauth2.Credential;
import org.nuxeo.ecm.media.publishing.MediaPublishingProvider;
import org.nuxeo.ecm.media.publishing.adapter.PublishableMedia;
import org.nuxeo.ecm.platform.oauth2.providers.NuxeoOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderRegistry;
import org.nuxeo.runtime.api.Framework;

public abstract class OAuth2MediaPublishingProvider
implements MediaPublishingProvider {
    private final String providerName;

    public OAuth2MediaPublishingProvider(String providerName) {
        this.providerName = providerName;
    }

    protected OAuth2ServiceProvider getOAuth2ServiceProvider() {
        OAuth2ServiceProviderRegistry oAuth2ProviderRegistry = (OAuth2ServiceProviderRegistry)Framework.getService(OAuth2ServiceProviderRegistry.class);
        return oAuth2ProviderRegistry.getProvider(this.providerName);
    }

    protected Credential getCredential(String account) {
        return this.getOAuth2ServiceProvider() != null ? this.getOAuth2ServiceProvider().loadCredential(account) : null;
    }

    @Override
    public boolean isAvailable() {
        NuxeoOAuth2ServiceProvider serviceProvider = (NuxeoOAuth2ServiceProvider)this.getOAuth2ServiceProvider();
        return serviceProvider != null && serviceProvider.isEnabled() && serviceProvider.getClientSecret() != null && serviceProvider.getClientId() != null;
    }

    @Override
    public boolean isMediaAvailable(PublishableMedia media) {
        NuxeoOAuth2ServiceProvider serviceProvider = (NuxeoOAuth2ServiceProvider)this.getOAuth2ServiceProvider();
        String account = media.getAccount(this.providerName);
        return this.isAvailable() && serviceProvider != null && this.getCredential(account) != null;
    }
}

