/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.media.publishing.wistia;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.MultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import com.sun.jersey.multipart.file.StreamDataBodyPart;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.nuxeo.ecm.media.publishing.wistia.model.Account;
import org.nuxeo.ecm.media.publishing.wistia.model.Media;
import org.nuxeo.ecm.media.publishing.wistia.model.Project;
import org.nuxeo.ecm.media.publishing.wistia.model.Stats;
import org.nuxeo.ecm.media.publishing.wistia.rest.RequestType;
import org.nuxeo.ecm.media.publishing.wistia.rest.RestRequest;
import org.nuxeo.ecm.media.publishing.wistia.rest.RestResponse;
import org.nuxeo.ecm.media.publishing.wistia.rest.WistiaResponseParser;

public class WistiaClient {
    private static String BASE_URL = "https://api.wistia.com/v1";
    private static String BASE_UPLOAD_URL = "https://upload.wistia.com";
    private static String BASE_EMBED_URL = "http://fast.wistia.net";
    protected String apiPassword;
    protected WebResource dataService;
    protected WebResource uploadService;
    protected WebResource embedService;

    public WistiaClient(String apiPassword) {
        this.apiPassword = apiPassword;
        this.dataService = new Client().resource(BASE_URL).queryParam("api_password", apiPassword);
        this.uploadService = new Client().resource(BASE_UPLOAD_URL).queryParam("api_password", apiPassword);
        this.embedService = new Client().resource(BASE_EMBED_URL);
    }

    public List<Media> getMedias() {
        RestResponse response = new RestRequest(this.dataService, "medias.json").execute();
        return WistiaResponseParser.asMediaList(response.getClientResponse());
    }

    public Media getMedia(String hashedId) {
        RestResponse response = new RestRequest(this.dataService, "medias/" + hashedId + ".json").execute();
        return WistiaResponseParser.asMedia(response.getClientResponse());
    }

    public Media updateMedia(String hashedId, MultivaluedMap<String, String> queryParams) {
        RestResponse response = new RestRequest(this.dataService, "medias/" + hashedId + ".json").requestType(RequestType.PUT).queryParams(queryParams).execute();
        return WistiaResponseParser.asMedia(response.getClientResponse());
    }

    public Media deleteMedia(String hashedId) {
        RestResponse response = new RestRequest(this.dataService, "medias/" + hashedId + ".json").requestType(RequestType.DELETE).execute();
        return WistiaResponseParser.asMedia(response.getClientResponse());
    }

    public Stats getMediaStats(String hashedId) {
        RestResponse response = new RestRequest(this.dataService, "medias/" + hashedId + "/stats.json").requestType(RequestType.GET).execute();
        return WistiaResponseParser.asMedia(response.getClientResponse()).getStats();
    }

    public Account getAccount() {
        RestResponse response = new RestRequest(this.dataService, "account.json").execute();
        return WistiaResponseParser.asAccount(response.getClientResponse());
    }

    public List<Project> getProjects() {
        RestResponse response = new RestRequest(this.dataService, "projects.json").execute();
        return WistiaResponseParser.asProjectList(response.getClientResponse());
    }

    public Project getProject(String hashedId) {
        RestResponse response = new RestRequest(this.dataService, "projects/" + hashedId + ".json").execute();
        return WistiaResponseParser.asProject(response.getClientResponse());
    }

    public Project createProject(String name, MultivaluedMap<String, String> queryParams) {
        RestResponse response = new RestRequest(this.dataService, "projects.json").requestType(RequestType.POST).queryParams(queryParams).queryParam("name", name).execute();
        return WistiaResponseParser.asProject(response.getClientResponse());
    }

    public Project updateProject(String hashedId, MultivaluedMap<String, String> queryParams) {
        RestResponse response = new RestRequest(this.dataService, "projects/" + hashedId + ".json").requestType(RequestType.PUT).queryParams(queryParams).execute();
        return WistiaResponseParser.asProject(response.getClientResponse());
    }

    public Project deleteProject(String hashedId) {
        RestResponse response = new RestRequest(this.dataService, "projects/" + hashedId + ".json").requestType(RequestType.DELETE).execute();
        return WistiaResponseParser.asProject(response.getClientResponse());
    }

    public Media upload(String url, MultivaluedMap<String, String> queryParams) {
        RestResponse response = new RestRequest(this.uploadService, "").requestType(RequestType.POST).contentType("application/x-www-form-urlencoded").queryParams(queryParams).queryParam("url", url).execute();
        return WistiaResponseParser.asMedia(response.getClientResponse());
    }

    public Media upload(File file, MultivaluedMap<String, String> queryParams) {
        FileDataBodyPart bodyPart = new FileDataBodyPart(file.getName(), file, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        return this.upload((BodyPart)bodyPart, queryParams);
    }

    public Media upload(String filename, InputStream stream, MultivaluedMap<String, String> queryParams) {
        StreamDataBodyPart bodyPart = new StreamDataBodyPart(filename, stream, filename, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        return this.upload((BodyPart)bodyPart, queryParams);
    }

    private Media upload(BodyPart bodyPart, MultivaluedMap<String, String> queryParams) {
        MultiPart multiPart = new MultiPart();
        multiPart.bodyPart(bodyPart);
        RestResponse response = new RestRequest(this.uploadService, "").requestType(RequestType.POST).contentType("multipart/form-data").queryParams(queryParams).execute(multiPart);
        return WistiaResponseParser.asMedia(response.getClientResponse());
    }

    public String getEmbedCode(String mediaUrl) {
        RestResponse response = new RestRequest(this.embedService, "oembed").queryParam("url", mediaUrl).execute();
        if (response.getStatus() == 200) {
            return response.asJson().get("html").getTextValue();
        }
        return null;
    }
}

