/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.media.publishing.youtube;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.googleapis.media.MediaHttpUploaderProgressListener;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.youtube.YouTube;
import com.google.api.services.youtube.model.Channel;
import com.google.api.services.youtube.model.ChannelListResponse;
import com.google.api.services.youtube.model.PlaylistItem;
import com.google.api.services.youtube.model.PlaylistItemListResponse;
import com.google.api.services.youtube.model.Video;
import com.google.api.services.youtube.model.VideoListResponse;
import com.google.api.services.youtube.model.VideoStatistics;
import com.google.api.services.youtube.model.VideoStatus;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderRegistry;
import org.nuxeo.runtime.api.Framework;

public class YouTubeClient {
    private static final Log log = LogFactory.getLog(YouTubeClient.class);
    private static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    YouTube youtube;
    Credential credential;

    public YouTubeClient(Credential credential) {
        this.credential = credential;
    }

    protected OAuth2ServiceProviderRegistry getOAuth2ServiceProviderRegistry() {
        return (OAuth2ServiceProviderRegistry)Framework.getService(OAuth2ServiceProviderRegistry.class);
    }

    public boolean isAuthorized() {
        return this.credential != null && this.credential.getAccessToken() != null;
    }

    public YouTube getYouTube() throws IOException {
        if (this.youtube == null) {
            this.youtube = new YouTube.Builder(HTTP_TRANSPORT, JSON_FACTORY, (HttpRequestInitializer)this.credential).setApplicationName("nuxeo-media-publishing").build();
        }
        return this.youtube;
    }

    public List<Video> getVideos() throws IOException {
        return ((VideoListResponse)this.getYouTube().videos().list("snippet").execute()).getItems();
    }

    public List<Channel> getChannels() throws IOException {
        return ((ChannelListResponse)this.getYouTube().channels().list("snippet").setMine(Boolean.valueOf(true)).execute()).getItems();
    }

    public List<PlaylistItem> getVideos(Channel channel) throws IOException {
        String id = channel.getId();
        return ((PlaylistItemListResponse)this.getYouTube().playlistItems().list("snippet").setPlaylistId(id).execute()).getItems();
    }

    public Video upload(Video video, InputStream stream, String type, long length, MediaHttpUploaderProgressListener uploadListener) throws IOException {
        InputStreamContent mediaContent = new InputStreamContent(type, stream);
        mediaContent.setLength(length);
        YouTube.Videos.Insert insert = this.getYouTube().videos().insert("snippet,status", video, (AbstractInputStreamContent)mediaContent);
        MediaHttpUploader uploader = insert.getMediaHttpUploader();
        uploader.setDirectUploadEnabled(false);
        uploader.setProgressListener(uploadListener);
        Video returnedVideo = (Video)insert.execute();
        if (returnedVideo != null) {
            log.info((Object)"\n================== Returned Video ==================\n");
            log.info((Object)("  - Id: " + returnedVideo.getId()));
            log.info((Object)("  - Title: " + returnedVideo.getSnippet().getTitle()));
            log.info((Object)("  - Tags: " + returnedVideo.getSnippet().getTags()));
            log.info((Object)("  - Privacy Status: " + returnedVideo.getStatus().getPrivacyStatus()));
        }
        return returnedVideo;
    }

    public void setPrivacyStatus(String videoId, String privacyStatus) throws IOException {
        Video youtubeVideo = new Video();
        youtubeVideo.setId(videoId);
        VideoStatus status = new VideoStatus();
        status.setPrivacyStatus(privacyStatus);
        youtubeVideo.setStatus(status);
        this.getYouTube().videos().update("status", youtubeVideo).execute();
    }

    public boolean delete(String videoId) throws IOException {
        YouTube.Videos.Delete deleteRequest = this.getYouTube().videos().delete(videoId);
        return deleteRequest.executeUnparsed().getStatusCode() == 204;
    }

    public VideoStatistics getStatistics(String videoId) throws IOException {
        VideoListResponse list = (VideoListResponse)this.getYouTube().videos().list("statistics").setId(videoId).execute();
        if (list.isEmpty() || list.getItems().size() == 0) {
            return null;
        }
        Video video = (Video)list.getItems().get(0);
        return video.getStatistics();
    }
}

