/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.youtube;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.youtube.YouTubeRequest;
import com.google.api.services.youtube.YouTubeRequestInitializer;
import com.google.api.services.youtube.model.Activity;
import com.google.api.services.youtube.model.ActivityListResponse;
import com.google.api.services.youtube.model.Channel;
import com.google.api.services.youtube.model.ChannelBannerResource;
import com.google.api.services.youtube.model.ChannelListResponse;
import com.google.api.services.youtube.model.ChannelSection;
import com.google.api.services.youtube.model.ChannelSectionListResponse;
import com.google.api.services.youtube.model.GuideCategoryListResponse;
import com.google.api.services.youtube.model.I18nLanguageListResponse;
import com.google.api.services.youtube.model.I18nRegionListResponse;
import com.google.api.services.youtube.model.InvideoBranding;
import com.google.api.services.youtube.model.LiveBroadcast;
import com.google.api.services.youtube.model.LiveBroadcastListResponse;
import com.google.api.services.youtube.model.LiveStream;
import com.google.api.services.youtube.model.LiveStreamListResponse;
import com.google.api.services.youtube.model.Playlist;
import com.google.api.services.youtube.model.PlaylistItem;
import com.google.api.services.youtube.model.PlaylistItemListResponse;
import com.google.api.services.youtube.model.PlaylistListResponse;
import com.google.api.services.youtube.model.SearchListResponse;
import com.google.api.services.youtube.model.Subscription;
import com.google.api.services.youtube.model.SubscriptionListResponse;
import com.google.api.services.youtube.model.ThumbnailSetResponse;
import com.google.api.services.youtube.model.Video;
import com.google.api.services.youtube.model.VideoCategoryListResponse;
import com.google.api.services.youtube.model.VideoGetRatingResponse;
import com.google.api.services.youtube.model.VideoListResponse;
import java.io.IOException;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YouTube
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "youtube/v3/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/youtube/v3/";

    public YouTube(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    YouTube(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Activities activities() {
        return new Activities();
    }

    public ChannelBanners channelBanners() {
        return new ChannelBanners();
    }

    public ChannelSections channelSections() {
        return new ChannelSections();
    }

    public Channels channels() {
        return new Channels();
    }

    public GuideCategories guideCategories() {
        return new GuideCategories();
    }

    public I18nLanguages i18nLanguages() {
        return new I18nLanguages();
    }

    public I18nRegions i18nRegions() {
        return new I18nRegions();
    }

    public LiveBroadcasts liveBroadcasts() {
        return new LiveBroadcasts();
    }

    public LiveStreams liveStreams() {
        return new LiveStreams();
    }

    public PlaylistItems playlistItems() {
        return new PlaylistItems();
    }

    public Playlists playlists() {
        return new Playlists();
    }

    public Search search() {
        return new Search();
    }

    public Subscriptions subscriptions() {
        return new Subscriptions();
    }

    public Thumbnails thumbnails() {
        return new Thumbnails();
    }

    public VideoCategories videoCategories() {
        return new VideoCategories();
    }

    public Videos videos() {
        return new Videos();
    }

    public Watermarks watermarks() {
        return new Watermarks();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.19.0 of the YouTube Data API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, YouTube.DEFAULT_ROOT_URL, YouTube.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public YouTube build() {
            return new YouTube(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setYouTubeRequestInitializer(YouTubeRequestInitializer youTubeRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)youTubeRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Watermarks {
        public Set set(String string, InvideoBranding invideoBranding) throws IOException {
            Set set = new Set(string, invideoBranding);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)set);
            return set;
        }

        public Set set(String string, InvideoBranding invideoBranding, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Set set = new Set(string, invideoBranding, abstractInputStreamContent);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)set);
            return set;
        }

        public Unset unset(String string) throws IOException {
            Unset unset = new Unset(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)unset);
            return unset;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Unset
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "watermarks/unset";
            @Key
            private String channelId;
            @Key
            private String onBehalfOfContentOwner;

            protected Unset(String string) {
                super(YouTube.this, "POST", REST_PATH, null, Void.class);
                this.channelId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter channelId must be specified.");
            }

            public Unset setAlt(String string) {
                return (Unset)super.setAlt(string);
            }

            public Unset setFields(String string) {
                return (Unset)super.setFields(string);
            }

            public Unset setKey(String string) {
                return (Unset)super.setKey(string);
            }

            public Unset setOauthToken(String string) {
                return (Unset)super.setOauthToken(string);
            }

            public Unset setPrettyPrint(Boolean bl) {
                return (Unset)super.setPrettyPrint(bl);
            }

            public Unset setQuotaUser(String string) {
                return (Unset)super.setQuotaUser(string);
            }

            public Unset setUserIp(String string) {
                return (Unset)super.setUserIp(string);
            }

            public String getChannelId() {
                return this.channelId;
            }

            public Unset setChannelId(String string) {
                this.channelId = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Unset setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Unset set(String string, Object object) {
                return (Unset)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Set
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "watermarks/set";
            @Key
            private String channelId;
            @Key
            private String onBehalfOfContentOwner;

            protected Set(String string, InvideoBranding invideoBranding) {
                super(YouTube.this, "POST", REST_PATH, (Object)invideoBranding, Void.class);
                this.channelId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter channelId must be specified.");
            }

            protected Set(String string, InvideoBranding invideoBranding, AbstractInputStreamContent abstractInputStreamContent) {
                super(YouTube.this, "POST", "/upload/" + YouTube.this.getServicePath() + REST_PATH, (Object)invideoBranding, Void.class);
                this.channelId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter channelId must be specified.");
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public Set setAlt(String string) {
                return (Set)super.setAlt(string);
            }

            public Set setFields(String string) {
                return (Set)super.setFields(string);
            }

            public Set setKey(String string) {
                return (Set)super.setKey(string);
            }

            public Set setOauthToken(String string) {
                return (Set)super.setOauthToken(string);
            }

            public Set setPrettyPrint(Boolean bl) {
                return (Set)super.setPrettyPrint(bl);
            }

            public Set setQuotaUser(String string) {
                return (Set)super.setQuotaUser(string);
            }

            public Set setUserIp(String string) {
                return (Set)super.setUserIp(string);
            }

            public String getChannelId() {
                return this.channelId;
            }

            public Set setChannelId(String string) {
                this.channelId = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Set setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Set set(String string, Object object) {
                return (Set)super.set(string, object);
            }
        }
    }

    public class Videos {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public GetRating getRating(String string) throws IOException {
            GetRating getRating = new GetRating(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)getRating);
            return getRating;
        }

        public Insert insert(String string, Video video) throws IOException {
            Insert insert = new Insert(string, video);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public Insert insert(String string, Video video, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Insert insert = new Insert(string, video, abstractInputStreamContent);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Rate rate(String string, String string2) throws IOException {
            Rate rate = new Rate(string, string2);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)rate);
            return rate;
        }

        public Update update(String string, Video video) throws IOException {
            Update update = new Update(string, video);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends YouTubeRequest<Video> {
            private static final String REST_PATH = "videos";
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwner;

            protected Update(String string, Video video) {
                super(YouTube.this, "PUT", REST_PATH, (Object)video, Video.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
                this.checkRequiredParameter((Object)video, "content");
                this.checkRequiredParameter(video.getId(), "Video.getId()");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public Update setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Update setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Rate
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "videos/rate";
            @Key
            private String id;
            @Key
            private String rating;
            @Key
            private String onBehalfOfContentOwner;

            protected Rate(String string, String string2) {
                super(YouTube.this, "POST", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                this.rating = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter rating must be specified.");
            }

            public Rate setAlt(String string) {
                return (Rate)super.setAlt(string);
            }

            public Rate setFields(String string) {
                return (Rate)super.setFields(string);
            }

            public Rate setKey(String string) {
                return (Rate)super.setKey(string);
            }

            public Rate setOauthToken(String string) {
                return (Rate)super.setOauthToken(string);
            }

            public Rate setPrettyPrint(Boolean bl) {
                return (Rate)super.setPrettyPrint(bl);
            }

            public Rate setQuotaUser(String string) {
                return (Rate)super.setQuotaUser(string);
            }

            public Rate setUserIp(String string) {
                return (Rate)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Rate setId(String string) {
                this.id = string;
                return this;
            }

            public String getRating() {
                return this.rating;
            }

            public Rate setRating(String string) {
                this.rating = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Rate setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Rate set(String string, Object object) {
                return (Rate)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends YouTubeRequest<VideoListResponse> {
            private static final String REST_PATH = "videos";
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String regionCode;
            @Key
            private String locale;
            @Key
            private String videoCategoryId;
            @Key
            private String chart;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String myRating;
            @Key
            private String id;

            protected List(String string) {
                super(YouTube.this, "GET", REST_PATH, null, VideoListResponse.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public List setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            public String getRegionCode() {
                return this.regionCode;
            }

            public List setRegionCode(String string) {
                this.regionCode = string;
                return this;
            }

            public String getLocale() {
                return this.locale;
            }

            public List setLocale(String string) {
                this.locale = string;
                return this;
            }

            public String getVideoCategoryId() {
                return this.videoCategoryId;
            }

            public List setVideoCategoryId(String string) {
                this.videoCategoryId = string;
                return this;
            }

            public String getChart() {
                return this.chart;
            }

            public List setChart(String string) {
                this.chart = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getMyRating() {
                return this.myRating;
            }

            public List setMyRating(String string) {
                this.myRating = string;
                return this;
            }

            public String getId() {
                return this.id;
            }

            public List setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends YouTubeRequest<Video> {
            private static final String REST_PATH = "videos";
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private Boolean stabilize;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private Boolean notifySubscribers;
            @Key
            private Boolean autoLevels;

            protected Insert(String string, Video video) {
                super(YouTube.this, "POST", REST_PATH, (Object)video, Video.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            protected Insert(String string, Video video, AbstractInputStreamContent abstractInputStreamContent) {
                super(YouTube.this, "POST", "/upload/" + YouTube.this.getServicePath() + REST_PATH, (Object)video, Video.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public Insert setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            public Boolean getStabilize() {
                return this.stabilize;
            }

            public Insert setStabilize(Boolean bl) {
                this.stabilize = bl;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Insert setOnBehalfOfContentOwnerChannel(String string) {
                this.onBehalfOfContentOwnerChannel = string;
                return this;
            }

            public Boolean getNotifySubscribers() {
                return this.notifySubscribers;
            }

            public Insert setNotifySubscribers(Boolean bl) {
                this.notifySubscribers = bl;
                return this;
            }

            public boolean isNotifySubscribers() {
                if (this.notifySubscribers == null || this.notifySubscribers == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.notifySubscribers;
            }

            public Boolean getAutoLevels() {
                return this.autoLevels;
            }

            public Insert setAutoLevels(Boolean bl) {
                this.autoLevels = bl;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetRating
        extends YouTubeRequest<VideoGetRatingResponse> {
            private static final String REST_PATH = "videos/getRating";
            @Key
            private String id;
            @Key
            private String onBehalfOfContentOwner;

            protected GetRating(String string) {
                super(YouTube.this, "GET", REST_PATH, null, VideoGetRatingResponse.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetRating setAlt(String string) {
                return (GetRating)super.setAlt(string);
            }

            public GetRating setFields(String string) {
                return (GetRating)super.setFields(string);
            }

            public GetRating setKey(String string) {
                return (GetRating)super.setKey(string);
            }

            public GetRating setOauthToken(String string) {
                return (GetRating)super.setOauthToken(string);
            }

            public GetRating setPrettyPrint(Boolean bl) {
                return (GetRating)super.setPrettyPrint(bl);
            }

            public GetRating setQuotaUser(String string) {
                return (GetRating)super.setQuotaUser(string);
            }

            public GetRating setUserIp(String string) {
                return (GetRating)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public GetRating setId(String string) {
                this.id = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public GetRating setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public GetRating set(String string, Object object) {
                return (GetRating)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "videos";
            @Key
            private String id;
            @Key
            private String onBehalfOfContentOwner;

            protected Delete(String string) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String string) {
                this.id = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Delete setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class VideoCategories {
        public List list(String string) throws IOException {
            List list = new List(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends YouTubeRequest<VideoCategoryListResponse> {
            private static final String REST_PATH = "videoCategories";
            @Key
            private String part;
            @Key
            private String regionCode;
            @Key
            private String id;
            @Key
            private String hl;

            protected List(String string) {
                super(YouTube.this, "GET", REST_PATH, null, VideoCategoryListResponse.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public List setPart(String string) {
                this.part = string;
                return this;
            }

            public String getRegionCode() {
                return this.regionCode;
            }

            public List setRegionCode(String string) {
                this.regionCode = string;
                return this;
            }

            public String getId() {
                return this.id;
            }

            public List setId(String string) {
                this.id = string;
                return this;
            }

            public String getHl() {
                return this.hl;
            }

            public List setHl(String string) {
                this.hl = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class Thumbnails {
        public Set set(String string) throws IOException {
            Set set = new Set(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)set);
            return set;
        }

        public Set set(String string, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Set set = new Set(string, abstractInputStreamContent);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)set);
            return set;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Set
        extends YouTubeRequest<ThumbnailSetResponse> {
            private static final String REST_PATH = "thumbnails/set";
            @Key
            private String videoId;
            @Key
            private String onBehalfOfContentOwner;

            protected Set(String string) {
                super(YouTube.this, "POST", REST_PATH, null, ThumbnailSetResponse.class);
                this.videoId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter videoId must be specified.");
            }

            protected Set(String string, AbstractInputStreamContent abstractInputStreamContent) {
                super(YouTube.this, "POST", "/upload/" + YouTube.this.getServicePath() + REST_PATH, null, ThumbnailSetResponse.class);
                this.videoId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter videoId must be specified.");
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public Set setAlt(String string) {
                return (Set)super.setAlt(string);
            }

            public Set setFields(String string) {
                return (Set)super.setFields(string);
            }

            public Set setKey(String string) {
                return (Set)super.setKey(string);
            }

            public Set setOauthToken(String string) {
                return (Set)super.setOauthToken(string);
            }

            public Set setPrettyPrint(Boolean bl) {
                return (Set)super.setPrettyPrint(bl);
            }

            public Set setQuotaUser(String string) {
                return (Set)super.setQuotaUser(string);
            }

            public Set setUserIp(String string) {
                return (Set)super.setUserIp(string);
            }

            public String getVideoId() {
                return this.videoId;
            }

            public Set setVideoId(String string) {
                this.videoId = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Set setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Set set(String string, Object object) {
                return (Set)super.set(string, object);
            }
        }
    }

    public class Subscriptions {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Insert insert(String string, Subscription subscription) throws IOException {
            Insert insert = new Insert(string, subscription);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends YouTubeRequest<SubscriptionListResponse> {
            private static final String REST_PATH = "subscriptions";
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private String channelId;
            @Key
            private Boolean mine;
            @Key
            private Long maxResults;
            @Key
            private String forChannelId;
            @Key
            private String pageToken;
            @Key
            private Boolean mySubscribers;
            @Key
            private String order;
            @Key
            private String id;

            protected List(String string) {
                super(YouTube.this, "GET", REST_PATH, null, SubscriptionListResponse.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public List setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public List setOnBehalfOfContentOwnerChannel(String string) {
                this.onBehalfOfContentOwnerChannel = string;
                return this;
            }

            public String getChannelId() {
                return this.channelId;
            }

            public List setChannelId(String string) {
                this.channelId = string;
                return this;
            }

            public Boolean getMine() {
                return this.mine;
            }

            public List setMine(Boolean bl) {
                this.mine = bl;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getForChannelId() {
                return this.forChannelId;
            }

            public List setForChannelId(String string) {
                this.forChannelId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Boolean getMySubscribers() {
                return this.mySubscribers;
            }

            public List setMySubscribers(Boolean bl) {
                this.mySubscribers = bl;
                return this;
            }

            public String getOrder() {
                return this.order;
            }

            public List setOrder(String string) {
                this.order = string;
                return this;
            }

            public String getId() {
                return this.id;
            }

            public List setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends YouTubeRequest<Subscription> {
            private static final String REST_PATH = "subscriptions";
            @Key
            private String part;

            protected Insert(String string, Subscription subscription) {
                super(YouTube.this, "POST", REST_PATH, (Object)subscription, Subscription.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public Insert setPart(String string) {
                this.part = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "subscriptions";
            @Key
            private String id;

            protected Delete(String string) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Search {
        public List list(String string) throws IOException {
            List list = new List(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends YouTubeRequest<SearchListResponse> {
            private static final String REST_PATH = "search";
            @Key
            private String part;
            @Key
            private String eventType;
            @Key
            private String channelId;
            @Key
            private String videoSyndicated;
            @Key
            private String channelType;
            @Key
            private String videoCaption;
            @Key
            private DateTime publishedAfter;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String pageToken;
            @Key
            private Boolean forContentOwner;
            @Key
            private String regionCode;
            @Key
            private String location;
            @Key
            private String locationRadius;
            @Key
            private String videoType;
            @Key
            private String type;
            @Key
            private String topicId;
            @Key
            private DateTime publishedBefore;
            @Key
            private String videoDimension;
            @Key
            private String videoLicense;
            @Key
            private Long maxResults;
            @Key
            private String relatedToVideoId;
            @Key
            private String videoDefinition;
            @Key
            private String videoDuration;
            @Key
            private Boolean forMine;
            @Key
            private String q;
            @Key
            private String safeSearch;
            @Key
            private String videoEmbeddable;
            @Key
            private String videoCategoryId;
            @Key
            private String order;

            protected List(String string) {
                super(YouTube.this, "GET", REST_PATH, null, SearchListResponse.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public List setPart(String string) {
                this.part = string;
                return this;
            }

            public String getEventType() {
                return this.eventType;
            }

            public List setEventType(String string) {
                this.eventType = string;
                return this;
            }

            public String getChannelId() {
                return this.channelId;
            }

            public List setChannelId(String string) {
                this.channelId = string;
                return this;
            }

            public String getVideoSyndicated() {
                return this.videoSyndicated;
            }

            public List setVideoSyndicated(String string) {
                this.videoSyndicated = string;
                return this;
            }

            public String getChannelType() {
                return this.channelType;
            }

            public List setChannelType(String string) {
                this.channelType = string;
                return this;
            }

            public String getVideoCaption() {
                return this.videoCaption;
            }

            public List setVideoCaption(String string) {
                this.videoCaption = string;
                return this;
            }

            public DateTime getPublishedAfter() {
                return this.publishedAfter;
            }

            public List setPublishedAfter(DateTime dateTime) {
                this.publishedAfter = dateTime;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Boolean getForContentOwner() {
                return this.forContentOwner;
            }

            public List setForContentOwner(Boolean bl) {
                this.forContentOwner = bl;
                return this;
            }

            public String getRegionCode() {
                return this.regionCode;
            }

            public List setRegionCode(String string) {
                this.regionCode = string;
                return this;
            }

            public String getLocation() {
                return this.location;
            }

            public List setLocation(String string) {
                this.location = string;
                return this;
            }

            public String getLocationRadius() {
                return this.locationRadius;
            }

            public List setLocationRadius(String string) {
                this.locationRadius = string;
                return this;
            }

            public String getVideoType() {
                return this.videoType;
            }

            public List setVideoType(String string) {
                this.videoType = string;
                return this;
            }

            public String getType() {
                return this.type;
            }

            public List setType(String string) {
                this.type = string;
                return this;
            }

            public String getTopicId() {
                return this.topicId;
            }

            public List setTopicId(String string) {
                this.topicId = string;
                return this;
            }

            public DateTime getPublishedBefore() {
                return this.publishedBefore;
            }

            public List setPublishedBefore(DateTime dateTime) {
                this.publishedBefore = dateTime;
                return this;
            }

            public String getVideoDimension() {
                return this.videoDimension;
            }

            public List setVideoDimension(String string) {
                this.videoDimension = string;
                return this;
            }

            public String getVideoLicense() {
                return this.videoLicense;
            }

            public List setVideoLicense(String string) {
                this.videoLicense = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getRelatedToVideoId() {
                return this.relatedToVideoId;
            }

            public List setRelatedToVideoId(String string) {
                this.relatedToVideoId = string;
                return this;
            }

            public String getVideoDefinition() {
                return this.videoDefinition;
            }

            public List setVideoDefinition(String string) {
                this.videoDefinition = string;
                return this;
            }

            public String getVideoDuration() {
                return this.videoDuration;
            }

            public List setVideoDuration(String string) {
                this.videoDuration = string;
                return this;
            }

            public Boolean getForMine() {
                return this.forMine;
            }

            public List setForMine(Boolean bl) {
                this.forMine = bl;
                return this;
            }

            public String getQ() {
                return this.q;
            }

            public List setQ(String string) {
                this.q = string;
                return this;
            }

            public String getSafeSearch() {
                return this.safeSearch;
            }

            public List setSafeSearch(String string) {
                this.safeSearch = string;
                return this;
            }

            public String getVideoEmbeddable() {
                return this.videoEmbeddable;
            }

            public List setVideoEmbeddable(String string) {
                this.videoEmbeddable = string;
                return this;
            }

            public String getVideoCategoryId() {
                return this.videoCategoryId;
            }

            public List setVideoCategoryId(String string) {
                this.videoCategoryId = string;
                return this;
            }

            public String getOrder() {
                return this.order;
            }

            public List setOrder(String string) {
                this.order = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class Playlists {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Insert insert(String string, Playlist playlist) throws IOException {
            Insert insert = new Insert(string, playlist);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Update update(String string, Playlist playlist) throws IOException {
            Update update = new Update(string, playlist);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends YouTubeRequest<Playlist> {
            private static final String REST_PATH = "playlists";
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwner;

            protected Update(String string, Playlist playlist) {
                super(YouTube.this, "PUT", REST_PATH, (Object)playlist, Playlist.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public Update setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Update setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends YouTubeRequest<PlaylistListResponse> {
            private static final String REST_PATH = "playlists";
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private String channelId;
            @Key
            private Boolean mine;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String id;

            protected List(String string) {
                super(YouTube.this, "GET", REST_PATH, null, PlaylistListResponse.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public List setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public List setOnBehalfOfContentOwnerChannel(String string) {
                this.onBehalfOfContentOwnerChannel = string;
                return this;
            }

            public String getChannelId() {
                return this.channelId;
            }

            public List setChannelId(String string) {
                this.channelId = string;
                return this;
            }

            public Boolean getMine() {
                return this.mine;
            }

            public List setMine(Boolean bl) {
                this.mine = bl;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getId() {
                return this.id;
            }

            public List setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends YouTubeRequest<Playlist> {
            private static final String REST_PATH = "playlists";
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private String onBehalfOfContentOwner;

            protected Insert(String string, Playlist playlist) {
                super(YouTube.this, "POST", REST_PATH, (Object)playlist, Playlist.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public Insert setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Insert setOnBehalfOfContentOwnerChannel(String string) {
                this.onBehalfOfContentOwnerChannel = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "playlists";
            @Key
            private String id;
            @Key
            private String onBehalfOfContentOwner;

            protected Delete(String string) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String string) {
                this.id = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Delete setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class PlaylistItems {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Insert insert(String string, PlaylistItem playlistItem) throws IOException {
            Insert insert = new Insert(string, playlistItem);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Update update(String string, PlaylistItem playlistItem) throws IOException {
            Update update = new Update(string, playlistItem);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends YouTubeRequest<PlaylistItem> {
            private static final String REST_PATH = "playlistItems";
            @Key
            private String part;

            protected Update(String string, PlaylistItem playlistItem) {
                super(YouTube.this, "PUT", REST_PATH, (Object)playlistItem, PlaylistItem.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public Update setPart(String string) {
                this.part = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends YouTubeRequest<PlaylistItemListResponse> {
            private static final String REST_PATH = "playlistItems";
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String playlistId;
            @Key
            private String videoId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String id;

            protected List(String string) {
                super(YouTube.this, "GET", REST_PATH, null, PlaylistItemListResponse.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public List setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            public String getPlaylistId() {
                return this.playlistId;
            }

            public List setPlaylistId(String string) {
                this.playlistId = string;
                return this;
            }

            public String getVideoId() {
                return this.videoId;
            }

            public List setVideoId(String string) {
                this.videoId = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getId() {
                return this.id;
            }

            public List setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends YouTubeRequest<PlaylistItem> {
            private static final String REST_PATH = "playlistItems";
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwner;

            protected Insert(String string, PlaylistItem playlistItem) {
                super(YouTube.this, "POST", REST_PATH, (Object)playlistItem, PlaylistItem.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public Insert setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "playlistItems";
            @Key
            private String id;

            protected Delete(String string) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class LiveStreams {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Insert insert(String string, LiveStream liveStream) throws IOException {
            Insert insert = new Insert(string, liveStream);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Update update(String string, LiveStream liveStream) throws IOException {
            Update update = new Update(string, liveStream);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends YouTubeRequest<LiveStream> {
            private static final String REST_PATH = "liveStreams";
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private String onBehalfOfContentOwner;

            protected Update(String string, LiveStream liveStream) {
                super(YouTube.this, "PUT", REST_PATH, (Object)liveStream, LiveStream.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
                this.checkRequiredParameter((Object)liveStream, "content");
                this.checkRequiredParameter(liveStream.getId(), "LiveStream.getId()");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public Update setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Update setOnBehalfOfContentOwnerChannel(String string) {
                this.onBehalfOfContentOwnerChannel = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Update setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends YouTubeRequest<LiveStreamListResponse> {
            private static final String REST_PATH = "liveStreams";
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private Boolean mine;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String id;

            protected List(String string) {
                super(YouTube.this, "GET", REST_PATH, null, LiveStreamListResponse.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public List setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public List setOnBehalfOfContentOwnerChannel(String string) {
                this.onBehalfOfContentOwnerChannel = string;
                return this;
            }

            public Boolean getMine() {
                return this.mine;
            }

            public List setMine(Boolean bl) {
                this.mine = bl;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getId() {
                return this.id;
            }

            public List setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends YouTubeRequest<LiveStream> {
            private static final String REST_PATH = "liveStreams";
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private String onBehalfOfContentOwner;

            protected Insert(String string, LiveStream liveStream) {
                super(YouTube.this, "POST", REST_PATH, (Object)liveStream, LiveStream.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public Insert setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Insert setOnBehalfOfContentOwnerChannel(String string) {
                this.onBehalfOfContentOwnerChannel = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "liveStreams";
            @Key
            private String id;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private String onBehalfOfContentOwner;

            protected Delete(String string) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String string) {
                this.id = string;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Delete setOnBehalfOfContentOwnerChannel(String string) {
                this.onBehalfOfContentOwnerChannel = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Delete setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class LiveBroadcasts {
        public Bind bind(String string, String string2) throws IOException {
            Bind bind = new Bind(string, string2);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)bind);
            return bind;
        }

        public Control control(String string, String string2) throws IOException {
            Control control = new Control(string, string2);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)control);
            return control;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Insert insert(String string, LiveBroadcast liveBroadcast) throws IOException {
            Insert insert = new Insert(string, liveBroadcast);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Transition transition(String string, String string2, String string3) throws IOException {
            Transition transition = new Transition(string, string2, string3);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)transition);
            return transition;
        }

        public Update update(String string, LiveBroadcast liveBroadcast) throws IOException {
            Update update = new Update(string, liveBroadcast);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends YouTubeRequest<LiveBroadcast> {
            private static final String REST_PATH = "liveBroadcasts";
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private String onBehalfOfContentOwner;

            protected Update(String string, LiveBroadcast liveBroadcast) {
                super(YouTube.this, "PUT", REST_PATH, (Object)liveBroadcast, LiveBroadcast.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
                this.checkRequiredParameter((Object)liveBroadcast, "content");
                this.checkRequiredParameter(liveBroadcast.getId(), "LiveBroadcast.getId()");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public Update setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Update setOnBehalfOfContentOwnerChannel(String string) {
                this.onBehalfOfContentOwnerChannel = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Update setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Transition
        extends YouTubeRequest<LiveBroadcast> {
            private static final String REST_PATH = "liveBroadcasts/transition";
            @Key
            private String broadcastStatus;
            @Key
            private String id;
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private String onBehalfOfContentOwner;

            protected Transition(String string, String string2, String string3) {
                super(YouTube.this, "POST", REST_PATH, null, LiveBroadcast.class);
                this.broadcastStatus = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter broadcastStatus must be specified.");
                this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                this.part = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter part must be specified.");
            }

            public Transition setAlt(String string) {
                return (Transition)super.setAlt(string);
            }

            public Transition setFields(String string) {
                return (Transition)super.setFields(string);
            }

            public Transition setKey(String string) {
                return (Transition)super.setKey(string);
            }

            public Transition setOauthToken(String string) {
                return (Transition)super.setOauthToken(string);
            }

            public Transition setPrettyPrint(Boolean bl) {
                return (Transition)super.setPrettyPrint(bl);
            }

            public Transition setQuotaUser(String string) {
                return (Transition)super.setQuotaUser(string);
            }

            public Transition setUserIp(String string) {
                return (Transition)super.setUserIp(string);
            }

            public String getBroadcastStatus() {
                return this.broadcastStatus;
            }

            public Transition setBroadcastStatus(String string) {
                this.broadcastStatus = string;
                return this;
            }

            public String getId() {
                return this.id;
            }

            public Transition setId(String string) {
                this.id = string;
                return this;
            }

            public String getPart() {
                return this.part;
            }

            public Transition setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Transition setOnBehalfOfContentOwnerChannel(String string) {
                this.onBehalfOfContentOwnerChannel = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Transition setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Transition set(String string, Object object) {
                return (Transition)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends YouTubeRequest<LiveBroadcastListResponse> {
            private static final String REST_PATH = "liveBroadcasts";
            @Key
            private String part;
            @Key
            private String broadcastStatus;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private Boolean mine;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String id;

            protected List(String string) {
                super(YouTube.this, "GET", REST_PATH, null, LiveBroadcastListResponse.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public List setPart(String string) {
                this.part = string;
                return this;
            }

            public String getBroadcastStatus() {
                return this.broadcastStatus;
            }

            public List setBroadcastStatus(String string) {
                this.broadcastStatus = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public List setOnBehalfOfContentOwnerChannel(String string) {
                this.onBehalfOfContentOwnerChannel = string;
                return this;
            }

            public Boolean getMine() {
                return this.mine;
            }

            public List setMine(Boolean bl) {
                this.mine = bl;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getId() {
                return this.id;
            }

            public List setId(String string) {
                this.id = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends YouTubeRequest<LiveBroadcast> {
            private static final String REST_PATH = "liveBroadcasts";
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private String onBehalfOfContentOwner;

            protected Insert(String string, LiveBroadcast liveBroadcast) {
                super(YouTube.this, "POST", REST_PATH, (Object)liveBroadcast, LiveBroadcast.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public Insert setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Insert setOnBehalfOfContentOwnerChannel(String string) {
                this.onBehalfOfContentOwnerChannel = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "liveBroadcasts";
            @Key
            private String id;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private String onBehalfOfContentOwner;

            protected Delete(String string) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String string) {
                this.id = string;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Delete setOnBehalfOfContentOwnerChannel(String string) {
                this.onBehalfOfContentOwnerChannel = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Delete setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Control
        extends YouTubeRequest<LiveBroadcast> {
            private static final String REST_PATH = "liveBroadcasts/control";
            @Key
            private String id;
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private Boolean displaySlate;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private BigInteger offsetTimeMs;
            @Key
            private DateTime walltime;

            protected Control(String string, String string2) {
                super(YouTube.this, "POST", REST_PATH, null, LiveBroadcast.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                this.part = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter part must be specified.");
            }

            public Control setAlt(String string) {
                return (Control)super.setAlt(string);
            }

            public Control setFields(String string) {
                return (Control)super.setFields(string);
            }

            public Control setKey(String string) {
                return (Control)super.setKey(string);
            }

            public Control setOauthToken(String string) {
                return (Control)super.setOauthToken(string);
            }

            public Control setPrettyPrint(Boolean bl) {
                return (Control)super.setPrettyPrint(bl);
            }

            public Control setQuotaUser(String string) {
                return (Control)super.setQuotaUser(string);
            }

            public Control setUserIp(String string) {
                return (Control)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Control setId(String string) {
                this.id = string;
                return this;
            }

            public String getPart() {
                return this.part;
            }

            public Control setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Control setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            public Boolean getDisplaySlate() {
                return this.displaySlate;
            }

            public Control setDisplaySlate(Boolean bl) {
                this.displaySlate = bl;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Control setOnBehalfOfContentOwnerChannel(String string) {
                this.onBehalfOfContentOwnerChannel = string;
                return this;
            }

            public BigInteger getOffsetTimeMs() {
                return this.offsetTimeMs;
            }

            public Control setOffsetTimeMs(BigInteger bigInteger) {
                this.offsetTimeMs = bigInteger;
                return this;
            }

            public DateTime getWalltime() {
                return this.walltime;
            }

            public Control setWalltime(DateTime dateTime) {
                this.walltime = dateTime;
                return this;
            }

            @Override
            public Control set(String string, Object object) {
                return (Control)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Bind
        extends YouTubeRequest<LiveBroadcast> {
            private static final String REST_PATH = "liveBroadcasts/bind";
            @Key
            private String id;
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String streamId;

            protected Bind(String string, String string2) {
                super(YouTube.this, "POST", REST_PATH, null, LiveBroadcast.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                this.part = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter part must be specified.");
            }

            public Bind setAlt(String string) {
                return (Bind)super.setAlt(string);
            }

            public Bind setFields(String string) {
                return (Bind)super.setFields(string);
            }

            public Bind setKey(String string) {
                return (Bind)super.setKey(string);
            }

            public Bind setOauthToken(String string) {
                return (Bind)super.setOauthToken(string);
            }

            public Bind setPrettyPrint(Boolean bl) {
                return (Bind)super.setPrettyPrint(bl);
            }

            public Bind setQuotaUser(String string) {
                return (Bind)super.setQuotaUser(string);
            }

            public Bind setUserIp(String string) {
                return (Bind)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Bind setId(String string) {
                this.id = string;
                return this;
            }

            public String getPart() {
                return this.part;
            }

            public Bind setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Bind setOnBehalfOfContentOwnerChannel(String string) {
                this.onBehalfOfContentOwnerChannel = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Bind setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            public String getStreamId() {
                return this.streamId;
            }

            public Bind setStreamId(String string) {
                this.streamId = string;
                return this;
            }

            @Override
            public Bind set(String string, Object object) {
                return (Bind)super.set(string, object);
            }
        }
    }

    public class I18nRegions {
        public List list(String string) throws IOException {
            List list = new List(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends YouTubeRequest<I18nRegionListResponse> {
            private static final String REST_PATH = "i18nRegions";
            @Key
            private String part;
            @Key
            private String hl;

            protected List(String string) {
                super(YouTube.this, "GET", REST_PATH, null, I18nRegionListResponse.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public List setPart(String string) {
                this.part = string;
                return this;
            }

            public String getHl() {
                return this.hl;
            }

            public List setHl(String string) {
                this.hl = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class I18nLanguages {
        public List list(String string) throws IOException {
            List list = new List(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends YouTubeRequest<I18nLanguageListResponse> {
            private static final String REST_PATH = "i18nLanguages";
            @Key
            private String part;
            @Key
            private String hl;

            protected List(String string) {
                super(YouTube.this, "GET", REST_PATH, null, I18nLanguageListResponse.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public List setPart(String string) {
                this.part = string;
                return this;
            }

            public String getHl() {
                return this.hl;
            }

            public List setHl(String string) {
                this.hl = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class GuideCategories {
        public List list(String string) throws IOException {
            List list = new List(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends YouTubeRequest<GuideCategoryListResponse> {
            private static final String REST_PATH = "guideCategories";
            @Key
            private String part;
            @Key
            private String regionCode;
            @Key
            private String id;
            @Key
            private String hl;

            protected List(String string) {
                super(YouTube.this, "GET", REST_PATH, null, GuideCategoryListResponse.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public List setPart(String string) {
                this.part = string;
                return this;
            }

            public String getRegionCode() {
                return this.regionCode;
            }

            public List setRegionCode(String string) {
                this.regionCode = string;
                return this;
            }

            public String getId() {
                return this.id;
            }

            public List setId(String string) {
                this.id = string;
                return this;
            }

            public String getHl() {
                return this.hl;
            }

            public List setHl(String string) {
                this.hl = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class Channels {
        public List list(String string) throws IOException {
            List list = new List(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Update update(String string, Channel channel) throws IOException {
            Update update = new Update(string, channel);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends YouTubeRequest<Channel> {
            private static final String REST_PATH = "channels";
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwner;

            protected Update(String string, Channel channel) {
                super(YouTube.this, "PUT", REST_PATH, (Object)channel, Channel.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public Update setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Update setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends YouTubeRequest<ChannelListResponse> {
            private static final String REST_PATH = "channels";
            @Key
            private String part;
            @Key
            private Boolean managedByMe;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String forUsername;
            @Key
            private Boolean mine;
            @Key
            private Long maxResults;
            @Key
            private String id;
            @Key
            private String pageToken;
            @Key
            private Boolean mySubscribers;
            @Key
            private String categoryId;

            protected List(String string) {
                super(YouTube.this, "GET", REST_PATH, null, ChannelListResponse.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public List setPart(String string) {
                this.part = string;
                return this;
            }

            public Boolean getManagedByMe() {
                return this.managedByMe;
            }

            public List setManagedByMe(Boolean bl) {
                this.managedByMe = bl;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            public String getForUsername() {
                return this.forUsername;
            }

            public List setForUsername(String string) {
                this.forUsername = string;
                return this;
            }

            public Boolean getMine() {
                return this.mine;
            }

            public List setMine(Boolean bl) {
                this.mine = bl;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getId() {
                return this.id;
            }

            public List setId(String string) {
                this.id = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Boolean getMySubscribers() {
                return this.mySubscribers;
            }

            public List setMySubscribers(Boolean bl) {
                this.mySubscribers = bl;
                return this;
            }

            public String getCategoryId() {
                return this.categoryId;
            }

            public List setCategoryId(String string) {
                this.categoryId = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class ChannelSections {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Insert insert(String string, ChannelSection channelSection) throws IOException {
            Insert insert = new Insert(string, channelSection);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Update update(String string, ChannelSection channelSection) throws IOException {
            Update update = new Update(string, channelSection);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends YouTubeRequest<ChannelSection> {
            private static final String REST_PATH = "channelSections";
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwner;

            protected Update(String string, ChannelSection channelSection) {
                super(YouTube.this, "PUT", REST_PATH, (Object)channelSection, ChannelSection.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public Update setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Update setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends YouTubeRequest<ChannelSectionListResponse> {
            private static final String REST_PATH = "channelSections";
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwner;
            @Key
            private String channelId;
            @Key
            private String id;
            @Key
            private Boolean mine;

            protected List(String string) {
                super(YouTube.this, "GET", REST_PATH, null, ChannelSectionListResponse.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public List setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public List setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            public String getChannelId() {
                return this.channelId;
            }

            public List setChannelId(String string) {
                this.channelId = string;
                return this;
            }

            public String getId() {
                return this.id;
            }

            public List setId(String string) {
                this.id = string;
                return this;
            }

            public Boolean getMine() {
                return this.mine;
            }

            public List setMine(Boolean bl) {
                this.mine = bl;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends YouTubeRequest<ChannelSection> {
            private static final String REST_PATH = "channelSections";
            @Key
            private String part;
            @Key
            private String onBehalfOfContentOwnerChannel;
            @Key
            private String onBehalfOfContentOwner;

            protected Insert(String string, ChannelSection channelSection) {
                super(YouTube.this, "POST", REST_PATH, (Object)channelSection, ChannelSection.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public Insert setPart(String string) {
                this.part = string;
                return this;
            }

            public String getOnBehalfOfContentOwnerChannel() {
                return this.onBehalfOfContentOwnerChannel;
            }

            public Insert setOnBehalfOfContentOwnerChannel(String string) {
                this.onBehalfOfContentOwnerChannel = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends YouTubeRequest<Void> {
            private static final String REST_PATH = "channelSections";
            @Key
            private String id;
            @Key
            private String onBehalfOfContentOwner;

            protected Delete(String string) {
                super(YouTube.this, "DELETE", REST_PATH, null, Void.class);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getId() {
                return this.id;
            }

            public Delete setId(String string) {
                this.id = string;
                return this;
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Delete setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class ChannelBanners {
        public Insert insert(ChannelBannerResource channelBannerResource) throws IOException {
            Insert insert = new Insert(channelBannerResource);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public Insert insert(ChannelBannerResource channelBannerResource, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Insert insert = new Insert(channelBannerResource, abstractInputStreamContent);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends YouTubeRequest<ChannelBannerResource> {
            private static final String REST_PATH = "channelBanners/insert";
            @Key
            private String onBehalfOfContentOwner;

            protected Insert(ChannelBannerResource channelBannerResource) {
                super(YouTube.this, "POST", REST_PATH, (Object)channelBannerResource, ChannelBannerResource.class);
            }

            protected Insert(ChannelBannerResource channelBannerResource, AbstractInputStreamContent abstractInputStreamContent) {
                super(YouTube.this, "POST", "/upload/" + YouTube.this.getServicePath() + REST_PATH, (Object)channelBannerResource, ChannelBannerResource.class);
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getOnBehalfOfContentOwner() {
                return this.onBehalfOfContentOwner;
            }

            public Insert setOnBehalfOfContentOwner(String string) {
                this.onBehalfOfContentOwner = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }
    }

    public class Activities {
        public Insert insert(String string, Activity activity) throws IOException {
            Insert insert = new Insert(string, activity);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            YouTube.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends YouTubeRequest<ActivityListResponse> {
            private static final String REST_PATH = "activities";
            @Key
            private String part;
            @Key
            private String regionCode;
            @Key
            private DateTime publishedBefore;
            @Key
            private String channelId;
            @Key
            private Boolean mine;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private Boolean home;
            @Key
            private DateTime publishedAfter;

            protected List(String string) {
                super(YouTube.this, "GET", REST_PATH, null, ActivityListResponse.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public List setPart(String string) {
                this.part = string;
                return this;
            }

            public String getRegionCode() {
                return this.regionCode;
            }

            public List setRegionCode(String string) {
                this.regionCode = string;
                return this;
            }

            public DateTime getPublishedBefore() {
                return this.publishedBefore;
            }

            public List setPublishedBefore(DateTime dateTime) {
                this.publishedBefore = dateTime;
                return this;
            }

            public String getChannelId() {
                return this.channelId;
            }

            public List setChannelId(String string) {
                this.channelId = string;
                return this;
            }

            public Boolean getMine() {
                return this.mine;
            }

            public List setMine(Boolean bl) {
                this.mine = bl;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Boolean getHome() {
                return this.home;
            }

            public List setHome(Boolean bl) {
                this.home = bl;
                return this;
            }

            public DateTime getPublishedAfter() {
                return this.publishedAfter;
            }

            public List setPublishedAfter(DateTime dateTime) {
                this.publishedAfter = dateTime;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends YouTubeRequest<Activity> {
            private static final String REST_PATH = "activities";
            @Key
            private String part;

            protected Insert(String string, Activity activity) {
                super(YouTube.this, "POST", REST_PATH, (Object)activity, Activity.class);
                this.part = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter part must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getPart() {
                return this.part;
            }

            public Insert setPart(String string) {
                this.part = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }
    }
}

