/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.monday.com.webhook.endpoint;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;

@Path(value="/monday")
@WebObject(type="monday")
@Consumes(value={"application/json"})
public class MondayWebhookEndpoint
extends ModuleRoot {
    protected static final Logger log = LogManager.getLogger(MondayWebhookEndpoint.class);
    public static final String MONDAY_EVENT = "mondayEvent";
    protected static final ObjectMapper objectMapper = new ObjectMapper();
    public static final String CHALLENGE_FIELD = "challenge";
    public static final String EVENT_FIELD = "event";

    @Path(value="/event")
    @POST
    public Object doPost(@Context HttpServletRequest request) {
        try {
            String requestBody = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
            JsonNode eventJson = objectMapper.readTree(requestBody);
            if (eventJson.has(CHALLENGE_FIELD)) {
                String challenge = eventJson.get(CHALLENGE_FIELD).asText();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(CHALLENGE_FIELD, (Object)challenge);
                return new StringBlob(jsonObject.toString(), "application/json");
            }
            if (eventJson.has(EVENT_FIELD)) {
                EventContextImpl ctx = new EventContextImpl(new Object[0]);
                Map<String, String> props = Collections.singletonMap(MONDAY_EVENT, requestBody);
                ctx.setProperties(props);
                EventService es = (EventService)Framework.getService(EventService.class);
                es.fireEvent(MONDAY_EVENT, (EventContext)ctx);
                return Response.status((Response.Status)Response.Status.OK).build();
            }
            log.error("Error processing the event");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (JsonProcessingException e) {
            log.error("Error processing the event", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            log.error("Error processing the event", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

