/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.directory.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.MongoWriteException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.nuxeo.directory.mongodb.MongoDBDirectory;
import org.nuxeo.directory.mongodb.MongoDBDirectoryDescriptor;
import org.nuxeo.directory.mongodb.MongoDBReference;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.EntrySource;
import org.nuxeo.ecm.directory.PasswordHelper;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.mongodb.core.MongoDBConnectionHelper;
import org.nuxeo.mongodb.core.MongoDBSerializationHelper;

public class MongoDBSession
extends BaseSession
implements EntrySource {
    private static final Log log = LogFactory.getLog(MongoDBSession.class);
    protected MongoClient client;
    protected String dbName;
    protected String schemaName;
    protected String directoryName;
    protected BaseDirectoryDescriptor.SubstringMatchType substringMatchType;
    protected String countersCollectionName;
    protected final Map<String, Field> schemaFieldMap;
    protected final String passwordHashAlgorithm;
    protected final boolean autoincrementId;

    public MongoDBSession(MongoDBDirectory directory) {
        super((Directory)directory);
        MongoDBDirectoryDescriptor desc = directory.getDescriptor();
        this.client = MongoDBConnectionHelper.newMongoClient((String)desc.getServerUrl());
        this.dbName = desc.getDatabaseName();
        this.directoryName = directory.getName();
        this.countersCollectionName = directory.getCountersCollectionName();
        this.schemaName = directory.getSchema();
        this.substringMatchType = desc.getSubstringMatchType();
        this.schemaFieldMap = directory.getSchemaFieldMap();
        this.autoincrementId = desc.isAutoincrementIdField();
        this.passwordHashAlgorithm = desc.passwordHashAlgorithm;
    }

    public MongoDBDirectory getDirectory() {
        return (MongoDBDirectory)this.directory;
    }

    public DocumentModel getEntry(String id) throws DirectoryException {
        return this.getEntry(id, true);
    }

    public DocumentModel getEntry(String id, boolean fetchReferences) throws DirectoryException {
        if (!this.hasPermission("Read")) {
            return null;
        }
        return this.directory.getCache().getEntry(id, (EntrySource)this, fetchReferences);
    }

    public DocumentModelList getEntries() throws DirectoryException {
        if (!this.hasPermission("Read")) {
            return new DocumentModelListImpl();
        }
        return this.query(Collections.emptyMap());
    }

    public DocumentModel createEntry(Map<String, Object> fieldMap) throws DirectoryException {
        String id;
        this.checkPermission("Write");
        if (this.autoincrementId) {
            Document filter = MongoDBSerializationHelper.fieldMapToBson((String)"_id", (Object)this.directoryName);
            Document update = new Document().append("$inc", (Object)MongoDBSerializationHelper.fieldMapToBson((String)"seq", (Object)1));
            FindOneAndUpdateOptions options = new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER);
            Long longId = ((Document)this.getCollection(this.countersCollectionName).findOneAndUpdate((Bson)filter, (Bson)update, options)).getLong((Object)"seq");
            fieldMap.put(this.getIdField(), longId);
            id = String.valueOf(longId);
        } else {
            id = String.valueOf(fieldMap.get(this.getIdField()));
            if (this.hasEntry(id)) {
                throw new DirectoryException(String.format("Entry with id %s already exists", id));
            }
        }
        if (fieldMap.get(this.getPasswordField()) != null) {
            String password = (String)fieldMap.get(this.getPasswordField());
            password = PasswordHelper.hashPassword((String)password, (String)this.passwordHashAlgorithm);
            fieldMap.put(this.getPasswordField(), password);
        }
        try {
            Document bson = MongoDBSerializationHelper.fieldMapToBson(fieldMap);
            this.getCollection().insertOne((Object)bson);
            DocumentModel docModel = BaseSession.createEntryModel(null, (String)this.schemaName, (String)id, fieldMap, (boolean)this.isReadOnly());
            Field schemaIdField = this.schemaFieldMap.get(this.getIdField());
            String idFieldName = schemaIdField.getName().getPrefixedName();
            String sourceId = docModel.getId();
            for (Reference reference : this.getDirectory().getReferences()) {
                String referenceFieldName = this.schemaFieldMap.get(reference.getFieldName()).getName().getPrefixedName();
                if (this.getDirectory().getReferences(reference.getFieldName()).size() > 1) {
                    log.warn((Object)("Directory " + this.getDirectory().getName() + " cannot create field " + reference.getFieldName() + " for entry " + fieldMap.get(idFieldName) + ": this field is associated with more than one reference"));
                    continue;
                }
                List targetIds = (List)fieldMap.get(referenceFieldName);
                if (reference instanceof MongoDBReference) {
                    MongoDBReference mongodbReference = (MongoDBReference)reference;
                    mongodbReference.addLinks(sourceId, targetIds, this);
                    continue;
                }
                reference.addLinks(sourceId, targetIds);
            }
            this.getDirectory().invalidateCaches();
            return docModel;
        }
        catch (MongoWriteException e) {
            throw new DirectoryException((Throwable)e);
        }
    }

    public void updateEntry(DocumentModel docModel) throws DirectoryException {
        this.checkPermission("Write");
        HashMap<String, Serializable> fieldMap = new HashMap<String, Serializable>();
        LinkedList<String> referenceFieldList = new LinkedList<String>();
        for (String fieldName : this.schemaFieldMap.keySet()) {
            Property prop = docModel.getPropertyObject(this.schemaName, fieldName);
            if (fieldName.equals(this.getPasswordField()) && StringUtils.isEmpty((String)((String)((Object)prop.getValue())))) continue;
            if (prop != null && prop.isDirty()) {
                Object value = prop.getValue();
                if (fieldName.equals(this.getPasswordField())) {
                    value = PasswordHelper.hashPassword((String)((String)value), (String)this.passwordHashAlgorithm);
                }
                fieldMap.put(prop.getName(), (Serializable)value);
            }
            if (!this.getDirectory().isReference(fieldName)) continue;
            referenceFieldList.add(fieldName);
        }
        String id = docModel.getId();
        Document bson = MongoDBSerializationHelper.fieldMapToBson((String)this.getIdField(), (Object)id);
        Document props = new Document();
        props.append("$set", (Object)MongoDBSerializationHelper.fieldMapToBson(fieldMap));
        try {
            UpdateResult result = this.getCollection().updateOne((Bson)bson, (Bson)props);
            if (!result.wasAcknowledged()) {
                throw new DirectoryException("Error while updating the entry, the request has not been acknowledged by the server");
            }
            if (result.getMatchedCount() == 0L) {
                throw new DirectoryException(String.format("Error while updating the entry, no document was found with the id %s", id));
            }
        }
        catch (MongoWriteException e) {
            throw new DirectoryException((Throwable)e);
        }
        for (String referenceFieldName : referenceFieldList) {
            List references = this.directory.getReferences(referenceFieldName);
            if (references.size() > 1) {
                log.warn((Object)("Directory " + this.getDirectory().getName() + " cannot update field " + referenceFieldName + " for entry " + docModel.getId() + ": this field is associated with more than one reference"));
                continue;
            }
            Reference reference = (Reference)references.get(0);
            List targetIds = (List)docModel.getProperty(this.schemaName, referenceFieldName);
            if (reference instanceof MongoDBReference) {
                MongoDBReference mongoReference = (MongoDBReference)reference;
                mongoReference.setTargetIdsForSource(docModel.getId(), targetIds, this);
                continue;
            }
            reference.setTargetIdsForSource(docModel.getId(), targetIds);
        }
        this.getDirectory().invalidateCaches();
    }

    public void deleteEntry(DocumentModel docModel) throws DirectoryException {
        this.deleteEntry(docModel.getId());
    }

    public void deleteEntry(String id) throws DirectoryException {
        this.checkPermission("Write");
        this.checkDeleteConstraints(id);
        for (Reference reference : this.getDirectory().getReferences()) {
            if (reference instanceof MongoDBReference) {
                MongoDBReference mongoDBReference = (MongoDBReference)reference;
                mongoDBReference.removeLinksForSource(id, this);
                continue;
            }
            reference.removeLinksForSource(id);
        }
        try {
            DeleteResult result = this.getCollection().deleteOne((Bson)MongoDBSerializationHelper.fieldMapToBson((String)this.getIdField(), (Object)id));
            if (!result.wasAcknowledged()) {
                throw new DirectoryException("Error while deleting the entry, the request has not been acknowledged by the server");
            }
        }
        catch (MongoWriteException e) {
            throw new DirectoryException((Throwable)e);
        }
        this.getDirectory().invalidateCaches();
    }

    public void deleteEntry(String id, Map<String, String> map) throws DirectoryException {
        this.deleteEntry(id);
    }

    public DocumentModelList query(Map<String, Serializable> filter) throws DirectoryException {
        return this.query(filter, Collections.emptySet());
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext) throws DirectoryException {
        return this.query(filter, fulltext, new HashMap<String, String>());
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy) throws DirectoryException {
        return this.query(filter, fulltext, orderBy, false);
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences) throws DirectoryException {
        return this.query(filter, fulltext, orderBy, fetchReferences, -1, -1);
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences, int limit, int offset) throws DirectoryException {
        Document bson = this.buildQuery(filter, fulltext);
        DocumentModelListImpl entries = new DocumentModelListImpl();
        FindIterable results = this.getCollection().find((Bson)bson).skip(offset);
        if (limit > 0) {
            results.limit(limit);
        }
        for (Document resultDoc : results) {
            Map fieldMap = MongoDBSerializationHelper.bsonToFieldMap((Document)resultDoc);
            DocumentModel doc = this.fieldMapToDocumentModel(fieldMap);
            if (fetchReferences) {
                HashMap<String, List> targetIdsMap = new HashMap<String, List>();
                for (Reference reference : this.directory.getReferences()) {
                    List<String> targetIds;
                    if (reference instanceof MongoDBReference) {
                        MongoDBReference mongoReference = (MongoDBReference)reference;
                        targetIds = mongoReference.getTargetIdsForSource(doc.getId(), this);
                    } else {
                        targetIds = reference.getTargetIdsForSource(doc.getId());
                    }
                    targetIds = new ArrayList<String>(targetIds);
                    Collections.sort(targetIds);
                    String fieldName = reference.getFieldName();
                    targetIdsMap.computeIfAbsent(fieldName, key -> new ArrayList()).addAll(targetIds);
                }
                for (Map.Entry entry : targetIdsMap.entrySet()) {
                    String fieldName = (String)entry.getKey();
                    List targetIds = (List)entry.getValue();
                    try {
                        doc.setProperty(this.schemaName, fieldName, (Object)targetIds);
                    }
                    catch (PropertyException e) {
                        throw new DirectoryException((Throwable)e);
                    }
                }
            }
            entries.add((Object)doc);
        }
        if (orderBy != null && !orderBy.isEmpty()) {
            this.getDirectory().orderEntries((List)entries, orderBy);
        }
        return entries;
    }

    protected Document buildQuery(Map<String, Serializable> fieldMap, Set<String> fulltext) {
        Document bson = new Document();
        for (Map.Entry<String, Serializable> entry : fieldMap.entrySet()) {
            Object value = MongoDBSerializationHelper.valueToBson((Object)entry.getValue());
            if (value == null) continue;
            String key = entry.getKey();
            if (fulltext.contains(key)) {
                String val = String.valueOf(value);
                switch (this.substringMatchType) {
                    case subany: {
                        this.addField(bson, key, Pattern.compile(val, 2));
                        break;
                    }
                    case subinitial: {
                        this.addField(bson, key, Pattern.compile('^' + val, 2));
                        break;
                    }
                    case subfinal: {
                        this.addField(bson, key, Pattern.compile(val + '$', 2));
                    }
                }
                continue;
            }
            this.addField(bson, key, value);
        }
        return bson;
    }

    protected void addField(Document bson, String key, Object value) {
        bson.put(key, value);
    }

    public void close() throws DirectoryException {
        this.client.close();
        this.getDirectory().removeSession((Session)this);
    }

    public List<String> getProjection(Map<String, Serializable> filter, String columnName) throws DirectoryException {
        return this.getProjection(filter, Collections.emptySet(), columnName);
    }

    public List<String> getProjection(Map<String, Serializable> filter, Set<String> fulltext, String columnName) throws DirectoryException {
        DocumentModelList docList = this.query(filter, fulltext);
        ArrayList<String> result = new ArrayList<String>();
        for (DocumentModel docModel : docList) {
            Object obj = docModel.getProperty(this.schemaName, columnName);
            String propValue = String.valueOf(obj);
            result.add(propValue);
        }
        return result;
    }

    public boolean authenticate(String username, String password) throws DirectoryException {
        Document user = (Document)this.getCollection().find((Bson)MongoDBSerializationHelper.fieldMapToBson((String)this.getIdField(), (Object)username)).first();
        String storedPassword = user.getString((Object)this.getPasswordField());
        return PasswordHelper.verifyPassword((String)password, (String)storedPassword);
    }

    public boolean hasEntry(String id) {
        return this.getCollection().count((Bson)MongoDBSerializationHelper.fieldMapToBson((String)this.getIdField(), (Object)id)) > 0L;
    }

    public DocumentModel createEntry(DocumentModel documentModel) {
        return this.createEntry(documentModel.getProperties(this.schemaName));
    }

    public DocumentModel getEntryFromSource(String id, boolean fetchReferences) throws DirectoryException {
        DocumentModelList result = this.query(Collections.singletonMap(this.getIdField(), id), Collections.emptySet(), Collections.emptyMap(), fetchReferences, 1, -1);
        return result.isEmpty() ? null : (DocumentModel)result.get(0);
    }

    public MongoCollection<Document> getCollection(String collection) {
        return MongoDBConnectionHelper.getCollection((MongoClient)this.client, (String)this.dbName, (String)collection);
    }

    public MongoCollection<Document> getCollection() {
        return this.getCollection(this.directoryName);
    }

    public boolean hasCollection(String collection) {
        return MongoDBConnectionHelper.hasCollection((MongoClient)this.client, (String)this.dbName, (String)collection);
    }

    protected DocumentModel fieldMapToDocumentModel(Map<String, Object> fieldMap) {
        String id = String.valueOf(fieldMap.get(this.getIdField()));
        DocumentModel docModel = BaseSession.createEntryModel(null, (String)this.schemaName, (String)id, fieldMap, (boolean)this.isReadOnly());
        return docModel;
    }
}

