/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.directory.mongodb;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bson.Document;
import org.nuxeo.directory.mongodb.MongoDBDirectoryDescriptor;
import org.nuxeo.directory.mongodb.MongoDBSession;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.DirectoryCSVLoader;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.mongodb.core.MongoDBSerializationHelper;
import org.nuxeo.runtime.api.Framework;

public class MongoDBDirectory
extends AbstractDirectory {
    protected Map<String, Field> schemaFieldMap;
    protected String countersCollectionName;
    protected boolean initialized;

    public MongoDBDirectory(MongoDBDirectoryDescriptor descriptor) {
        super((BaseDirectoryDescriptor)descriptor);
        this.addReferences(descriptor.getInverseReferences());
        this.addReferences(descriptor.getMongoDBReferences());
        String cacheEntryName = descriptor.cacheEntryName;
        String cacheEntryNameWithoutReferencesName = descriptor.cacheEntryWithoutReferencesName;
        this.cache.setEntryCacheName(cacheEntryName);
        this.cache.setEntryCacheWithoutReferencesName(cacheEntryNameWithoutReferencesName);
        this.cache.setNegativeCaching(descriptor.negativeCaching);
        CacheService cacheService = (CacheService)Framework.getService(CacheService.class);
        if (cacheService != null) {
            if (cacheEntryName == null && descriptor.getCacheMaxSize() != 0) {
                this.cache.setEntryCacheName("cache-" + this.getName());
                cacheService.registerCache("cache-" + this.getName(), descriptor.getCacheMaxSize(), descriptor.getCacheTimeout() / 60);
            }
            if (cacheEntryNameWithoutReferencesName == null && descriptor.getCacheMaxSize() != 0) {
                this.cache.setEntryCacheWithoutReferencesName("cacheWithoutReference-" + this.getName());
                cacheService.registerCache("cacheWithoutReference-" + this.getName(), descriptor.getCacheMaxSize(), descriptor.getCacheTimeout() / 60);
            }
        }
        this.countersCollectionName = this.getName() + ".counters";
    }

    public MongoDBDirectoryDescriptor getDescriptor() {
        return (MongoDBDirectoryDescriptor)this.descriptor;
    }

    public Session getSession() throws DirectoryException {
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        Schema schema = schemaManager.getSchema(this.getSchema());
        if (schema == null) {
            throw new DirectoryException(this.getSchema() + " is not a registered schema");
        }
        this.schemaFieldMap = new LinkedHashMap<String, Field>();
        schema.getFields().forEach(f -> this.schemaFieldMap.put(f.getName().getLocalName(), (Field)f));
        MongoDBSession session = new MongoDBSession(this);
        this.addSession((Session)session);
        if (this.descriptor.isAutoincrementIdField() && !session.hasCollection(this.countersCollectionName)) {
            HashMap<String, Object> seq = new HashMap<String, Object>();
            seq.put("_id", this.getName());
            seq.put("seq", 0L);
            session.getCollection(this.countersCollectionName).insertOne((Object)MongoDBSerializationHelper.fieldMapToBson(seq));
        }
        if (!this.initialized) {
            String policy = this.descriptor.getCreateTablePolicy();
            MongoCollection<Document> collection = session.getCollection(this.getName());
            boolean dropCollection = false;
            boolean loadData = false;
            switch (policy) {
                case "always": {
                    dropCollection = true;
                    loadData = true;
                    break;
                }
                case "on_missing_columns": {
                    if (session.hasCollection(this.getName())) {
                        long totalEntries = collection.count();
                        boolean missingColumns = schema.getFields().stream().map(f -> f.getName().getLocalName()).anyMatch(fname -> collection.count(Filters.exists((String)fname, (boolean)false)) == totalEntries);
                        if (!missingColumns) break;
                        dropCollection = true;
                        loadData = true;
                        break;
                    }
                    loadData = true;
                    break;
                }
                default: {
                    if (session.hasCollection(this.getName())) break;
                    loadData = true;
                }
            }
            if (dropCollection) {
                collection.drop();
            }
            if (loadData) {
                this.loadData(schema, (Session)session);
            }
            this.initialized = true;
        }
        return session;
    }

    protected void loadData(Schema schema, Session session) {
        if (this.descriptor.getDataFileName() != null) {
            DirectoryCSVLoader.loadData((String)this.descriptor.getDataFileName(), (char)this.descriptor.getDataFileCharacterSeparator(), (Schema)schema, arg_0 -> ((Session)session).createEntry(arg_0));
        }
    }

    public Map<String, Field> getSchemaFieldMap() {
        return this.schemaFieldMap;
    }

    public String getCountersCollectionName() {
        return this.countersCollectionName;
    }
}

