/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.directory.mongodb;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.directory.mongodb.MongoDBDirectory;
import org.nuxeo.directory.mongodb.MongoDBReference;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.InverseReference;
import org.nuxeo.ecm.directory.Reference;

@XObject(value="directory")
public class MongoDBDirectoryDescriptor
extends BaseDirectoryDescriptor {
    @XNode(value="serverUrl")
    public String serverUrl;
    @XNode(value="databaseName")
    public String databaseName;
    @XNodeList(value="references/reference", type=MongoDBReference[].class, componentType=MongoDBReference.class)
    public MongoDBReference[] references;
    @XNodeList(value="references/inverseReference", type=InverseReference[].class, componentType=InverseReference.class)
    public InverseReference[] inverseReferences;

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public Reference[] getInverseReferences() {
        return this.inverseReferences;
    }

    public Reference[] getMongoDBReferences() {
        return this.references;
    }

    public void merge(BaseDirectoryDescriptor other) {
        super.merge(other);
        if (other instanceof MongoDBDirectoryDescriptor) {
            this.merge((MongoDBDirectoryDescriptor)other);
        }
    }

    protected void merge(MongoDBDirectoryDescriptor other) {
        if (other.serverUrl != null) {
            this.serverUrl = other.serverUrl;
        }
        if (other.databaseName != null) {
            this.databaseName = other.databaseName;
        }
        if (other.inverseReferences != null && other.inverseReferences.length != 0) {
            this.inverseReferences = other.inverseReferences;
        }
        if (other.references != null && other.references.length != 0) {
            this.references = other.references;
        }
    }

    public MongoDBDirectoryDescriptor clone() {
        int i;
        MongoDBDirectoryDescriptor clone = (MongoDBDirectoryDescriptor)super.clone();
        if (this.references != null) {
            clone.references = new MongoDBReference[this.references.length];
            for (i = 0; i < this.references.length; ++i) {
                clone.references[i] = this.references[i].clone();
            }
        }
        if (this.inverseReferences != null) {
            clone.inverseReferences = new InverseReference[this.inverseReferences.length];
            for (i = 0; i < this.inverseReferences.length; ++i) {
                clone.inverseReferences[i] = this.inverseReferences[i].clone();
            }
        }
        return clone;
    }

    public MongoDBDirectory newDirectory() {
        return new MongoDBDirectory(this);
    }
}

