/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.mongodb.audit;

import java.util.Arrays;
import java.util.Map;
import org.bson.Document;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;

public class MongoDBAuditEntryWriter {
    public static Document asDocument(LogEntry logEntry) {
        Document document = new Document("_id", (Object)logEntry.getId());
        document.put("category", (Object)logEntry.getCategory());
        document.put("principalName", (Object)logEntry.getPrincipalName());
        document.put("comment", (Object)logEntry.getComment());
        document.put("docLifeCycle", (Object)logEntry.getDocLifeCycle());
        document.put("docPath", (Object)logEntry.getDocPath());
        document.put("docType", (Object)logEntry.getDocType());
        document.put("docUUID", (Object)logEntry.getDocUUID());
        document.put("eventId", (Object)logEntry.getEventId());
        document.put("repositoryId", (Object)logEntry.getRepositoryId());
        document.put("eventDate", (Object)logEntry.getEventDate());
        document.put("logDate", (Object)logEntry.getLogDate());
        Map extendedInfo = logEntry.getExtendedInfos();
        Document extended = new Document();
        for (Map.Entry entry : extendedInfo.entrySet()) {
            String key = (String)entry.getKey();
            ExtendedInfo ei = (ExtendedInfo)entry.getValue();
            if (ei != null && ei.getSerializableValue() != null) {
                Object value = ei.getSerializableValue();
                if (value instanceof Object[]) {
                    value = Arrays.asList((Object[])value);
                }
                extended.put(key, value);
                continue;
            }
            extended.put(key, null);
        }
        document.put("extended", (Object)extended);
        return document;
    }
}

