/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.directory.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoWriteException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.DeleteResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.directory.mongodb.MongoDBSession;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.SchemaImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.directory.AbstractReference;
import org.nuxeo.ecm.directory.DirectoryCSVLoader;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.mongodb.core.MongoDBSerializationHelper;

@XObject(value="reference")
public class MongoDBReference
extends AbstractReference
implements Cloneable {
    @XNode(value="@collection")
    protected String collection;
    @XNode(value="@sourceField")
    protected String sourceField;
    @XNode(value="@targetField")
    protected String targetField;
    @XNode(value="@dataFile")
    protected String dataFileName;
    private boolean initialized;

    @XNode(value="@field")
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @XNode(value="@directory")
    public void setTargetDirectoryName(String targetDirectoryName) {
        this.targetDirectoryName = targetDirectoryName;
    }

    public void addLinks(String sourceId, List<String> targetIds) throws DirectoryException {
        try (MongoDBSession session = this.getMongoDBSession();){
            this.addLinks(sourceId, targetIds, session);
        }
    }

    public void addLinks(String sourceId, List<String> targetIds, MongoDBSession session) throws DirectoryException {
        if (!this.initialized) {
            if (this.dataFileName != null) {
                this.initializeSession(session);
            }
            this.initialized = true;
        }
        if (targetIds == null || targetIds.isEmpty()) {
            return;
        }
        try {
            MongoCollection<Document> coll = session.getCollection(this.collection);
            List newDocs = targetIds.stream().map(targetId -> this.buildDoc(sourceId, (String)targetId)).filter(doc -> coll.count((Bson)doc) == 0L).collect(Collectors.toList());
            coll.insertMany(newDocs);
        }
        catch (MongoWriteException e) {
            throw new DirectoryException((Throwable)e);
        }
    }

    public void addLinks(List<String> sourceIds, String targetId) throws DirectoryException {
        if (sourceIds == null || sourceIds.isEmpty()) {
            return;
        }
        try (MongoDBSession session = this.getMongoDBSession();){
            MongoCollection<Document> coll = session.getCollection(this.collection);
            List newDocs = sourceIds.stream().map(sourceId -> this.buildDoc((String)sourceId, targetId)).filter(doc -> coll.count((Bson)doc) == 0L).collect(Collectors.toList());
            coll.insertMany(newDocs);
        }
        catch (MongoWriteException e) {
            throw new DirectoryException((Throwable)e);
        }
    }

    public void removeLinksForSource(String sourceId) throws DirectoryException {
        try (MongoDBSession session = this.getMongoDBSession();){
            this.removeLinksForSource(sourceId, session);
        }
    }

    public void removeLinksForSource(String sourceId, MongoDBSession session) {
        this.removeLinksFor(this.sourceField, sourceId, session);
    }

    public void removeLinksForTarget(String targetId) throws DirectoryException {
        try (MongoDBSession session = this.getMongoDBSession();){
            this.removeLinksFor(this.targetField, targetId, session);
        }
    }

    private void removeLinksFor(String field, String value, MongoDBSession session) {
        try {
            DeleteResult result = session.getCollection(this.collection).deleteMany((Bson)MongoDBSerializationHelper.fieldMapToBson((String)field, (Object)value));
            if (!result.wasAcknowledged()) {
                throw new DirectoryException("Error while deleting the entry, the request has not been acknowledged by the server");
            }
        }
        catch (MongoWriteException e) {
            throw new DirectoryException((Throwable)e);
        }
    }

    public List<String> getTargetIdsForSource(String sourceId) throws DirectoryException {
        try (MongoDBSession session = this.getMongoDBSession();){
            List<String> list = this.getIdsFor(this.sourceField, sourceId, this.targetField, session);
            return list;
        }
    }

    public List<String> getTargetIdsForSource(String sourceId, MongoDBSession session) throws DirectoryException {
        return this.getIdsFor(this.sourceField, sourceId, this.targetField, session);
    }

    public List<String> getSourceIdsForTarget(String targetId) throws DirectoryException {
        try (MongoDBSession session = this.getMongoDBSession();){
            List<String> list = this.getIdsFor(this.targetField, targetId, this.sourceField, session);
            return list;
        }
    }

    private List<String> getIdsFor(String queryField, String value, String resultField, MongoDBSession session) {
        FindIterable docs = session.getCollection(this.collection).find((Bson)MongoDBSerializationHelper.fieldMapToBson((String)queryField, (Object)value));
        return StreamSupport.stream(docs.spliterator(), false).map(doc -> doc.getString((Object)resultField)).collect(Collectors.toList());
    }

    public void setTargetIdsForSource(String sourceId, List<String> targetIds) throws DirectoryException {
        try (MongoDBSession session = this.getMongoDBSession();){
            this.setTargetIdsForSource(sourceId, targetIds, session);
        }
    }

    public void setTargetIdsForSource(String sourceId, List<String> targetIds, MongoDBSession session) throws DirectoryException {
        this.setIdsFor(this.sourceField, sourceId, this.targetField, targetIds, session);
    }

    public void setSourceIdsForTarget(String targetId, List<String> sourceIds) throws DirectoryException {
        try (MongoDBSession session = this.getMongoDBSession();){
            this.setIdsFor(this.targetField, targetId, this.sourceField, sourceIds, session);
        }
    }

    private void setIdsFor(String field, String value, String fieldToUpdate, List<String> ids, MongoDBSession session) {
        Object list;
        HashSet<String> idsToAdd = new HashSet<String>();
        if (ids != null) {
            idsToAdd.addAll(ids);
        }
        ArrayList<String> idsToDelete = new ArrayList<String>();
        List<String> existingIds = this.getIdsFor(field, value, fieldToUpdate, session);
        for (String id2 : existingIds) {
            if (idsToAdd.remove(id2)) continue;
            idsToDelete.add(id2);
        }
        if (!idsToDelete.isEmpty()) {
            list = new BasicDBList();
            if (this.sourceField.equals(field)) {
                list.addAll((Collection)idsToDelete.stream().map(id -> this.buildDoc(value, (String)id)).collect(Collectors.toList()));
            } else {
                list.addAll((Collection)idsToDelete.stream().map(id -> this.buildDoc((String)id, value)).collect(Collectors.toList()));
            }
            BasicDBObject deleteDoc = new BasicDBObject("$or", list);
            session.getCollection(this.collection).deleteMany((Bson)deleteDoc);
        }
        if (!idsToAdd.isEmpty()) {
            list = this.sourceField.equals(field) ? idsToAdd.stream().map(id -> this.buildDoc(value, (String)id)).collect(Collectors.toList()) : idsToAdd.stream().map(id -> this.buildDoc((String)id, value)).collect(Collectors.toList());
            session.getCollection(this.collection).insertMany((List)list);
        }
    }

    private Document buildDoc(String sourceId, String targetId) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put(this.sourceField, sourceId);
        fieldMap.put(this.targetField, targetId);
        return MongoDBSerializationHelper.fieldMapToBson(fieldMap);
    }

    public MongoDBReference clone() {
        MongoDBReference clone = (MongoDBReference)super.clone();
        return clone;
    }

    protected void initializeSession(MongoDBSession session) {
        SchemaImpl schema = new SchemaImpl(this.collection, null);
        schema.addField(this.sourceField, (Type)StringType.INSTANCE, null, 0, Collections.emptySet());
        schema.addField(this.targetField, (Type)StringType.INSTANCE, null, 0, Collections.emptySet());
        Consumer<Map> loader = map -> {
            Document doc = MongoDBSerializationHelper.fieldMapToBson((Map)map);
            MongoCollection<Document> coll = session.getCollection(this.collection);
            if (coll.count((Bson)doc) == 0L) {
                coll.insertOne((Object)doc);
            }
        };
        DirectoryCSVLoader.loadData((String)this.dataFileName, (char)',', (Schema)schema, loader);
    }

    protected MongoDBSession getMongoDBSession() throws DirectoryException {
        if (!this.initialized) {
            if (this.dataFileName != null) {
                try (MongoDBSession session = (MongoDBSession)this.getSourceDirectory().getSession();){
                    this.initializeSession(session);
                }
            }
            this.initialized = true;
        }
        return (MongoDBSession)this.getSourceDirectory().getSession();
    }
}

