/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.mongodb.audit;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.ecm.core.uidgen.UIDGeneratorService;
import org.nuxeo.ecm.core.uidgen.UIDSequencer;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.FilterMapEntry;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.query.AuditQueryException;
import org.nuxeo.ecm.platform.audit.api.query.DateRangeParser;
import org.nuxeo.ecm.platform.audit.service.AbstractAuditBackend;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.BaseLogEntryProvider;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.ecm.platform.audit.service.extension.AuditBackendDescriptor;
import org.nuxeo.mongodb.audit.MongoDBAuditEntryReader;
import org.nuxeo.mongodb.audit.MongoDBAuditEntryWriter;
import org.nuxeo.mongodb.audit.MongoDBExtendedInfo;
import org.nuxeo.mongodb.core.MongoDBConnectionService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class MongoDBAuditBackend
extends AbstractAuditBackend
implements AuditBackend {
    private static final Log log = LogFactory.getLog(MongoDBAuditBackend.class);
    public static final String AUDIT_DATABASE_ID = "audit";
    public static final String COLLECTION_NAME_PROPERTY = "nuxeo.mongodb.audit.collection.name";
    public static final String DEFAULT_COLLECTION_NAME = "audit";
    public static final String SEQ_NAME = "audit";
    protected MongoCollection<Document> collection;
    protected MongoDBLogEntryProvider provider = new MongoDBLogEntryProvider();

    public MongoDBAuditBackend(NXAuditEventsService component, AuditBackendDescriptor config) {
        super(component, config);
    }

    public int getApplicationStartedOrder() {
        DefaultComponent component = (DefaultComponent)Framework.getRuntime().getComponent("org.nuxeo.mongodb.core.MongoDBComponent");
        return component.getApplicationStartedOrder() + 1;
    }

    public void onApplicationStarted() {
        log.info((Object)"Activate MongoDB backend for Audit");
        ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        String collName = configurationService.getProperty(COLLECTION_NAME_PROPERTY, "audit");
        MongoDBConnectionService mongoService = (MongoDBConnectionService)Framework.getService(MongoDBConnectionService.class);
        MongoDatabase database = mongoService.getDatabase("audit");
        this.collection = database.getCollection(collName);
    }

    public void onShutdown() {
        if (this.collection != null) {
            this.collection = null;
        }
    }

    public MongoCollection<Document> getAuditCollection() {
        return this.collection;
    }

    public List<LogEntry> getLogEntriesFor(String uuid, String repositoryId) {
        Bson docFilter = Filters.eq((String)"docUUID", (Object)uuid);
        Bson repoFilter = Filters.eq((String)"repositoryId", (Object)repositoryId);
        Bson query = Filters.and((Bson[])new Bson[]{docFilter, repoFilter});
        return this.getLogEntries(query, false);
    }

    public List<LogEntry> getLogEntriesFor(String uuid, Map<String, FilterMapEntry> filterMap, boolean doDefaultSort) {
        Bson filter;
        Bson docFilter = Filters.eq((String)"docUUID", (Object)uuid);
        if (MapUtils.isEmpty(filterMap)) {
            filter = docFilter;
        } else {
            ArrayList<Bson> list = new ArrayList<Bson>(Collections.singleton(docFilter));
            for (Map.Entry<String, FilterMapEntry> entry : filterMap.entrySet()) {
                FilterMapEntry filterEntry = entry.getValue();
                list.add(Filters.eq((String)filterEntry.getColumnName(), (Object)filterEntry.getObject()));
            }
            filter = Filters.and(list);
        }
        return this.getLogEntries(filter, doDefaultSort);
    }

    public LogEntry getLogEntryByID(long id) {
        Document document = (Document)this.collection.find(Filters.eq((String)"_id", (Object)id)).first();
        if (document == null) {
            return null;
        }
        return MongoDBAuditEntryReader.read(document);
    }

    public List<?> nativeQuery(String query, Map<String, Object> params, int pageNb, int pageSize) {
        Bson filter = this.buildFilter(query, params);
        this.logRequest(filter, pageNb, pageSize);
        FindIterable iterable = this.collection.find(filter).skip(pageNb * pageSize).limit(pageSize);
        return this.buildLogEntries((FindIterable<Document>)iterable);
    }

    public Bson buildFilter(String query, Map<String, Object> params) {
        if (params != null && params.size() > 0) {
            query = this.expandQueryVariables(query, params);
        }
        return Document.parse((String)query);
    }

    public String expandQueryVariables(String query, Object[] params) {
        HashMap<String, Object> qParams = new HashMap<String, Object>();
        for (int i = 0; i < params.length; ++i) {
            query = query.replaceFirst("\\?", "\\${param" + i + "}");
            qParams.put("param" + i, params[i]);
        }
        return this.expandQueryVariables(query, qParams);
    }

    public String expandQueryVariables(String query, Map<String, Object> params) {
        if (params != null && params.size() > 0) {
            TextTemplate tmpl = new TextTemplate();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Calendar) {
                    tmpl.setVariable(key, dateFormat.format(((Calendar)value).getTime()));
                    continue;
                }
                if (value instanceof Date) {
                    tmpl.setVariable(key, dateFormat.format(value));
                    continue;
                }
                if (value == null) continue;
                tmpl.setVariable(key, value.toString());
            }
            query = tmpl.processText(query);
        }
        return query;
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, Date limit, String[] categories, String path, int pageNb, int pageSize) {
        ArrayList<Bson> list = new ArrayList<Bson>();
        if (eventIds != null && eventIds.length > 0) {
            if (eventIds.length == 1) {
                list.add(Filters.eq((String)"eventId", (Object)eventIds[0]));
            } else {
                list.add(Filters.in((String)"eventId", (Object[])eventIds));
            }
        }
        if (categories != null && categories.length > 0) {
            if (categories.length == 1) {
                list.add(Filters.eq((String)"category", (Object)categories[0]));
            } else {
                list.add(Filters.in((String)"category", (Object[])categories));
            }
        }
        if (path != null) {
            list.add(Filters.eq((String)"docPath", (Object)path));
        }
        if (limit != null) {
            list.add(Filters.lt((String)"eventDate", (Object)limit));
        }
        Bson filter = list.size() == 1 ? (Bson)list.get(0) : Filters.and(list);
        this.logRequest(filter, pageNb, pageSize);
        FindIterable iterable = this.collection.find(filter).skip(pageNb * pageSize).limit(pageSize);
        return this.buildLogEntries((FindIterable<Document>)iterable);
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, String dateRange, String[] categories, String path, int pageNb, int pageSize) {
        Date limit = null;
        if (dateRange != null) {
            try {
                limit = DateRangeParser.parseDateRangeQuery((Date)new Date(), (String)dateRange);
            }
            catch (AuditQueryException aqe) {
                aqe.addInfo("Wrong date range query. Query was " + dateRange);
                throw aqe;
            }
        }
        return this.queryLogsByPage(eventIds, limit, categories, path, pageNb, pageSize);
    }

    public void addLogEntries(List<LogEntry> entries) {
        if (entries.isEmpty()) {
            return;
        }
        UIDGeneratorService uidGeneratorService = (UIDGeneratorService)Framework.getService(UIDGeneratorService.class);
        UIDSequencer seq = uidGeneratorService.getSequencer();
        ArrayList<Document> documents = new ArrayList<Document>(entries.size());
        for (LogEntry entry : entries) {
            entry.setId(seq.getNextLong("audit"));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Indexing log enry Id: %s, with logDate : %s, for docUUID: %s ", entry.getId(), entry.getLogDate(), entry.getDocUUID()));
            }
            documents.add(MongoDBAuditEntryWriter.asDocument(entry));
        }
        this.collection.insertMany(documents);
    }

    public Long getEventsCount(String eventId) {
        return this.collection.count(Filters.eq((String)"eventId", (Object)eventId));
    }

    public long syncLogCreationEntries(String repoId, String path, Boolean recurs) {
        return this.syncLogCreationEntries(this.provider, repoId, path, recurs);
    }

    public ExtendedInfo newExtendedInfo(Serializable value) {
        return new MongoDBExtendedInfo(value);
    }

    private List<LogEntry> getLogEntries(Bson filter, boolean doDefaultSort) {
        Bson orderBy = null;
        if (doDefaultSort) {
            orderBy = Sorts.descending((String[])new String[]{"eventDate"});
        }
        this.logRequest(filter, orderBy);
        FindIterable iterable = this.collection.find(filter).sort(orderBy);
        return this.buildLogEntries((FindIterable<Document>)iterable);
    }

    private List<LogEntry> buildLogEntries(FindIterable<Document> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).map(MongoDBAuditEntryReader::read).collect(Collectors.toList());
    }

    private void logRequest(Bson filter, Bson orderBy) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("MongoDB: FILTER " + filter + (orderBy == null ? "" : " ORDER BY " + orderBy)));
        }
    }

    private void logRequest(Bson filter, int pageNb, int pageSize) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("MongoDB: FILTER " + filter + " OFFSET " + pageNb + " LIMIT " + pageSize));
        }
    }

    public class MongoDBLogEntryProvider
    implements BaseLogEntryProvider {
        public int removeEntries(String eventId, String pathPattern) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        public void addLogEntry(LogEntry logEntry) {
            ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
            entries.add(logEntry);
            MongoDBAuditBackend.this.addLogEntries(entries);
        }

        public List<LogEntry> getLogEntriesFor(String uuid, String repositoryId) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        public List<LogEntry> getLogEntriesFor(String uuid) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        public List<LogEntry> getLogEntriesFor(String uuid, Map<String, FilterMapEntry> filterMap, boolean doDefaultSort) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }
    }
}

