/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.mongodb.audit;

import com.mongodb.DBObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.impl.ExtendedInfoImpl;
import org.nuxeo.ecm.platform.audit.impl.LogEntryImpl;

public class MongoDBAuditEntryReader {
    private static final Log log = LogFactory.getLog(MongoDBAuditEntryReader.class);

    public static LogEntry read(Document doc) {
        LogEntryImpl entry = new LogEntryImpl();
        Iterator iterator = doc.keySet().iterator();
        block30: while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "_id": {
                    entry.setId(doc.getLong((Object)key).longValue());
                    continue block30;
                }
                case "category": {
                    entry.setCategory(doc.getString((Object)key));
                    continue block30;
                }
                case "principalName": {
                    entry.setPrincipalName(doc.getString((Object)key));
                    continue block30;
                }
                case "comment": {
                    entry.setComment(doc.getString((Object)key));
                    continue block30;
                }
                case "docLifeCycle": {
                    entry.setDocLifeCycle(doc.getString((Object)key));
                    continue block30;
                }
                case "docPath": {
                    entry.setDocPath(doc.getString((Object)key));
                    continue block30;
                }
                case "docType": {
                    entry.setDocType(doc.getString((Object)key));
                    continue block30;
                }
                case "docUUID": {
                    entry.setDocUUID(doc.getString((Object)key));
                    continue block30;
                }
                case "eventId": {
                    entry.setEventId(doc.getString((Object)key));
                    continue block30;
                }
                case "repositoryId": {
                    entry.setRepositoryId(doc.getString((Object)key));
                    continue block30;
                }
                case "eventDate": {
                    entry.setEventDate(doc.getDate((Object)key));
                    continue block30;
                }
                case "logDate": {
                    entry.setLogDate(doc.getDate((Object)key));
                    continue block30;
                }
                case "extended": {
                    entry.setExtendedInfos(MongoDBAuditEntryReader.readExtendedInfo((Document)doc.get((Object)key, Document.class)));
                    continue block30;
                }
            }
            log.warn((Object)("Property with key '" + key + "' is not a known LogEntry property, skip it."));
        }
        return entry;
    }

    public static Map<String, ExtendedInfo> readExtendedInfo(Document extInfos) {
        HashMap<String, ExtendedInfo> info = new HashMap<String, ExtendedInfo>();
        for (Map.Entry entry : extInfos.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            ExtendedInfoImpl ei = value instanceof List || value instanceof DBObject ? ExtendedInfoImpl.createExtendedInfo((Serializable)((Object)value.toString())) : ExtendedInfoImpl.createExtendedInfo((Serializable)((Serializable)value));
            info.put(key, (ExtendedInfo)ei);
        }
        return info;
    }
}

