/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.mongodb.seqgen;

import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Updates;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.nuxeo.ecm.core.uidgen.AbstractUIDSequencer;
import org.nuxeo.mongodb.core.MongoDBConnectionService;
import org.nuxeo.mongodb.core.MongoDBSerializationHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class MongoDBUIDSequencer
extends AbstractUIDSequencer {
    public static final String SEQUENCE_DATABASE_ID = "sequence";
    public static final String COLLECTION_NAME_PROPERTY = "nuxeo.mongodb.seqgen.collection.name";
    public static final String DEFAULT_COLLECTION_NAME = "sequence";
    public static final Long ONE = 1L;
    public static final String SEQUENCE_VALUE_FIELD = "sequence";
    private static final Log log = LogFactory.getLog(MongoDBUIDSequencer.class);
    private MongoCollection<Document> coll;

    public void init() {
        this.getCollection();
    }

    private MongoCollection<Document> getCollection() {
        if (this.coll == null) {
            ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
            String collName = configurationService.getProperty(COLLECTION_NAME_PROPERTY, "sequence");
            MongoDBConnectionService mongoService = (MongoDBConnectionService)Framework.getService(MongoDBConnectionService.class);
            MongoDatabase database = mongoService.getDatabase("sequence");
            this.coll = database.getCollection(collName);
        }
        return this.coll;
    }

    public int getNext(String key) {
        return (int)this.getNextLong(key);
    }

    public long getNextLong(String key) {
        FindOneAndUpdateOptions options = new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER);
        Bson filter = Filters.eq((String)"_id", (Object)key);
        Bson update = Updates.inc((String)"sequence", (Number)ONE);
        Document sequence = (Document)this.getCollection().findOneAndUpdate(filter, update, options);
        if (sequence == null) {
            try {
                sequence = new Document();
                sequence.put("_id", (Object)key);
                sequence.put("sequence", (Object)ONE);
                this.getCollection().insertOne((Object)sequence);
            }
            catch (MongoWriteException e) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("There was a race condition during '" + key + "' sequence insertion"), (Throwable)e);
                }
                return this.getNextLong(key);
            }
        }
        return (Long)MongoDBSerializationHelper.bsonToFieldMap((Document)sequence).get("sequence");
    }

    public void dispose() {
        if (this.coll != null) {
            this.coll = null;
        }
    }
}

