/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.reload;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventListener;

public class RepositoryReloader
implements EventListener {
    private static Log log = LogFactory.getLog(RepositoryReloader.class);

    public boolean aboutToHandleEvent(Event event) {
        return true;
    }

    public void handleEvent(Event event) {
        String id = event.getId();
        if ("reloadRepositories".equals(id) || "flush".equals(id)) {
            try {
                RepositoryReloader.reloadRepositories();
            }
            catch (Exception e) {
                log.error((Object)"Failed to reload repositories", (Throwable)e);
            }
        }
    }

    public static void closeRepositories() throws Exception {
        RepositoryService repositoryService = (RepositoryService)Framework.getLocalService(RepositoryService.class);
        repositoryService.shutdown();
    }

    public static void flushJCAPool() throws Exception {
        try {
            Class<?> nuxeoContainerClass = Class.forName("org.nuxeo.runtime.jtajca.NuxeoContainer");
            if (nuxeoContainerClass != null) {
                nuxeoContainerClass.getMethod("resetConnectionManager", new Class[0]).invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)e, (Throwable)e);
        }
    }

    public static void reloadRepositories() throws Exception {
        RepositoryReloader.flushJCAPool();
        RepositoryReloader.closeRepositories();
    }
}

