/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="permission")
public class PermissionDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XNode(value="@name")
    private String name;
    @XNodeList(value="include", type=String[].class, componentType=String.class)
    private String[] includePermissions;
    @XNodeList(value="remove", type=String[].class, componentType=String.class)
    private String[] removePermissions;
    @XNodeList(value="alias", type=String[].class, componentType=String.class)
    private String[] aliasPermissions;

    public String getName() {
        return this.name;
    }

    public List<String> getIncludePermissions() {
        return Arrays.asList(this.includePermissions);
    }

    public List<String> getRemovePermissions() {
        return Arrays.asList(this.removePermissions);
    }

    public List<String> getAliasPermissions() {
        return Arrays.asList(this.aliasPermissions);
    }

    public boolean equals(Object o) {
        if (o instanceof PermissionDescriptor) {
            PermissionDescriptor pd = (PermissionDescriptor)o;
            if (!this.name.equals(pd.name)) {
                return false;
            }
            if (!this.getIncludePermissions().equals(pd.getIncludePermissions())) {
                return false;
            }
            if (!this.getRemovePermissions().equals(pd.getRemovePermissions())) {
                return false;
            }
            return this.getAliasPermissions().equals(pd.getAliasPermissions());
        }
        return false;
    }

    public String toString() {
        return String.format("PermissionDescriptor[%s]", this.name);
    }
}

