/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.Source;
import org.apache.commons.lang.StringEscapeUtils;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.ModelProperty;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.PropertyType;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;
import org.nuxeo.runtime.api.Framework;

public class FulltextParser {
    protected static final String WORD_SPLIT_PROP = "org.nuxeo.vcs.fulltext.wordsplit";
    protected static final String WORD_SPLIT_DEF = "[\\s\\p{Punct}]+";
    protected static final Pattern WORD_SPLIT_PATTERN = Pattern.compile(Framework.getProperty((String)"org.nuxeo.vcs.fulltext.wordsplit", (String)"[\\s\\p{Punct}]+"));
    protected Node document;
    protected SessionImpl session;
    protected String documentType;
    protected String[] mixinTypes;
    protected String indexName;
    protected Set<String> paths;
    protected ArrayList<String> strings;

    public ArrayList<String> getStrings() {
        return this.strings;
    }

    public void setStrings(ArrayList<String> strings) {
        this.strings = strings;
    }

    protected void setDocument(Node document, SessionImpl session) {
        this.document = document;
        this.session = session;
        if (document != null) {
            this.documentType = document.getPrimaryType();
            this.mixinTypes = document.getMixinTypes();
        }
    }

    protected String findFulltext(String indexName, Set<String> paths) throws StorageException {
        if (paths == null) {
            return "";
        }
        this.indexName = indexName;
        this.paths = paths;
        this.strings = new ArrayList();
        for (String path : paths) {
            ModelProperty pi = this.session.getModel().getPathPropertyInfo(this.documentType, this.mixinTypes, path);
            if (pi == null || pi.propertyType != PropertyType.STRING && pi.propertyType != PropertyType.ARRAY_STRING) continue;
            ArrayList<Node> nodes = new ArrayList<Node>(Collections.singleton(this.document));
            String[] names = path.split("/");
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                if (i < names.length - 1) {
                    ArrayList<Node> newNodes;
                    if ("*".equals(names[i + 1])) {
                        ++i;
                        newNodes = new ArrayList<Node>();
                        for (Node node : nodes) {
                            newNodes.addAll(this.session.getChildren(node, name, true));
                        }
                    } else {
                        newNodes = new ArrayList(nodes.size());
                        for (Node node : nodes) {
                            if ((node = this.session.getChildNode(node, name, true)) == null) continue;
                            newNodes.add(node);
                        }
                    }
                    nodes = newNodes;
                    continue;
                }
                for (Node node : nodes) {
                    if (pi.propertyType == PropertyType.STRING) {
                        String v = node.getSimpleProperty(name).getString();
                        if (v == null) continue;
                        this.parse(v, path);
                        continue;
                    }
                    for (Serializable v : node.getCollectionProperty(name).getValue()) {
                        if (v == null) continue;
                        this.parse((String)((Object)v), path);
                    }
                }
            }
        }
        return StringUtils.join(this.strings, (String)" ");
    }

    public void parse(String s, String path) {
        s = this.preprocessField(s, path);
        for (String word : WORD_SPLIT_PATTERN.split(s)) {
            if (word.isEmpty()) continue;
            this.strings.add(word.toLowerCase());
        }
    }

    protected String preprocessField(String s, String path) {
        if (s == null) {
            return null;
        }
        if (s.contains("<")) {
            s = this.removeHtml(s);
        }
        return StringEscapeUtils.unescapeHtml((String)s);
    }

    protected String removeHtml(String s) {
        Source source = new Source((CharSequence)s);
        Renderer renderer = source.getRenderer();
        renderer.setIncludeHyperlinkURLs(false);
        renderer.setDecorateFontStyles(false);
        return renderer.toString();
    }
}

