/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.repository.RepositoryFactory;
import org.nuxeo.ecm.core.storage.binary.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.CachingMapper;
import org.nuxeo.ecm.core.storage.sql.RepositoryBackend;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManagerConfiguration;

@XObject(value="repository")
public class RepositoryDescriptor {
    private static final Log log = LogFactory.getLog(RepositoryDescriptor.class);
    public static final int DEFAULT_READ_ACL_MAX_SIZE = 4096;
    public static final int DEFAULT_PATH_OPTIM_VERSION = 2;
    @XNode(value="@name")
    public String name;
    @XNode(value="@label")
    public String label;
    @XNode(value="@isDefault")
    private Boolean isDefault;
    @XNode(value="@factory")
    private Class<? extends RepositoryFactory> repositoryFactoryClass;
    @XNode(value="repository")
    public RepositoryDescriptor repositoryDescriptor;
    @XNode(value="pool")
    public NuxeoConnectionManagerConfiguration pool;
    @XNode(value="backendClass")
    public Class<? extends RepositoryBackend> backendClass;
    @XNode(value="cachingMapper@class")
    public Class<? extends CachingMapper> cachingMapperClass;
    @XNode(value="cachingMapper@enabled")
    private Boolean cachingMapperEnabled;
    @XNodeMap(value="cachingMapper/property", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> cachingMapperProperties = new HashMap<String, String>();
    @XNode(value="noDDL")
    private Boolean noDDL;
    @XNodeList(value="sqlInitFile", type=ArrayList.class, componentType=String.class)
    public List<String> sqlInitFiles = new ArrayList<String>(0);
    @XNode(value="softDelete@enabled")
    private Boolean softDeleteEnabled;
    @XNode(value="proxies@enabled")
    private Boolean proxiesEnabled;
    @XNode(value="idType")
    public String idType;
    @XNode(value="clustering@enabled")
    private Boolean clusteringEnabled;
    @XNode(value="clustering@delay")
    private Long clusteringDelay;
    @XNodeList(value="schema/field", type=ArrayList.class, componentType=FieldDescriptor.class)
    public List<FieldDescriptor> schemaFields = new ArrayList<FieldDescriptor>(0);
    @XNode(value="schema/arrayColumns")
    private Boolean arrayColumns;
    @XNode(value="indexing/fulltext@disabled")
    private Boolean fulltextDisabled;
    @XNode(value="indexing/fulltext@analyzer")
    public String fulltextAnalyzer;
    @XNode(value="indexing/fulltext@parser")
    public String fulltextParser;
    @XNode(value="indexing/fulltext@catalog")
    public String fulltextCatalog;
    @XNodeList(value="indexing/fulltext/index", type=ArrayList.class, componentType=FulltextIndexDescriptor.class)
    public List<FulltextIndexDescriptor> fulltextIndexes = new ArrayList<FulltextIndexDescriptor>(0);
    @XNodeList(value="indexing/excludedTypes/type", type=HashSet.class, componentType=String.class)
    public Set<String> fulltextExcludedTypes = new HashSet<String>(0);
    @XNodeList(value="indexing/includedTypes/type", type=HashSet.class, componentType=String.class)
    public Set<String> fulltextIncludedTypes = new HashSet<String>(0);
    @XNodeList(value="indexing/neverPerDocumentFacets/facet", type=HashSet.class, componentType=String.class)
    public Set<String> neverPerInstanceMixins = new HashSet<String>(0);
    @XNode(value="pathOptimizations@enabled")
    private Boolean pathOptimizationsEnabled;
    @XNode(value="pathOptimizations@version")
    private Integer pathOptimizationsVersion;
    @XNode(value="aclOptimizations@enabled")
    private Boolean aclOptimizationsEnabled;
    @XNode(value="aclOptimizations@readAclMaxSize")
    private Integer readAclMaxSize;
    @XNode(value="binaryManager@class")
    public Class<? extends BinaryManager> binaryManagerClass;
    @XNode(value="binaryManager@key")
    public String binaryManagerKey;
    @XNode(value="binaryStore@path")
    public String binaryStorePath;
    @XNode(value="@sendInvalidationEvents")
    public boolean sendInvalidationEvents;
    @XNode(value="usersSeparator@key")
    public String usersSeparatorKey;
    @XNode(value="xa-datasource")
    public String xaDataSourceName;
    @XNodeMap(value="property", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> properties = new HashMap<String, String>();

    private static boolean defaultFalse(Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    private static boolean defaultTrue(Boolean bool) {
        return !Boolean.FALSE.equals(bool);
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public Class<? extends RepositoryFactory> getRepositoryFactoryClass() {
        return this.repositoryFactoryClass;
    }

    public void setRepositoryFactoryClass(Class<? extends RepositoryFactory> klass) {
        this.repositoryFactoryClass = klass;
    }

    public boolean getCachingMapperEnabled() {
        return RepositoryDescriptor.defaultTrue(this.cachingMapperEnabled);
    }

    public boolean getNoDDL() {
        return RepositoryDescriptor.defaultFalse(this.noDDL);
    }

    public boolean getSoftDeleteEnabled() {
        return RepositoryDescriptor.defaultFalse(this.softDeleteEnabled);
    }

    protected void setSoftDeleteEnabled(boolean enabled) {
        this.softDeleteEnabled = enabled;
    }

    public boolean getProxiesEnabled() {
        return RepositoryDescriptor.defaultTrue(this.proxiesEnabled);
    }

    protected void setProxiesEnabled(boolean enabled) {
        this.proxiesEnabled = enabled;
    }

    public boolean getClusteringEnabled() {
        return RepositoryDescriptor.defaultFalse(this.clusteringEnabled);
    }

    protected void setClusteringEnabled(boolean enabled) {
        this.clusteringEnabled = enabled;
    }

    public long getClusteringDelay() {
        return this.clusteringDelay == null ? 0L : this.clusteringDelay;
    }

    protected void setClusteringDelay(long delay) {
        this.clusteringDelay = delay;
    }

    public boolean getArrayColumns() {
        return RepositoryDescriptor.defaultFalse(this.arrayColumns);
    }

    public void setArrayColumns(boolean enabled) {
        this.arrayColumns = enabled;
    }

    public boolean getFulltextDisabled() {
        return RepositoryDescriptor.defaultFalse(this.fulltextDisabled);
    }

    public void setFulltextDisabled(boolean disabled) {
        this.fulltextDisabled = disabled;
    }

    @XNode(value="indexing/queryMaker@class")
    public void setQueryMakerDeprecated(String klass) {
        log.warn((Object)"Setting queryMaker from repository configuration is now deprecated");
    }

    public boolean getPathOptimizationsEnabled() {
        return RepositoryDescriptor.defaultTrue(this.pathOptimizationsEnabled);
    }

    protected void setPathOptimizationsEnabled(boolean enabled) {
        this.pathOptimizationsEnabled = enabled;
    }

    public int getPathOptimizationsVersion() {
        return this.pathOptimizationsVersion == null ? 2 : this.pathOptimizationsVersion;
    }

    public boolean getAclOptimizationsEnabled() {
        return RepositoryDescriptor.defaultTrue(this.aclOptimizationsEnabled);
    }

    protected void setAclOptimizationsEnabled(boolean enabled) {
        this.aclOptimizationsEnabled = enabled;
    }

    public int getReadAclMaxSize() {
        return this.readAclMaxSize == null ? 4096 : this.readAclMaxSize;
    }

    public RepositoryDescriptor() {
    }

    public RepositoryDescriptor(RepositoryDescriptor other) {
        this.name = other.name;
        this.label = other.label;
        this.isDefault = other.isDefault;
        this.repositoryFactoryClass = other.repositoryFactoryClass;
        this.pool = other.pool == null ? null : new NuxeoConnectionManagerConfiguration(other.pool);
        this.backendClass = other.backendClass;
        this.cachingMapperClass = other.cachingMapperClass;
        this.cachingMapperEnabled = other.cachingMapperEnabled;
        this.cachingMapperProperties = new HashMap<String, String>(other.cachingMapperProperties);
        this.noDDL = other.noDDL;
        this.sqlInitFiles = new ArrayList<String>(other.sqlInitFiles);
        this.softDeleteEnabled = other.softDeleteEnabled;
        this.proxiesEnabled = other.proxiesEnabled;
        this.schemaFields = FieldDescriptor.copyList(other.schemaFields);
        this.arrayColumns = other.arrayColumns;
        this.idType = other.idType;
        this.clusteringEnabled = other.clusteringEnabled;
        this.clusteringDelay = other.clusteringDelay;
        this.fulltextDisabled = other.fulltextDisabled;
        this.fulltextAnalyzer = other.fulltextAnalyzer;
        this.fulltextParser = other.fulltextParser;
        this.fulltextCatalog = other.fulltextCatalog;
        this.fulltextIndexes = FulltextIndexDescriptor.copyList(other.fulltextIndexes);
        this.fulltextExcludedTypes = new HashSet<String>(other.fulltextExcludedTypes);
        this.fulltextIncludedTypes = new HashSet<String>(other.fulltextIncludedTypes);
        this.neverPerInstanceMixins = other.neverPerInstanceMixins;
        this.pathOptimizationsEnabled = other.pathOptimizationsEnabled;
        this.pathOptimizationsVersion = other.pathOptimizationsVersion;
        this.aclOptimizationsEnabled = other.aclOptimizationsEnabled;
        this.readAclMaxSize = other.readAclMaxSize;
        this.binaryManagerClass = other.binaryManagerClass;
        this.binaryManagerKey = other.binaryManagerKey;
        this.binaryStorePath = other.binaryStorePath;
        this.sendInvalidationEvents = other.sendInvalidationEvents;
        this.usersSeparatorKey = other.usersSeparatorKey;
        this.xaDataSourceName = other.xaDataSourceName;
        this.properties = new HashMap<String, String>(other.properties);
    }

    public void merge(RepositoryDescriptor other) {
        boolean append;
        if (other.name != null) {
            this.name = other.name;
        }
        if (other.label != null) {
            this.label = other.label;
        }
        if (other.isDefault != null) {
            this.isDefault = other.isDefault;
        }
        if (other.repositoryFactoryClass != null) {
            this.repositoryFactoryClass = other.repositoryFactoryClass;
        }
        if (other.pool != null) {
            this.pool = new NuxeoConnectionManagerConfiguration(other.pool);
        }
        if (other.backendClass != null) {
            this.backendClass = other.backendClass;
        }
        if (other.cachingMapperClass != null) {
            this.cachingMapperClass = other.cachingMapperClass;
        }
        if (other.cachingMapperEnabled != null) {
            this.cachingMapperEnabled = other.cachingMapperEnabled;
        }
        this.cachingMapperProperties.putAll(other.cachingMapperProperties);
        if (other.noDDL != null) {
            this.noDDL = other.noDDL;
        }
        this.sqlInitFiles.addAll(other.sqlInitFiles);
        if (other.softDeleteEnabled != null) {
            this.softDeleteEnabled = other.softDeleteEnabled;
        }
        if (other.proxiesEnabled != null) {
            this.proxiesEnabled = other.proxiesEnabled;
        }
        if (other.idType != null) {
            this.idType = other.idType;
        }
        if (other.clusteringEnabled != null) {
            this.clusteringEnabled = other.clusteringEnabled;
        }
        if (other.clusteringDelay != null) {
            this.clusteringDelay = other.clusteringDelay;
        }
        for (FieldDescriptor of : other.schemaFields) {
            append = true;
            for (FieldDescriptor f : this.schemaFields) {
                if (!f.field.equals(of.field)) continue;
                f.merge(of);
                append = false;
                break;
            }
            if (!append) continue;
            this.schemaFields.add(of);
        }
        if (other.arrayColumns != null) {
            this.arrayColumns = other.arrayColumns;
        }
        if (other.fulltextDisabled != null) {
            this.fulltextDisabled = other.fulltextDisabled;
        }
        if (other.fulltextAnalyzer != null) {
            this.fulltextAnalyzer = other.fulltextAnalyzer;
        }
        if (other.fulltextParser != null) {
            this.fulltextParser = other.fulltextParser;
        }
        if (other.fulltextCatalog != null) {
            this.fulltextCatalog = other.fulltextCatalog;
        }
        for (FulltextIndexDescriptor oi : other.fulltextIndexes) {
            append = true;
            for (FulltextIndexDescriptor i : this.fulltextIndexes) {
                if (!ObjectUtils.equals((Object)i.name, (Object)oi.name)) continue;
                i.merge(oi);
                append = false;
                break;
            }
            if (!append) continue;
            this.fulltextIndexes.add(oi);
        }
        this.fulltextExcludedTypes.addAll(other.fulltextExcludedTypes);
        this.fulltextIncludedTypes.addAll(other.fulltextIncludedTypes);
        this.neverPerInstanceMixins.addAll(other.neverPerInstanceMixins);
        if (other.pathOptimizationsEnabled != null) {
            this.pathOptimizationsEnabled = other.pathOptimizationsEnabled;
        }
        if (other.pathOptimizationsVersion != null) {
            this.pathOptimizationsVersion = other.pathOptimizationsVersion;
        }
        if (other.aclOptimizationsEnabled != null) {
            this.aclOptimizationsEnabled = other.aclOptimizationsEnabled;
        }
        if (other.readAclMaxSize != null) {
            this.readAclMaxSize = other.readAclMaxSize;
        }
        if (other.binaryManagerClass != null) {
            this.binaryManagerClass = other.binaryManagerClass;
        }
        if (other.binaryManagerKey != null) {
            this.binaryManagerKey = other.binaryManagerKey;
        }
        if (other.binaryStorePath != null) {
            this.binaryStorePath = other.binaryStorePath;
        }
        this.sendInvalidationEvents = other.sendInvalidationEvents;
        if (other.usersSeparatorKey != null) {
            this.usersSeparatorKey = other.usersSeparatorKey;
        }
        if (other.xaDataSourceName != null) {
            this.xaDataSourceName = other.xaDataSourceName;
        }
        this.properties.putAll(other.properties);
    }

    @XObject(value="field")
    public static class FieldDescriptor {
        @XNode(value="@type")
        public String type;
        public String field;
        @XNode(value="@table")
        public String table;
        @XNode(value="@column")
        public String column;

        public FieldDescriptor() {
        }

        public FieldDescriptor(FieldDescriptor other) {
            this.type = other.type;
            this.field = other.field;
            this.table = other.table;
            this.column = other.column;
        }

        public static List<FieldDescriptor> copyList(List<FieldDescriptor> other) {
            ArrayList<FieldDescriptor> copy = new ArrayList<FieldDescriptor>(other.size());
            for (FieldDescriptor fd : other) {
                copy.add(new FieldDescriptor(fd));
            }
            return copy;
        }

        public void merge(FieldDescriptor other) {
            if (other.field != null) {
                this.field = other.field;
            }
            if (other.type != null) {
                this.type = other.type;
            }
            if (other.table != null) {
                this.table = other.table;
            }
            if (other.column != null) {
                this.column = other.column;
            }
        }

        @XNode(value="@name")
        public void setName(String name) {
            if (!StringUtils.isBlank((String)name) && this.field == null) {
                this.field = name;
            }
        }

        @XNode
        public void setXNodeContent(String name) {
            this.setName(name);
        }

        public String toString() {
            return this.getClass().getSimpleName() + '(' + this.field + ",type=" + this.type + ",table=" + this.table + ",column=" + this.column + ")";
        }
    }

    @XObject(value="index")
    public static class FulltextIndexDescriptor {
        @XNode(value="@name")
        public String name;
        @XNode(value="@analyzer")
        public String analyzer;
        @XNode(value="@catalog")
        public String catalog;
        @XNode(value="fieldType")
        public String fieldType;
        @XNodeList(value="field", type=HashSet.class, componentType=String.class)
        public Set<String> fields = new HashSet<String>(0);
        @XNodeList(value="excludeField", type=HashSet.class, componentType=String.class)
        public Set<String> excludeFields = new HashSet<String>(0);

        public FulltextIndexDescriptor() {
        }

        public FulltextIndexDescriptor(FulltextIndexDescriptor other) {
            this.name = other.name;
            this.analyzer = other.analyzer;
            this.catalog = other.catalog;
            this.fieldType = other.fieldType;
            this.fields = new HashSet<String>(other.fields);
            this.excludeFields = new HashSet<String>(other.excludeFields);
        }

        public static List<FulltextIndexDescriptor> copyList(List<FulltextIndexDescriptor> other) {
            ArrayList<FulltextIndexDescriptor> copy = new ArrayList<FulltextIndexDescriptor>(other.size());
            for (FulltextIndexDescriptor fid : other) {
                copy.add(new FulltextIndexDescriptor(fid));
            }
            return copy;
        }

        public void merge(FulltextIndexDescriptor other) {
            if (other.name != null) {
                this.name = other.name;
            }
            if (other.analyzer != null) {
                this.analyzer = other.analyzer;
            }
            if (other.catalog != null) {
                this.catalog = other.catalog;
            }
            if (other.fieldType != null) {
                this.fieldType = other.fieldType;
            }
            this.fields.addAll(other.fields);
            this.excludeFields.addAll(other.excludeFields);
        }
    }
}

