/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.requestcontroller.service;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.NuxeoCorsFilterDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class NuxeoCorsFilterDescriptorRegistry
extends ContributionFragmentRegistry<NuxeoCorsFilterDescriptor> {
    protected Map<String, NuxeoCorsFilterDescriptor> descs = new HashMap<String, NuxeoCorsFilterDescriptor>();

    public String getContributionId(NuxeoCorsFilterDescriptor contrib) {
        return contrib.name;
    }

    public void contributionUpdated(String id, NuxeoCorsFilterDescriptor contrib, NuxeoCorsFilterDescriptor newOrigContrib) {
        if (this.descs.containsKey(id)) {
            this.descs.remove(id);
        }
        if (contrib.enabled.booleanValue()) {
            this.descs.put(id, contrib);
        }
    }

    public void contributionRemoved(String id, NuxeoCorsFilterDescriptor origContrib) {
        if (this.descs.containsKey(id)) {
            this.descs.remove(id);
        }
    }

    public NuxeoCorsFilterDescriptor clone(NuxeoCorsFilterDescriptor orig) {
        try {
            return orig.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void merge(NuxeoCorsFilterDescriptor src, NuxeoCorsFilterDescriptor dst) {
        dst.merge(src);
    }

    public NuxeoCorsFilterDescriptor getFirstMatchingDescriptor(String uri) {
        for (NuxeoCorsFilterDescriptor filterDesc : this.descs.values()) {
            Pattern pattern = Pattern.compile(filterDesc.pattern);
            if (!pattern.matcher(uri).matches()) continue;
            return filterDesc;
        }
        return null;
    }
}

