/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.directory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class DirectoryTreeRegistry
extends ContributionFragmentRegistry<DirectoryTreeDescriptor> {
    private static final Log log = LogFactory.getLog(DirectoryTreeRegistry.class);
    protected Map<String, DirectoryTreeDescriptor> registry = new HashMap<String, DirectoryTreeDescriptor>();

    public String getContributionId(DirectoryTreeDescriptor contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, DirectoryTreeDescriptor contrib, DirectoryTreeDescriptor newOrigContrib) {
        if (this.registry.containsKey(contrib.getName())) {
            DirectoryTreeDescriptor existing_descriptor = this.registry.get(contrib.getName());
            existing_descriptor.merge(contrib);
            log.debug((Object)("merged DirectoryTreeDescriptor: " + contrib.getName()));
        } else {
            this.registry.put(contrib.getName(), contrib);
            log.debug((Object)("registered DirectoryTreeDescriptor: " + contrib.getName()));
        }
    }

    public void contributionRemoved(String id, DirectoryTreeDescriptor contrib) {
        this.registry.remove(contrib.getName());
        log.debug((Object)("unregistered DirectoryTreeDescriptor: " + contrib.getName()));
    }

    public DirectoryTreeDescriptor clone(DirectoryTreeDescriptor orig) {
        return orig.clone();
    }

    public void merge(DirectoryTreeDescriptor src, DirectoryTreeDescriptor dst) {
        dst.merge(src);
    }

    public List<String> getDirectoryTrees() {
        ArrayList<String> directoryTrees = new ArrayList<String>();
        for (DirectoryTreeDescriptor desc : this.registry.values()) {
            if (!Boolean.TRUE.equals(desc.getEnabled())) continue;
            directoryTrees.add(desc.getName());
        }
        Collections.sort(directoryTrees);
        return directoryTrees;
    }

    public DirectoryTreeDescriptor getDirectoryTreeDescriptor(String treeName) {
        DirectoryTreeDescriptor desc = this.registry.get(treeName);
        if (Boolean.TRUE.equals(desc.getEnabled())) {
            return desc;
        }
        return null;
    }

    public List<String> getNavigationDirectoryTrees() {
        ArrayList<String> directoryTrees = new ArrayList<String>();
        for (DirectoryTreeDescriptor desc : this.registry.values()) {
            if (!Boolean.TRUE.equals(desc.getEnabled()) || !desc.isNavigationTree()) continue;
            directoryTrees.add(desc.getName());
        }
        Collections.sort(directoryTrees);
        return directoryTrees;
    }
}

