/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.directory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.webapp.directory.VocabularyTreeNode;
import org.nuxeo.runtime.api.Framework;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="vocabularyTreeActions")
@Install(precedence=10)
public class VocabularyTreeActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(VocabularyTreeActions.class);
    @Deprecated
    public static final String L10NVOCABULARY_SCHEMA = "l10nvocabulary";
    @Deprecated
    public static final String L10NXVOCABULARY_SCHEMA = "l10nxvocabulary";
    protected transient Map<String, VocabularyTreeNode> treeModels;

    public VocabularyTreeNode get(String vocabularyName, boolean displayObsoleteEntries, char keySeparator, String orderingField) {
        VocabularyTreeNode treeModel;
        if (this.treeModels == null) {
            this.treeModels = new HashMap<String, VocabularyTreeNode>();
        }
        if ((treeModel = this.treeModels.get(vocabularyName)) != null) {
            return treeModel;
        }
        DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        try {
            Directory directory = ((DirectoryService)Framework.getLocalService(DirectoryService.class)).getDirectory(vocabularyName);
            if (directory == null) {
                throw new DirectoryException(vocabularyName + " is not a registered directory");
            }
        }
        catch (DirectoryException e) {
            throw new RuntimeException(e);
        }
        treeModel = new VocabularyTreeNode(0, "", "", "", vocabularyName, directoryService, displayObsoleteEntries, keySeparator, orderingField);
        this.treeModels.put(vocabularyName, treeModel);
        return treeModel;
    }

    public List<VocabularyTreeNode> getRoots(String vocabularyName, boolean displayObsoleteEntries, char keySeparator, String orderingField) {
        return this.get(vocabularyName, displayObsoleteEntries, keySeparator, orderingField).getChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLabelFor(String vocabularyName, String path, char keySeparator) {
        Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        String schemaName = null;
        Session session = null;
        ArrayList<String> labels = new ArrayList<String>();
        try {
            DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
            schemaName = directoryService.getDirectorySchema(vocabularyName);
            session = directoryService.open(vocabularyName);
            for (String id : StringUtils.split((String)path, (char)keySeparator)) {
                String computeLabel = VocabularyTreeNode.computeLabel(locale, session.getEntry(id), schemaName);
                if (computeLabel == null) {
                    labels.add(id);
                    continue;
                }
                labels.add(computeLabel);
            }
        }
        catch (DirectoryException e) {
            log.error((Object)("Error while accessing directory " + vocabularyName), (Throwable)e);
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (DirectoryException e) {
                log.error((Object)("Error while closing directory " + vocabularyName), (Throwable)e);
            }
        }
        if (labels.isEmpty()) {
            return null;
        }
        return StringUtils.join(labels, (char)keySeparator);
    }

    @Observer(value={"directoryChanged"})
    public void invalidate(String vocabularyName) {
        if (this.treeModels != null) {
            this.treeModels.remove(vocabularyName);
        }
    }
}

