/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.directory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;
import org.nuxeo.runtime.api.Framework;

public class VocabularyTreeNode {
    private static final Log log = LogFactory.getLog(VocabularyTreeNode.class);
    public static final String PARENT_FIELD_ID = "parent";
    public static final String LABEL_FIELD_PREFIX = "label_";
    public static final String DEFAULT_LANGUAGE = "en";
    public static final String OBSOLETE_FIELD = "obsolete";
    protected final String path;
    protected final int level;
    protected String id;
    protected String label;
    protected DirectoryService directoryService;
    protected List<VocabularyTreeNode> children;
    protected String vocabularyName;
    protected DocumentModelList childrenEntries;
    protected boolean displayObsoleteEntries;
    protected String orderingField;
    protected Comparable orderingValue;
    protected char keySeparator;

    public VocabularyTreeNode(int level, String id, String description, String path, String vocabularyName, DirectoryService directoryService) {
        this(level, id, description, path, vocabularyName, directoryService, false, '/', null);
    }

    public VocabularyTreeNode(int level, String id, String description, String path, String vocabularyName, DirectoryService directoryService, boolean displayObsoleteEntries, char keySeparator, String orderingField) {
        this(level, id, description, path, vocabularyName, directoryService, displayObsoleteEntries, keySeparator, orderingField, null);
    }

    public VocabularyTreeNode(int level, String id, String description, String path, String vocabularyName, DirectoryService directoryService, boolean displayObsoleteEntries, char keySeparator, String orderingField, Comparable orderingValue) {
        this.level = level;
        this.id = id;
        this.label = description;
        this.path = path;
        this.vocabularyName = vocabularyName;
        this.directoryService = directoryService;
        this.displayObsoleteEntries = displayObsoleteEntries;
        this.keySeparator = keySeparator;
        this.orderingField = orderingField;
        this.orderingValue = orderingValue;
    }

    public List<VocabularyTreeNode> getChildren() {
        if (this.children != null) {
            return this.children;
        }
        this.children = new ArrayList<VocabularyTreeNode>();
        try {
            String schemaName = this.getDirectorySchema();
            DocumentModelList results = this.getChildrenEntries();
            Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
            for (DocumentModel result : results) {
                String childIdendifier = result.getId();
                String childLabel = VocabularyTreeNode.computeLabel(locale, result, schemaName);
                String childPath = "".equals(this.path) ? childIdendifier : this.path + this.keySeparator + childIdendifier;
                Comparable orderingValue = null;
                if (!StringUtils.isBlank((String)this.orderingField)) {
                    orderingValue = (Comparable)result.getProperty(schemaName, this.orderingField);
                }
                this.children.add(new VocabularyTreeNode(this.level + 1, childIdendifier, childLabel, childPath, this.vocabularyName, this.getDirectoryService(), this.displayObsoleteEntries, this.keySeparator, this.orderingField, orderingValue));
            }
            Comparator<VocabularyTreeNode> cmp = StringUtils.isBlank((String)this.orderingField) || "label".equals(this.orderingField) ? new LabelComparator() : new OrderingComparator();
            Collections.sort(this.children, cmp);
            return this.children;
        }
        catch (ClientException e) {
            log.error((Object)e);
            return this.children;
        }
    }

    public static String computeLabel(Locale locale, DocumentModel entry, String schemaName) {
        String fieldName = LABEL_FIELD_PREFIX + locale.toString();
        String label = null;
        try {
            label = (String)entry.getProperty(schemaName, fieldName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (label == null) {
            fieldName = LABEL_FIELD_PREFIX + locale.getLanguage();
            try {
                label = (String)entry.getProperty(schemaName, fieldName);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (label == null) {
            fieldName = "label_en";
            try {
                label = (String)entry.getProperty(schemaName, fieldName);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocumentModelList getChildrenEntries() throws ClientException {
        if (this.childrenEntries != null) {
            return this.childrenEntries;
        }
        try (Session session = this.getDirectorySession();){
            HashMap<String, Object> filter = new HashMap<String, Object>();
            String directorySchema = this.getDirectorySchema();
            SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
            Schema schema = schemaManager.getSchema(directorySchema);
            if (schema == null) {
                throw new DirectoryException(directorySchema + " is not a registered directory");
            }
            if (this.level == 0 && schema.hasField(PARENT_FIELD_ID)) {
                filter.put(PARENT_FIELD_ID, "");
            } else {
                String[] bitsOfPath = StringUtils.split((String)this.path, (char)this.keySeparator);
                filter.put(PARENT_FIELD_ID, bitsOfPath[this.level - 1]);
            }
            if (!this.displayObsoleteEntries) {
                filter.put(OBSOLETE_FIELD, 0L);
            }
            this.childrenEntries = filter.isEmpty() ? session.getEntries() : session.query(filter);
            DocumentModelList documentModelList = this.childrenEntries;
            return documentModelList;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPath() {
        return this.path;
    }

    public Comparable getOrdering() {
        return this.orderingValue;
    }

    protected DirectoryService getDirectoryService() {
        if (this.directoryService == null) {
            this.directoryService = DirectoryHelper.getDirectoryService();
        }
        return this.directoryService;
    }

    protected String getDirectorySchema() throws ClientException {
        return this.getDirectoryService().getDirectorySchema(this.vocabularyName);
    }

    protected Session getDirectorySession() throws ClientException {
        return this.getDirectoryService().open(this.vocabularyName);
    }

    private class OrderingComparator
    implements Comparator<VocabularyTreeNode> {
        private OrderingComparator() {
        }

        @Override
        public int compare(VocabularyTreeNode o1, VocabularyTreeNode o2) {
            if (o1.getOrdering() == null && o2.getOrdering() != null) {
                return -1;
            }
            if (o1.getOrdering() != null && o2.getOrdering() == null) {
                return 1;
            }
            if (o1.getOrdering() == o2.getOrdering()) {
                return 0;
            }
            return o1.getOrdering().compareTo(o2.getOrdering());
        }
    }

    private class LabelComparator
    implements Comparator<VocabularyTreeNode> {
        private LabelComparator() {
        }

        @Override
        public int compare(VocabularyTreeNode o1, VocabularyTreeNode o2) {
            return ObjectUtils.compare((Comparable)((Object)o1.getLabel()), (Comparable)((Object)o2.getLabel()));
        }
    }
}

