/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.binary;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.nuxeo.common.file.FileCache;
import org.nuxeo.common.file.LRUFileCache;
import org.nuxeo.ecm.core.storage.binary.AbstractBinaryManager;
import org.nuxeo.ecm.core.storage.binary.Binary;
import org.nuxeo.ecm.core.storage.binary.FileStorage;
import org.nuxeo.ecm.core.storage.binary.LazyBinary;
import org.nuxeo.runtime.api.Framework;

public abstract class CachingBinaryManager
extends AbstractBinaryManager {
    protected static final String LEN_DIGEST_SUFFIX = "-len";
    public FileCache fileCache;
    protected FileStorage fileStorage;

    public void initializeCache(File dir, long maxSize, FileStorage fileStorage) {
        this.fileCache = new LRUFileCache(dir, maxSize);
        this.fileStorage = fileStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Binary getBinary(InputStream in) throws IOException {
        String digest;
        File tmp = this.fileCache.getTempFile();
        FileOutputStream out = new FileOutputStream(tmp);
        try {
            digest = this.storeAndDigest(in, out);
        }
        finally {
            in.close();
            ((OutputStream)out).close();
        }
        File cachedFile = this.fileCache.getFile(digest);
        if (cachedFile != null) {
            if (Framework.isTestModeSet()) {
                Framework.getProperties().setProperty("cachedBinary", digest);
            }
            tmp.delete();
            return new Binary(cachedFile, digest, this.repositoryName);
        }
        this.fileStorage.storeFile(digest, tmp);
        File file = this.fileCache.putFile(digest, tmp);
        return new Binary(file, digest, this.repositoryName);
    }

    @Override
    public Binary getBinary(String digest) {
        File file = this.fileCache.getFile(digest);
        if (file == null) {
            return new LazyBinary(digest, this.repositoryName, this);
        }
        return new Binary(file, digest, this.repositoryName);
    }

    public File getFile(String digest) throws IOException {
        File file = this.fileCache.getFile(digest);
        if (file != null) {
            return file;
        }
        File tmp = this.fileCache.getTempFile();
        if (this.fileStorage.fetchFile(digest, tmp)) {
            file = this.fileCache.putFile(digest, tmp);
            return file;
        }
        tmp.delete();
        return null;
    }

    public Long getLength(String digest) throws IOException {
        Long length = this.getLengthFromCache(digest);
        if (length != null) {
            return length;
        }
        length = this.fileStorage.fetchLength(digest);
        this.putLengthInCache(digest, length);
        return length;
    }

    protected Long getLengthFromCache(String digest) throws IOException {
        Long l;
        File f = this.fileCache.getFile(digest + LEN_DIGEST_SUFFIX);
        if (f == null) {
            return null;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(f);
            String len = IOUtils.toString((InputStream)in);
            l = Long.valueOf(len);
        }
        catch (NumberFormatException e) {
            try {
                throw new IOException("Invalid length in " + f, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putLengthInCache(String digest, Long len) throws IOException {
        FileOutputStream out = null;
        try {
            File tmp = this.fileCache.getTempFile();
            out = new FileOutputStream(tmp);
            OutputStreamWriter writer = new OutputStreamWriter(out);
            writer.write(len.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            this.fileCache.putFile(digest + LEN_DIGEST_SUFFIX, tmp);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
    }
}

