/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.ecm.core.storage.CopyHelper;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSDocumentState;
import org.nuxeo.ecm.core.storage.dbs.DBSRepository;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.ecm.core.storage.dbs.FulltextConfiguration;
import org.nuxeo.ecm.core.storage.dbs.FulltextExtractorWork;
import org.nuxeo.ecm.core.storage.dbs.FulltextParser;
import org.nuxeo.ecm.core.storage.dbs.FulltextUpdaterWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;

public class DBSTransactionState {
    private static final Log log = LogFactory.getLog(DBSTransactionState.class);
    protected final DBSRepository repository;
    protected final DBSSession session;
    protected Map<String, DBSDocumentState> transientStates = new HashMap<String, DBSDocumentState>();
    protected Set<String> transientCreated = new LinkedHashSet<String>();
    protected Map<String, DBSDocumentState> savedStates = new HashMap<String, DBSDocumentState>();
    protected Set<String> savedCreated = new LinkedHashSet<String>();
    protected Set<String> savedDeleted = new HashSet<String>();
    protected final Set<String> browsePermissions;

    public DBSTransactionState(DBSRepository repository, DBSSession session) {
        this.repository = repository;
        this.session = session;
        SecurityService securityService = (SecurityService)Framework.getLocalService(SecurityService.class);
        this.browsePermissions = new HashSet<String>(Arrays.asList(securityService.getPermissionsToCheck("Browse")));
    }

    protected DBSDocumentState makeTransient(DBSDocumentState docState) {
        String id = docState.getId();
        if (this.transientStates.containsKey(id)) {
            throw new IllegalStateException("Already transient: " + id);
        }
        docState = new DBSDocumentState(docState);
        this.transientStates.put(id, docState);
        return docState;
    }

    protected DBSDocumentState returnTransient(State state) {
        String id = (String)state.get((Object)"ecm:id");
        if (this.transientStates.containsKey(id)) {
            throw new IllegalStateException("Already transient: " + id);
        }
        DBSDocumentState docState = new DBSDocumentState(state);
        this.transientStates.put(id, docState);
        return docState;
    }

    public void removeState(String id) {
        this.transientStates.remove(id);
        if (this.transientCreated.remove(id)) {
            return;
        }
        this.savedStates.remove(id);
        if (this.savedCreated.remove(id)) {
            return;
        }
        this.savedDeleted.add(id);
    }

    public DBSDocumentState getStateForUpdate(String id) {
        DBSDocumentState docState = this.transientStates.get(id);
        if (docState != null) {
            return docState;
        }
        if (this.savedDeleted.contains(id)) {
            return null;
        }
        docState = this.savedStates.get(id);
        if (docState != null) {
            return this.makeTransient(docState);
        }
        State state = this.repository.readState(id);
        if (state != null) {
            return this.returnTransient(state);
        }
        return null;
    }

    public DBSDocumentState getStateForNonTransientUpdate(String id) {
        if (this.savedDeleted.contains(id)) {
            return null;
        }
        DBSDocumentState docState = this.savedStates.get(id);
        if (docState != null) {
            return docState;
        }
        State state = this.repository.readState(id);
        if (state != null) {
            docState = new DBSDocumentState(state);
            this.savedStates.put(id, docState);
            return docState;
        }
        return null;
    }

    public State getStateForRead(String id) {
        DBSDocumentState docState = this.transientStates.get(id);
        if (docState != null) {
            return docState.getState();
        }
        if (this.savedDeleted.contains(id)) {
            return null;
        }
        docState = this.savedStates.get(id);
        if (docState != null) {
            return docState.getState();
        }
        State state = this.repository.readState(id);
        if (state != null) {
            return state;
        }
        return null;
    }

    public List<DBSDocumentState> getStatesForUpdate(List<String> ids) {
        LinkedList<String> idsToFetch = new LinkedList<String>();
        for (String id : ids) {
            DBSDocumentState docState = this.transientStates.get(id);
            if (docState != null || this.savedDeleted.contains(id)) continue;
            docState = this.savedStates.get(id);
            if (docState != null) {
                this.makeTransient(docState);
                continue;
            }
            idsToFetch.add(id);
        }
        if (!idsToFetch.isEmpty()) {
            List<State> states = this.repository.readStates(idsToFetch);
            for (State state : states) {
                if (state == null) continue;
                this.returnTransient(state);
            }
        }
        ArrayList<DBSDocumentState> docStates = new ArrayList<DBSDocumentState>(ids.size());
        for (String id : ids) {
            DBSDocumentState docState = this.transientStates.get(id);
            if (docState != null) {
                docStates.add(docState);
                continue;
            }
            log.warn((Object)("Cannot fetch document with id: " + id), new Throwable("debug stack trace"));
        }
        return docStates;
    }

    public DBSDocumentState getChildState(String parentId, String name) {
        if (this.savedDeleted.contains(parentId)) {
            return null;
        }
        HashSet<String> seen = new HashSet<String>();
        for (DBSDocumentState docState : this.transientStates.values()) {
            seen.add(docState.getId());
            if (!parentId.equals(docState.getParentId()) || !name.equals(docState.getName())) continue;
            return docState;
        }
        for (DBSDocumentState docState : this.savedStates.values()) {
            if (!seen.add(docState.getId()) || !parentId.equals(docState.getParentId()) || !name.equals(docState.getName())) continue;
            return this.makeTransient(docState);
        }
        State state = this.repository.readChildState(parentId, name, seen);
        if (state != null) {
            return this.returnTransient(state);
        }
        return null;
    }

    public boolean hasChild(String parentId, String name) {
        if (this.savedDeleted.contains(parentId)) {
            return false;
        }
        HashSet<String> seen = new HashSet<String>();
        for (DBSDocumentState docState : this.transientStates.values()) {
            seen.add(docState.getId());
            if (!parentId.equals(docState.getParentId()) || !name.equals(docState.getName())) continue;
            return true;
        }
        for (DBSDocumentState docState : this.savedStates.values()) {
            if (!seen.add(docState.getId()) || !parentId.equals(docState.getParentId()) || !name.equals(docState.getName())) continue;
            return true;
        }
        return this.repository.hasChild(parentId, name, seen);
    }

    public List<DBSDocumentState> getChildrenStates(String parentId) {
        if (this.savedDeleted.contains(parentId)) {
            return Collections.emptyList();
        }
        LinkedList<DBSDocumentState> children = new LinkedList<DBSDocumentState>();
        HashSet<String> seen = new HashSet<String>();
        for (DBSDocumentState docState : this.transientStates.values()) {
            seen.add(docState.getId());
            if (!parentId.equals(docState.getParentId())) continue;
            children.add(docState);
        }
        for (DBSDocumentState docState : this.savedStates.values()) {
            if (!seen.add(docState.getId()) || !parentId.equals(docState.getParentId())) continue;
            docState = this.makeTransient(docState);
            children.add(docState);
        }
        List<State> states = this.repository.queryKeyValue("ecm:parentId", parentId, seen);
        for (State state : states) {
            DBSDocumentState docState = this.returnTransient(state);
            children.add(docState);
        }
        return children;
    }

    public List<String> getChildrenIds(String parentId) {
        String id;
        if (this.savedDeleted.contains(parentId)) {
            return Collections.emptyList();
        }
        ArrayList<String> children = new ArrayList<String>();
        HashSet<String> seen = new HashSet<String>();
        for (DBSDocumentState docState : this.transientStates.values()) {
            id = docState.getId();
            seen.add(id);
            if (!parentId.equals(docState.getParentId())) continue;
            children.add(id);
        }
        for (DBSDocumentState docState : this.savedStates.values()) {
            id = docState.getId();
            if (!seen.add(id) || !parentId.equals(docState.getParentId())) continue;
            children.add(id);
        }
        List<State> states = this.repository.queryKeyValue("ecm:parentId", parentId, seen);
        for (State state : states) {
            children.add((String)state.get((Object)"ecm:id"));
        }
        return new ArrayList<String>(children);
    }

    public boolean hasChildren(String parentId) {
        if (this.savedDeleted.contains(parentId)) {
            return false;
        }
        HashSet<String> seen = new HashSet<String>();
        for (DBSDocumentState docState : this.transientStates.values()) {
            seen.add(docState.getId());
            if (!parentId.equals(docState.getParentId())) continue;
            return true;
        }
        for (DBSDocumentState docState : this.savedStates.values()) {
            if (!seen.add(docState.getId()) || !parentId.equals(docState.getParentId())) continue;
            return true;
        }
        return this.repository.queryKeyValuePresence("ecm:parentId", parentId, seen);
    }

    public DBSDocumentState createChild(String id, String parentId, String name, Long pos, String typeName) {
        id = this.generateNewId(id);
        this.transientCreated.add(id);
        DBSDocumentState docState = new DBSDocumentState();
        this.transientStates.put(id, docState);
        docState.put("ecm:id", (Serializable)((Object)id));
        docState.put("ecm:parentId", (Serializable)((Object)parentId));
        docState.put("ecm:ancestorIds", (Serializable)this.getAncestorIds(parentId));
        docState.put("ecm:name", (Serializable)((Object)name));
        docState.put("ecm:pos", pos);
        docState.put("ecm:primaryType", (Serializable)((Object)typeName));
        this.updateReadAcls(id);
        return docState;
    }

    protected Object[] getAncestorIds(String id) {
        if (id == null) {
            return null;
        }
        State state = this.getStateForRead(id);
        if (state == null) {
            throw new RuntimeException("No such id: " + id);
        }
        Object[] ancestors = (Object[])state.get((Object)"ecm:ancestorIds");
        if (ancestors == null) {
            return new Object[]{id};
        }
        Object[] newAncestors = new Object[ancestors.length + 1];
        System.arraycopy(ancestors, 0, newAncestors, 0, ancestors.length);
        newAncestors[ancestors.length] = id;
        return newAncestors;
    }

    public DBSDocumentState copy(String id) {
        DBSDocumentState copyState = new DBSDocumentState(this.getStateForRead(id));
        String copyId = this.generateNewId(null);
        copyState.put("ecm:id", (Serializable)((Object)copyId));
        this.savedStates.put(copyId, copyState);
        this.savedCreated.add(copyId);
        return copyState;
    }

    public void updateAncestors(String id, int ndel, Object[] ancestorIds) {
        int nadd = ancestorIds.length;
        Set<String> ids = this.getSubTree(id, null, null);
        ids.add(id);
        for (String cid : ids) {
            Object[] newAncestors;
            DBSDocumentState docState = this.getStateForUpdate(cid);
            Object[] ancestors = (Object[])docState.get("ecm:ancestorIds");
            if (ancestors == null) {
                newAncestors = (Object[])ancestorIds.clone();
            } else {
                newAncestors = new Object[ancestors.length - ndel + nadd];
                System.arraycopy(ancestorIds, 0, newAncestors, 0, nadd);
                System.arraycopy(ancestors, ndel, newAncestors, nadd, ancestors.length - ndel);
            }
            docState.put("ecm:ancestorIds", (Serializable)newAncestors);
        }
    }

    public void updateReadAcls(String id) {
        Set<String> ids = this.getSubTree(id, null, null);
        ids.add(id);
        for (String cid : ids) {
            DBSDocumentState docState = this.getStateForUpdate(cid);
            docState.put("ecm:racl", (Serializable)this.getReadACL(docState));
        }
    }

    protected String[] getReadACL(DBSDocumentState docState) {
        HashSet<String> racls = new HashSet<String>();
        State state = docState.getState();
        block0: do {
            List aclList;
            if ((aclList = (List)state.get((Object)"ecm:acp")) != null) {
                for (Serializable aclSer : aclList) {
                    State aclMap = (State)aclSer;
                    List aceList = (List)aclMap.get((Object)"acl");
                    for (Serializable aceSer : aceList) {
                        State aceMap = (State)aceSer;
                        String username = (String)aceMap.get((Object)"user");
                        String permission = (String)aceMap.get((Object)"perm");
                        Boolean granted = (Boolean)aceMap.get((Object)"grant");
                        if (Boolean.TRUE.equals(granted) && this.browsePermissions.contains(permission)) {
                            racls.add(username);
                        }
                        if (!Boolean.FALSE.equals(granted)) continue;
                        if ("Everyone".equals(username)) break block0;
                        racls.add("_UNSUPPORTED_ACL_");
                        break block0;
                    }
                }
            }
            if (Boolean.TRUE.equals(state.get((Object)"ecm:isVersion"))) {
                String versionSeriesId = (String)state.get((Object)"ecm:versionSeriesId");
                state = versionSeriesId == null ? null : this.getStateForRead(versionSeriesId);
                continue;
            }
            String parentId = (String)state.get((Object)"ecm:parentId");
            State state2 = state = parentId == null ? null : this.getStateForRead(parentId);
        } while (state != null);
        ArrayList racl = new ArrayList(racls);
        Collections.sort(racl);
        return racl.toArray(new String[racl.size()]);
    }

    protected Set<String> getSubTree(String id, Map<String, String> proxyTargets, Map<String, Object[]> targetProxies) {
        HashSet<String> ids = new HashSet<String>();
        HashSet<String> seen = new HashSet<String>(this.savedDeleted);
        block0: for (DBSDocumentState docState : this.savedStates.values()) {
            String oid = docState.getId();
            seen.add(oid);
            Object[] ancestors = (Object[])docState.get("ecm:ancestorIds");
            if (ancestors == null) continue;
            for (Object aid : ancestors) {
                Object[] proxyIds;
                if (!id.equals(aid)) continue;
                ids.add(oid);
                if (proxyTargets != null && Boolean.TRUE.equals(docState.get("ecm:isProxy"))) {
                    String targetId = (String)((Object)docState.get("ecm:proxyTargetId"));
                    proxyTargets.put(oid, targetId);
                }
                if (targetProxies == null || (proxyIds = (Object[])docState.get("ecm:proxyIds")) == null) continue block0;
                targetProxies.put(oid, proxyIds);
                continue block0;
            }
        }
        this.repository.queryKeyValueArray("ecm:ancestorIds", id, ids, proxyTargets, targetProxies, seen);
        return ids;
    }

    protected String generateNewId(String id) {
        if (id == null) {
            id = this.repository.generateNewId();
        }
        return id;
    }

    public List<DBSDocumentState> getKeyValuedStates(String key, String value) {
        LinkedList<DBSDocumentState> docStates = new LinkedList<DBSDocumentState>();
        HashSet<String> seen = new HashSet<String>();
        for (DBSDocumentState docState : this.transientStates.values()) {
            seen.add(docState.getId());
            if (!value.equals(docState.get(key))) continue;
            docStates.add(docState);
        }
        for (DBSDocumentState docState : this.savedStates.values()) {
            if (!seen.add(docState.getId()) || !value.equals(docState.get(key))) continue;
            docState = this.makeTransient(docState);
            docStates.add(docState);
        }
        List<State> states = this.repository.queryKeyValue(key, value, seen);
        for (State state : states) {
            DBSDocumentState docState = this.returnTransient(state);
            docStates.add(docState);
        }
        return docStates;
    }

    public void save() {
        List<Work> works = this.getFulltextWorks();
        this.updateProxies();
        for (String id : this.transientCreated) {
            DBSDocumentState docState = this.transientStates.get(id);
            docState.setNotDirty();
            this.savedStates.put(id, new DBSDocumentState(docState));
            this.savedCreated.add(id);
        }
        for (DBSDocumentState docState : this.transientStates.values()) {
            String id = docState.getId();
            if (this.transientCreated.contains(id) || !docState.isDirty()) continue;
            docState.setNotDirty();
            this.savedStates.put(id, new DBSDocumentState(docState));
        }
        this.transientCreated.clear();
        this.scheduleWork(works);
    }

    protected void updateProxies() {
        for (String id : this.transientCreated) {
            DBSDocumentState docState = this.transientStates.get(id);
            Object[] proxyIds = (Object[])docState.get("ecm:proxyIds");
            if (proxyIds == null) continue;
            for (Object proxyId : proxyIds) {
                this.updateProxy(docState, (String)proxyId);
            }
        }
        for (String id : this.transientStates.keySet().toArray(new String[0])) {
            Object[] proxyIds;
            DBSDocumentState docState = this.transientStates.get(id);
            if (this.transientCreated.contains(id) || !docState.isDirty() || (proxyIds = (Object[])docState.get("ecm:proxyIds")) == null) continue;
            for (Object proxyId : proxyIds) {
                this.updateProxy(docState, (String)proxyId);
            }
        }
    }

    protected void updateProxy(DBSDocumentState target, String proxyId) {
        DBSDocumentState proxy = this.getStateForUpdate(proxyId);
        if (proxy == null) {
            throw new NullPointerException();
        }
        for (String key : proxy.getState().keySet().toArray(new String[0])) {
            if (this.proxySpecific(key)) continue;
            proxy.put(key, null);
        }
        for (Map.Entry en : target.getState().entrySet()) {
            String key = (String)en.getKey();
            if (this.proxySpecific(key)) continue;
            proxy.put(key, CopyHelper.deepCopy((Serializable)((Serializable)en.getValue())));
        }
    }

    protected boolean proxySpecific(String key) {
        switch (key) {
            case "ecm:id": 
            case "ecm:parentId": 
            case "ecm:ancestorIds": 
            case "ecm:name": 
            case "ecm:pos": 
            case "ecm:acp": 
            case "ecm:racl": 
            case "ecm:isProxy": 
            case "ecm:proxyTargetId": 
            case "ecm:proxyVersionSeriesId": 
            case "ecm:isVersion": 
            case "ecm:baseVersionId": 
            case "ecm:versionSeriesId": 
            case "ecm:proxyIds": {
                return true;
            }
        }
        return false;
    }

    protected void flush() throws DocumentException {
        for (String id : this.savedCreated) {
            DBSDocumentState docState = this.savedStates.get(id);
            this.repository.createState(docState.getState());
        }
        for (DBSDocumentState docState : this.savedStates.values()) {
            if (this.savedCreated.contains(docState.getId())) continue;
            this.repository.updateState(docState.getState());
        }
        for (String id : this.savedDeleted) {
            this.repository.deleteState(id);
        }
        this.clearTransient();
        this.clearSaved();
    }

    public void commit() throws DocumentException {
        this.save();
        this.flush();
    }

    public void rollback() {
        this.clearTransient();
        this.clearSaved();
    }

    protected void clearTransient() {
        this.transientStates.clear();
        this.transientCreated.clear();
    }

    protected void clearSaved() {
        this.savedStates.clear();
        this.savedCreated.clear();
        this.savedDeleted.clear();
    }

    protected List<Work> getFulltextWorks() {
        HashSet<String> docsWithDirtyStrings = new HashSet<String>();
        HashSet<String> docsWithDirtyBinaries = new HashSet<String>();
        this.findDirtyDocuments(docsWithDirtyStrings, docsWithDirtyBinaries);
        if (docsWithDirtyStrings.isEmpty() && docsWithDirtyBinaries.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Work> works = new LinkedList<Work>();
        this.getFulltextSimpleWorks(works, docsWithDirtyStrings);
        this.getFulltextBinariesWorks(works, docsWithDirtyBinaries);
        return works;
    }

    protected void findDirtyDocuments(Set<String> docsWithDirtyStrings, Set<String> docWithDirtyBinaries) {
        for (String id : this.transientCreated) {
            docsWithDirtyStrings.add(id);
            docWithDirtyBinaries.add(id);
        }
        for (DBSDocumentState docState : this.transientStates.values()) {
            if (!docState.isDirtyIgnoringFulltext()) continue;
            String id = docState.getId();
            docsWithDirtyStrings.add(id);
            docWithDirtyBinaries.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getFulltextSimpleWorks(List<Work> works, Set<String> docsWithDirtyStrings) {
        FulltextParser fulltextParser = new FulltextParser();
        for (String id : docsWithDirtyStrings) {
            String documentType;
            FulltextConfiguration config;
            if (id == null) {
                log.error((Object)"Got null doc id in fulltext update, cannot happen");
                continue;
            }
            DBSDocumentState docState = this.getStateForUpdate(id);
            if (docState == null || !(config = new FulltextConfiguration()).isFulltextIndexable(documentType = docState.getPrimaryType())) continue;
            docState.put("ecm:fulltextJobId", (Serializable)((Object)docState.getId()));
            fulltextParser.setDocument(docState, this.session);
            try {
                LinkedList<FulltextUpdaterWork.IndexAndText> indexesAndText = new LinkedList<FulltextUpdaterWork.IndexAndText>();
                for (String indexName : config.indexNames) {
                    String text = fulltextParser.findFulltext(indexName);
                    indexesAndText.add(new FulltextUpdaterWork.IndexAndText(indexName, text));
                }
                if (indexesAndText.isEmpty()) continue;
                FulltextUpdaterWork work = new FulltextUpdaterWork(this.repository.getName(), id, true, false, indexesAndText);
                works.add((Work)work);
            }
            finally {
                fulltextParser.setDocument(null, this.session);
            }
        }
    }

    protected void getFulltextBinariesWorks(List<Work> works, Set<String> docWithDirtyBinaries) {
        if (docWithDirtyBinaries.isEmpty()) {
            return;
        }
        FulltextConfiguration config = new FulltextConfiguration();
        for (String id : docWithDirtyBinaries) {
            DBSDocumentState docState = this.getStateForUpdate(id);
            if (docState == null || !config.isFulltextIndexable(docState.getPrimaryType())) continue;
            docState.put("ecm:fulltextJobId", (Serializable)((Object)docState.getId()));
        }
        for (String id : docWithDirtyBinaries) {
            FulltextExtractorWork work = new FulltextExtractorWork(this.repository.getName(), id);
            works.add((Work)work);
        }
    }

    protected void scheduleWork(List<Work> works) {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        if (repositoryManager != null && !works.isEmpty()) {
            WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
            for (Work work : works) {
                workManager.schedule(work, WorkManager.Scheduling.IF_NOT_SCHEDULED, true);
            }
        }
    }
}

