/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.storage.dbs.FulltextConfiguration;
import org.nuxeo.ecm.core.storage.dbs.FulltextParser;
import org.nuxeo.ecm.core.storage.dbs.FulltextUpdaterWork;
import org.nuxeo.ecm.core.utils.BlobsExtractor;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;

public class FulltextExtractorWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FulltextExtractorWork.class);
    private static final String ANY2TEXT = "any2text";
    protected static final String CATEGORY = "fulltextExtractor";
    protected static final String TITLE = "fulltextExtractor";
    protected transient FulltextConfiguration fulltextConfig;
    protected transient FulltextParser fulltextParser;

    public FulltextExtractorWork(String repositoryName, String docId) {
        super(repositoryName + ':' + docId + ":fulltextExtractor");
        this.setDocument(repositoryName, docId);
    }

    public String getCategory() {
        return "fulltextExtractor";
    }

    public String getTitle() {
        return "fulltextExtractor";
    }

    public void work() throws Exception {
        this.initSession();
        if (this.session.getPrincipal() == null) {
            return;
        }
        this.fulltextConfig = this.getFulltextConfig();
        this.initFulltextParser();
        this.setStatus("Extracting");
        this.setProgress(Work.Progress.PROGRESS_0_PC);
        this.extractBinaryText();
        this.setProgress(Work.Progress.PROGRESS_100_PC);
        this.setStatus("Done");
    }

    protected void extractBinaryText() throws ClientException {
        IdRef docRef = new IdRef(this.docId);
        if (!this.session.exists((DocumentRef)docRef)) {
            return;
        }
        DocumentModel doc = this.session.getDocument((DocumentRef)docRef);
        if (!this.fulltextConfig.isFulltextIndexable(doc.getType())) {
            return;
        }
        BlobsExtractor extractor = new BlobsExtractor();
        LinkedList<FulltextUpdaterWork.IndexAndText> indexesAndText = new LinkedList<FulltextUpdaterWork.IndexAndText>();
        for (String indexName : this.fulltextConfig.indexNames) {
            if (!this.fulltextConfig.indexesAllBinary.contains(indexName) && this.fulltextConfig.propPathsByIndexBinary.get(indexName) == null) continue;
            extractor.setExtractorProperties(this.fulltextConfig.propPathsByIndexBinary.get(indexName), this.fulltextConfig.propPathsExcludedByIndexBinary.get(indexName), this.fulltextConfig.indexesAllBinary.contains(indexName));
            List blobs = extractor.getBlobs(doc);
            String text = this.blobsToText(blobs, this.docId);
            this.fulltextParser.setStrings(new ArrayList<String>());
            this.fulltextParser.parse(text, null);
            text = StringUtils.join(this.fulltextParser.getStrings(), (String)" ");
            indexesAndText.add(new FulltextUpdaterWork.IndexAndText(indexName, text));
        }
        if (!indexesAndText.isEmpty()) {
            FulltextUpdaterWork work = new FulltextUpdaterWork(this.repositoryName, this.docId, false, true, indexesAndText);
            WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
            workManager.schedule((Work)work, true);
        }
    }

    public void cleanUp(boolean ok, Exception e) {
        super.cleanUp(ok, e);
        this.fulltextConfig = null;
        this.fulltextParser = null;
    }

    protected FulltextConfiguration getFulltextConfig() {
        FulltextConfiguration config = new FulltextConfiguration();
        return config;
    }

    protected void initFulltextParser() {
        this.fulltextParser = new FulltextParser();
    }

    protected String blobsToText(List<Blob> blobs, String docId) {
        LinkedList<String> strings = new LinkedList<String>();
        for (Blob blob : blobs) {
            try {
                SimpleBlobHolder bh = new SimpleBlobHolder(blob);
                BlobHolder result = this.convert((BlobHolder)bh);
                if (result == null || (blob = result.getBlob()) == null) continue;
                String string = new String(blob.getByteArray(), "UTF-8");
                if (string.indexOf(0) >= 0) {
                    string = string.replace("\u0000", " ");
                }
                strings.add(string);
            }
            catch (Exception e) {
                String msg = "Could not extract fulltext of file '" + blob.getFilename() + "' for document: " + docId + ": " + e;
                log.warn((Object)msg);
                log.debug((Object)msg, (Throwable)e);
            }
        }
        return StringUtils.join(strings, (String)" ");
    }

    protected BlobHolder convert(BlobHolder blobHolder) throws ConversionException {
        ConversionService conversionService = (ConversionService)Framework.getLocalService(ConversionService.class);
        if (conversionService == null) {
            log.debug((Object)"No ConversionService available");
            return null;
        }
        return conversionService.convert(ANY2TEXT, blobHolder, null);
    }
}

