/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.local;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.AbstractSession;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.TransactionalCoreSessionWrapper;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class LocalSession
extends AbstractSession
implements Synchronization {
    private static final long serialVersionUID = 1L;
    private static final AtomicLong SID_COUNTER = new AtomicLong();
    private static final Log log = LogFactory.getLog(LocalSession.class);
    protected String repositoryName;
    protected NuxeoPrincipal principal;
    private String sessionId;
    private final ThreadLocal<SessionInfo> threadSessions = new ThreadLocal();
    private final Set<SessionInfo> allSessions = Collections.newSetFromMap(new ConcurrentHashMap());

    public static CoreSession createInstance() {
        return TransactionalCoreSessionWrapper.wrap(new LocalSession());
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void connect(String repositoryName, NuxeoPrincipal principal) throws ClientException {
        if (this.sessionId != null) {
            throw new ClientException("CoreSession already connected");
        }
        this.repositoryName = repositoryName;
        this.principal = principal;
        this.createMetrics();
        this.sessionId = LocalSession.newSessionId(repositoryName, principal);
        log.debug((Object)("Creating CoreSession: " + this.sessionId));
        this.createSession();
    }

    protected static String newSessionId(String repositoryName, NuxeoPrincipal principal) {
        return repositoryName + '/' + principal.getName() + '#' + SID_COUNTER.incrementAndGet();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public Session getSession() {
        SessionInfo si = this.threadSessions.get();
        if (si == null || !si.session.isLive()) {
            this.closeInThisThread();
            log.debug((Object)("Reconnecting CoreSession: " + this.sessionId));
            if (!TransactionHelper.isTransactionActive()) {
                throw new ClientRuntimeException("No transaction, cannot reconnect: " + this.sessionId);
            }
            try {
                TransactionHelper.lookupTransactionManager().getTransaction().registerSynchronization((Synchronization)this);
            }
            catch (NamingException | RollbackException | SystemException e) {
                throw new ClientRuntimeException("Cannot register synchronization", e);
            }
            si = this.createSession();
        }
        return si.session;
    }

    protected SessionInfo createSession() {
        Session session;
        RepositoryService repositoryService = (RepositoryService)((Object)Framework.getLocalService(RepositoryService.class));
        Repository repository = repositoryService.getRepository(this.repositoryName);
        if (repository == null) {
            throw new ClientRuntimeException("No such repository: " + this.repositoryName);
        }
        try {
            session = repository.getSession(this.sessionId);
        }
        catch (DocumentException e) {
            throw new ClientRuntimeException("Failed to load repository " + this.repositoryName + ": " + e.getMessage(), (Throwable)e);
        }
        SessionInfo si = new SessionInfo(session);
        this.threadSessions.set(si);
        this.allSessions.add(si);
        log.debug((Object)("Adding thread " + Thread.currentThread().getName() + " for CoreSession: " + this.sessionId));
        return si;
    }

    public void close() {
        CoreInstance.closeCoreSession((CoreSession)this);
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        this.closeInThisThread();
    }

    protected void closeInThisThread() {
        SessionInfo si = this.threadSessions.get();
        if (si != null) {
            si.session.close();
            this.threadSessions.remove();
            this.allSessions.remove(si);
            log.debug((Object)("Removing thread " + Thread.currentThread().getName() + " for CoreSession: " + this.sessionId));
        }
    }

    public void destroy() {
        log.debug((Object)("Closing CoreSession: " + this.sessionId));
        int size = this.allSessions.size();
        if (size > 1) {
            Exception closeException = new Exception("Close stack trace for " + this.sessionId + " in thread " + Thread.currentThread().getName());
            log.warn((Object)("At close time there are still " + size + " Session objects." + " Dumping close() then open() stack traces."), (Throwable)closeException);
            for (SessionInfo si : this.allSessions) {
                log.warn((Object)"Session open at", (Throwable)si.openException);
            }
        }
        this.closeInThisThread();
        if (!this.allSessions.isEmpty()) {
            for (SessionInfo si : this.allSessions) {
                si.session.close();
                si.openException = null;
            }
            this.allSessions.clear();
        }
    }

    public NuxeoPrincipal getPrincipal() {
        return this.principal;
    }

    public boolean isStateSharedByAllThreadSessions() {
        return this.getSession().isStateSharedByAllThreadSessions();
    }

    public static final class SessionInfo {
        private final Session session;
        private Exception openException;

        public SessionInfo(Session session) {
            this.session = session;
            this.openException = new Exception("Open stack trace for " + session.getSessionId() + " in thread " + Thread.currentThread().getName());
        }
    }
}

