/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.query.sql.model.BooleanLiteral;
import org.nuxeo.ecm.core.query.sql.model.DateLiteral;
import org.nuxeo.ecm.core.query.sql.model.DoubleLiteral;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.Function;
import org.nuxeo.ecm.core.query.sql.model.IntegerLiteral;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.storage.ExpressionEvaluator;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.ecm.core.storage.dbs.FulltextQueryAnalyzer;
import org.nuxeo.runtime.api.Framework;

public class MongoDBQueryBuilder {
    private static final Long ZERO = 0L;
    private static final Long ONE = 1L;
    protected final SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
    protected final ExpressionEvaluator.PathResolver pathResolver;

    public MongoDBQueryBuilder(ExpressionEvaluator.PathResolver pathResolver) {
        this.pathResolver = pathResolver;
    }

    public DBObject walkExpression(Expression expr) {
        String name;
        Operator op = expr.operator;
        Operand lvalue = expr.lvalue;
        Operand rvalue = expr.rvalue;
        String string = name = lvalue instanceof Reference ? ((Reference)lvalue).name : null;
        if (op == Operator.STARTSWITH) {
            return this.walkStartsWith(lvalue, rvalue);
        }
        if ("ecm:path".equals(name)) {
            return this.walkEcmPath(op, rvalue);
        }
        if (name != null && name.startsWith("ecm:fulltext") && !"ecm:fulltextJobId".equals(name)) {
            return this.walkEcmFulltext(name, op, rvalue);
        }
        if (op == Operator.SUM) {
            throw new UnsupportedOperationException("SUM");
        }
        if (op == Operator.SUB) {
            throw new UnsupportedOperationException("SUB");
        }
        if (op == Operator.MUL) {
            throw new UnsupportedOperationException("MUL");
        }
        if (op == Operator.DIV) {
            throw new UnsupportedOperationException("DIV");
        }
        if (op == Operator.LT) {
            return this.walkLt(lvalue, rvalue);
        }
        if (op == Operator.GT) {
            return this.walkGt(lvalue, rvalue);
        }
        if (op == Operator.EQ) {
            return this.walkEq(lvalue, rvalue);
        }
        if (op == Operator.NOTEQ) {
            return this.walkNotEq(lvalue, rvalue);
        }
        if (op == Operator.LTEQ) {
            return this.walkLtEq(lvalue, rvalue);
        }
        if (op == Operator.GTEQ) {
            return this.walkGtEq(lvalue, rvalue);
        }
        if (op == Operator.AND) {
            if (expr instanceof MultiExpression) {
                return this.walkMultiExpression((MultiExpression)expr);
            }
            return this.walkAnd(lvalue, rvalue);
        }
        if (op == Operator.NOT) {
            return this.walkNot(lvalue);
        }
        if (op == Operator.OR) {
            return this.walkOr(lvalue, rvalue);
        }
        if (op == Operator.LIKE) {
            return this.walkLike(lvalue, rvalue, true, false);
        }
        if (op == Operator.ILIKE) {
            return this.walkLike(lvalue, rvalue, true, true);
        }
        if (op == Operator.NOTLIKE) {
            return this.walkLike(lvalue, rvalue, false, false);
        }
        if (op == Operator.NOTILIKE) {
            return this.walkLike(lvalue, rvalue, false, true);
        }
        if (op == Operator.IN) {
            return this.walkIn(lvalue, rvalue, true);
        }
        if (op == Operator.NOTIN) {
            return this.walkIn(lvalue, rvalue, false);
        }
        if (op == Operator.ISNULL) {
            return this.walkIsNull(lvalue);
        }
        if (op == Operator.ISNOTNULL) {
            return this.walkIsNotNull(lvalue);
        }
        if (op == Operator.BETWEEN) {
            throw new UnsupportedOperationException("BETWEEN");
        }
        if (op == Operator.NOTBETWEEN) {
            throw new UnsupportedOperationException("NOT BETWEEN");
        }
        throw new RuntimeException("Unknown operator: " + op);
    }

    protected DBObject walkEcmPath(Operator op, Operand rvalue) {
        String id;
        if (op != Operator.EQ && op != Operator.NOTEQ) {
            throw new RuntimeException("ecm:path requires = or <> operator");
        }
        if (!(rvalue instanceof StringLiteral)) {
            throw new RuntimeException("ecm:path requires literal path as right argument");
        }
        String path = ((StringLiteral)rvalue).value;
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((id = this.pathResolver.getIdForPath(path)) == null) {
            return new BasicDBObject("_id", (Object)"__nosuchid__");
        }
        String field = this.walkReference((Reference)new Reference((String)"ecm:uuid")).field;
        if (op == Operator.EQ) {
            return new BasicDBObject(field, (Object)id);
        }
        return new BasicDBObject(field, (Object)new BasicDBObject("$ne", (Object)id));
    }

    protected DBObject walkEcmFulltext(String name, Operator op, Operand rvalue) {
        if (op != Operator.EQ && op != Operator.LIKE) {
            throw new RuntimeException("ecm:fulltext requires = or LIKE operator");
        }
        if (!(rvalue instanceof StringLiteral)) {
            throw new RuntimeException("ecm:fulltext requires literal string as right argument");
        }
        String fulltextQuery = ((StringLiteral)rvalue).value;
        if (name.equals("ecm:fulltext")) {
            fulltextQuery = this.getMongoDBFulltextQuery(fulltextQuery);
            BasicDBObject textSearch = new BasicDBObject();
            textSearch.put("$search", (Object)fulltextQuery);
            return new BasicDBObject("$text", (Object)textSearch);
        }
        if (name.charAt("ecm:fulltext".length()) != '.') {
            throw new RuntimeException(name + " has incorrect syntax" + " for a secondary fulltext index");
        }
        String prop = name.substring("ecm:fulltext".length() + 1);
        fulltextQuery = fulltextQuery.replace(" ", "%");
        rvalue = new StringLiteral(fulltextQuery);
        return this.walkLike((Operand)new Reference(prop), rvalue, true, true);
    }

    protected String getMongoDBFulltextQuery(String query) {
        FulltextQueryAnalyzer.FulltextQuery ft = FulltextQueryAnalyzer.analyzeFulltextQuery((String)query);
        return FulltextQueryAnalyzer.translateFulltext((FulltextQueryAnalyzer.FulltextQuery)ft, (String)" ", (String)" ", (String)" -", (String)"\"", (String)"\"", Collections.emptySet(), (String)"\"", (String)"\"", (boolean)false);
    }

    public DBObject walkNot(Operand value) {
        Object val = this.walkOperand(value);
        Object not = this.pushDownNot(val);
        if (!(not instanceof DBObject)) {
            throw new RuntimeException("Cannot do NOT on: " + val);
        }
        return (DBObject)not;
    }

    protected Object pushDownNot(Object object) {
        if (!(object instanceof DBObject)) {
            throw new RuntimeException("Cannot do NOT on: " + object);
        }
        DBObject ob = (DBObject)object;
        Set keySet = ob.keySet();
        if (keySet.size() != 1) {
            throw new RuntimeException("Cannot do NOT on: " + ob);
        }
        String key = (String)keySet.iterator().next();
        Object value = ob.get(key);
        if (!key.startsWith("$")) {
            return new BasicDBObject(key, (Object)new BasicDBObject("$ne", value));
        }
        if ("$ne".equals(key)) {
            return value;
        }
        if ("$not".equals(key)) {
            return value;
        }
        if ("$and".equals(key) || "$or".equals(key)) {
            String op = "$and".equals(key) ? "$or" : "$and";
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, this.pushDownNot(list.get(i)));
            }
            return new BasicDBObject(op, (Object)list);
        }
        if ("$in".equals(key) || "$nin".equals(key)) {
            String op = "$in".equals(key) ? "$nin" : "$in";
            return new BasicDBObject(op, value);
        }
        if ("$lt".equals(key) || "$gt".equals(key) || "$lte".equals(key) || "$gte".equals(key)) {
            return new BasicDBObject("$not", (Object)ob);
        }
        throw new RuntimeException("Unknown operator for NOT: " + key);
    }

    public DBObject walkIsNull(Operand value) {
        String field = this.walkReference((Operand)value).field;
        return new BasicDBObject(field, null);
    }

    public DBObject walkIsNotNull(Operand value) {
        String field = this.walkReference((Operand)value).field;
        return new BasicDBObject(field, (Object)new BasicDBObject("$ne", null));
    }

    public DBObject walkMultiExpression(MultiExpression expr) {
        return this.walkAnd(expr.values);
    }

    public DBObject walkAnd(Operand lvalue, Operand rvalue) {
        return this.walkAnd(Arrays.asList(lvalue, rvalue));
    }

    protected DBObject walkAnd(List<Operand> values) {
        List<Object> list = this.walkOperandList(values);
        if (list.size() == 1) {
            return (DBObject)list.get(0);
        }
        return new BasicDBObject("$and", list);
    }

    public DBObject walkOr(Operand lvalue, Operand rvalue) {
        Object left = this.walkOperand(lvalue);
        Object right = this.walkOperand(rvalue);
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(left, right));
        return new BasicDBObject("$or", list);
    }

    protected Object checkBoolean(FieldInfo fieldInfo, Object right) {
        if (fieldInfo.isBoolean && right instanceof Long) {
            if (ZERO.equals(right)) {
                right = fieldInfo.isTrueOrNullBoolean ? null : Boolean.FALSE;
            } else if (ONE.equals(right)) {
                right = Boolean.TRUE;
            } else {
                throw new RuntimeException("Invalid boolean: " + right);
            }
        }
        return right;
    }

    public DBObject walkEq(Operand lvalue, Operand rvalue) {
        FieldInfo fieldInfo = this.walkReference(lvalue);
        Object right = this.walkOperand(rvalue);
        right = this.checkBoolean(fieldInfo, right);
        return new BasicDBObject(fieldInfo.field, right);
    }

    public DBObject walkNotEq(Operand lvalue, Operand rvalue) {
        FieldInfo fieldInfo = this.walkReference(lvalue);
        Object right = this.walkOperand(rvalue);
        right = this.checkBoolean(fieldInfo, right);
        return new BasicDBObject(fieldInfo.field, (Object)new BasicDBObject("$ne", right));
    }

    public DBObject walkLt(Operand lvalue, Operand rvalue) {
        String field = this.walkReference((Operand)lvalue).field;
        Object right = this.walkOperand(rvalue);
        return new BasicDBObject(field, (Object)new BasicDBObject("$lt", right));
    }

    public DBObject walkGt(Operand lvalue, Operand rvalue) {
        String field = this.walkReference((Operand)lvalue).field;
        Object right = this.walkOperand(rvalue);
        return new BasicDBObject(field, (Object)new BasicDBObject("$gt", right));
    }

    public DBObject walkLtEq(Operand lvalue, Operand rvalue) {
        String field = this.walkReference((Operand)lvalue).field;
        Object right = this.walkOperand(rvalue);
        return new BasicDBObject(field, (Object)new BasicDBObject("$lte", right));
    }

    public DBObject walkGtEq(Operand lvalue, Operand rvalue) {
        String field = this.walkReference((Operand)lvalue).field;
        Object right = this.walkOperand(rvalue);
        return new BasicDBObject(field, (Object)new BasicDBObject("$gte", right));
    }

    public DBObject walkIn(Operand lvalue, Operand rvalue, boolean positive) {
        String field = this.walkReference((Operand)lvalue).field;
        Object right = this.walkOperand(rvalue);
        if (!(right instanceof List)) {
            throw new RuntimeException("Invalid IN, right hand side must be a list: " + rvalue);
        }
        List list = (List)right;
        return new BasicDBObject(field, (Object)new BasicDBObject(positive ? "$in" : "$nin", (Object)list));
    }

    public DBObject walkLike(Operand lvalue, Operand rvalue, boolean positive, boolean caseInsensitive) {
        String field = this.walkReference((Operand)lvalue).field;
        if (!(rvalue instanceof StringLiteral)) {
            throw new RuntimeException("Invalid LIKE/ILIKE, right hand side must be a string: " + rvalue);
        }
        String like = this.walkStringLiteral((StringLiteral)rvalue);
        String regex = like.replaceAll("([^a-zA-Z0-9%])", "\\\\$1");
        regex = regex.replaceAll("%", ".*");
        int flags = caseInsensitive ? 2 : 0;
        Pattern pattern = Pattern.compile(regex, flags);
        Pattern value = positive ? pattern : new BasicDBObject("$not", (Object)pattern);
        return new BasicDBObject(field, (Object)value);
    }

    public Object walkOperand(Operand op) {
        if (op instanceof Literal) {
            return this.walkLiteral((Literal)op);
        }
        if (op instanceof LiteralList) {
            return this.walkLiteralList((LiteralList)op);
        }
        if (op instanceof Function) {
            return this.walkFunction((Function)op);
        }
        if (op instanceof Expression) {
            return this.walkExpression((Expression)op);
        }
        if (op instanceof Reference) {
            return this.walkReference((Reference)op);
        }
        throw new RuntimeException("Unknown operand: " + op);
    }

    public Object walkLiteral(Literal lit) {
        if (lit instanceof BooleanLiteral) {
            return this.walkBooleanLiteral((BooleanLiteral)lit);
        }
        if (lit instanceof DateLiteral) {
            return this.walkDateLiteral((DateLiteral)lit);
        }
        if (lit instanceof DoubleLiteral) {
            return this.walkDoubleLiteral((DoubleLiteral)lit);
        }
        if (lit instanceof IntegerLiteral) {
            return this.walkIntegerLiteral((IntegerLiteral)lit);
        }
        if (lit instanceof StringLiteral) {
            return this.walkStringLiteral((StringLiteral)lit);
        }
        throw new RuntimeException("Unknown literal: " + lit);
    }

    public Object walkBooleanLiteral(BooleanLiteral lit) {
        return lit.value;
    }

    public Date walkDateLiteral(DateLiteral lit) {
        return lit.value.toDate();
    }

    public Double walkDoubleLiteral(DoubleLiteral lit) {
        return lit.value;
    }

    public Long walkIntegerLiteral(IntegerLiteral lit) {
        return lit.value;
    }

    public String walkStringLiteral(StringLiteral lit) {
        return lit.value;
    }

    public List<Object> walkLiteralList(LiteralList litList) {
        ArrayList<Object> list = new ArrayList<Object>(litList.size());
        for (Literal lit : litList) {
            list.add(this.walkLiteral(lit));
        }
        return list;
    }

    protected List<Object> walkOperandList(List<Operand> values) {
        ArrayList<Object> list = new ArrayList<Object>(values.size());
        for (Operand value : values) {
            list.add(this.walkOperand(value));
        }
        return list;
    }

    public Object walkFunction(Function func) {
        throw new UnsupportedOperationException("Function");
    }

    public DBObject walkStartsWith(Operand lvalue, Operand rvalue) {
        if (!(lvalue instanceof Reference)) {
            throw new RuntimeException("Invalid STARTSWITH query, left hand side must be a property: " + lvalue);
        }
        String name = ((Reference)lvalue).name;
        if (!(rvalue instanceof StringLiteral)) {
            throw new RuntimeException("Invalid STARTSWITH query, right hand side must be a literal path: " + rvalue);
        }
        String path = ((StringLiteral)rvalue).value;
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ("ecm:path".equals(name)) {
            return this.walkStartsWithPath(path);
        }
        return this.walkStartsWithNonPath(lvalue, path);
    }

    protected DBObject walkStartsWithPath(String path) {
        String ancestorId = this.pathResolver.getIdForPath(path);
        if (ancestorId == null) {
            return new BasicDBObject("_id", (Object)"__nosuchid__");
        }
        return new BasicDBObject("ecm:ancestorIds", (Object)ancestorId);
    }

    protected DBObject walkStartsWithNonPath(Operand lvalue, String path) {
        String field = this.walkReference((Operand)lvalue).field;
        BasicDBObject eq = new BasicDBObject(field, (Object)path);
        String regex = path.replaceAll("([^a-zA-Z0-9 /])", "\\\\$1");
        Pattern pattern = Pattern.compile(regex + "/.*");
        BasicDBObject like = new BasicDBObject(field, (Object)pattern);
        return new BasicDBObject("$or", Arrays.asList(eq, like));
    }

    protected FieldInfo walkReference(Operand value) {
        if (!(value instanceof Reference)) {
            throw new RuntimeException("Invalid query, left hand side must be a property: " + value);
        }
        return this.walkReference((Reference)value);
    }

    public FieldInfo walkReference(Reference ref) {
        String name = ref.name;
        Object[] split = StringUtils.split((String)name, (char)'/');
        if (name.startsWith("ecm:")) {
            String prop = DBSSession.convToInternal((String)name);
            boolean isBoolean = DBSSession.isBoolean((String)prop);
            return new FieldInfo(prop, isBoolean, true);
        }
        String prop = split[0];
        Field field = this.schemaManager.getField(prop);
        if (field == null) {
            if (prop.indexOf(58) > -1) {
                throw new RuntimeException("Unkown property: " + name);
            }
            for (Schema schema : this.schemaManager.getSchemas()) {
                if (StringUtils.isBlank((String)schema.getNamespace().prefix) && schema != null && (field = schema.getField(prop)) != null) break;
            }
            if (field == null) {
                throw new RuntimeException("Unkown property: " + name);
            }
        }
        split[0] = field.getName().getPrefixedName();
        name = StringUtils.join((Object[])split, (char)'.');
        boolean isBoolean = field.getType() instanceof BooleanType;
        return new FieldInfo(name, isBoolean, false);
    }

    protected static class FieldInfo {
        protected String field;
        protected boolean isBoolean;
        protected boolean isTrueOrNullBoolean;

        protected FieldInfo(String field, boolean isBoolean, boolean isTrueOrNullBoolean) {
            this.field = field;
            this.isBoolean = isBoolean;
            this.isTrueOrNullBoolean = isTrueOrNullBoolean;
        }
    }
}

