/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import com.mongodb.WriteResult;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.storage.PartialList;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSExpressionEvaluator;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryBase;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBQueryBuilder;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepositoryDescriptor;

public class MongoDBRepository
extends DBSRepositoryBase {
    private static final Log log = LogFactory.getLog(MongoDBRepository.class);
    private static final Long ZERO = 0L;
    private static final Long ONE = 1L;
    private static final Long MINUS_ONE = -1L;
    public static final String DB_NAME = "nuxeo";
    public static final String MONGODB_ID = "_id";
    public static final String MONGODB_INC = "$inc";
    private static final String MONGODB_INDEX_TEXT = "text";
    private static final String MONGODB_INDEX_NAME = "name";
    protected static final String COUNTER_NAME_UUID = "ecm:id";
    protected static final String COUNTER_FIELD = "seq";
    protected MongoClient mongoClient;
    protected DBCollection coll;
    protected DBCollection countersColl;

    public MongoDBRepository(MongoDBRepositoryDescriptor descriptor) {
        super(descriptor.name);
        try {
            this.mongoClient = MongoDBRepository.newMongoClient(descriptor);
            this.coll = MongoDBRepository.getCollection(descriptor, this.mongoClient);
            this.countersColl = MongoDBRepository.getCountersCollection(descriptor, this.mongoClient);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.initRepository();
    }

    public void shutdown() {
        this.mongoClient.close();
    }

    public static MongoClient newMongoClient(MongoDBRepositoryDescriptor descriptor) throws UnknownHostException {
        ServerAddress addr = new ServerAddress(descriptor.server);
        return new MongoClient(addr);
    }

    protected static DBCollection getCollection(MongoClient mongoClient, String name) {
        DB db = mongoClient.getDB(DB_NAME);
        return db.getCollection(name);
    }

    public static DBCollection getCollection(MongoDBRepositoryDescriptor descriptor, MongoClient mongoClient) {
        return MongoDBRepository.getCollection(mongoClient, descriptor.name);
    }

    public static DBCollection getCountersCollection(MongoDBRepositoryDescriptor descriptor, MongoClient mongoClient) {
        return MongoDBRepository.getCollection(mongoClient, descriptor.name + ".counters");
    }

    protected DBObject stateToBson(State state, boolean skipNull) {
        BasicDBObject ob = new BasicDBObject();
        for (Map.Entry en : state.entrySet()) {
            Object val;
            String key = (String)en.getKey();
            Serializable value = (Serializable)en.getValue();
            if (value instanceof State) {
                val = this.stateToBson((State)value, skipNull);
            } else if (value instanceof List) {
                List states = (List)((Object)value);
                ArrayList<DBObject> obs = new ArrayList<DBObject>(states.size());
                for (Serializable state1 : states) {
                    obs.add(this.stateToBson((State)state1, skipNull));
                }
                val = obs;
            } else if (value instanceof Object[]) {
                Object[] ar = (Object[])value;
                ArrayList<Object> list = new ArrayList<Object>(ar.length);
                for (Object v : ar) {
                    list.add(this.serializableToScalar((Serializable)v));
                }
                val = list;
            } else {
                val = this.serializableToScalar(value);
            }
            if (val == null && skipNull) continue;
            ob.put(key, val);
        }
        return ob;
    }

    protected State bsonToState(DBObject ob) {
        if (ob == null) {
            return null;
        }
        State state = new State();
        for (String key : ob.keySet()) {
            Object value;
            Object val = ob.get(key);
            if (val instanceof List) {
                List list = (List)val;
                if (list.isEmpty()) {
                    value = null;
                } else if (list.get(0) instanceof DBObject) {
                    ArrayList<State> l = new ArrayList<State>(list.size());
                    for (Object el : list) {
                        l.add(this.bsonToState((DBObject)el));
                    }
                    value = l;
                } else {
                    Object[] ar = new Object[list.size()];
                    int i = 0;
                    for (Object el : list) {
                        ar[i++] = this.scalarToSerializable(el);
                    }
                    value = ar;
                }
            } else if (val instanceof DBObject) {
                value = this.bsonToState((DBObject)val);
            } else {
                if (MONGODB_ID.equals(key)) continue;
                value = this.scalarToSerializable(val);
            }
            state.put((Object)key, value);
        }
        return state;
    }

    protected Object serializableToScalar(Serializable value) {
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        return value;
    }

    protected Serializable scalarToSerializable(Object val) {
        if (val instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)val);
            return cal;
        }
        return (Serializable)val;
    }

    protected void initRepository() {
        BasicDBObject indexKeys = new BasicDBObject();
        indexKeys.put("ecm:fulltextSimple", (Object)MONGODB_INDEX_TEXT);
        indexKeys.put("ecm:fulltextBinary", (Object)MONGODB_INDEX_TEXT);
        BasicDBObject indexOptions = new BasicDBObject(MONGODB_INDEX_NAME, (Object)"fulltext");
        this.coll.createIndex((DBObject)indexKeys, (DBObject)indexOptions);
        BasicDBObject query = new BasicDBObject(COUNTER_NAME_UUID, (Object)this.getRootId());
        if (this.coll.findOne((DBObject)query, this.justPresenceField()) != null) {
            return;
        }
        BasicDBObject idCounter = new BasicDBObject();
        idCounter.put(MONGODB_ID, (Object)COUNTER_NAME_UUID);
        idCounter.put(COUNTER_FIELD, (Object)ZERO);
        this.countersColl.insert(new DBObject[]{idCounter});
        this.initRoot();
    }

    protected Long getNextUuidSeq() {
        BasicDBObject query = new BasicDBObject(MONGODB_ID, (Object)COUNTER_NAME_UUID);
        BasicDBObject update = new BasicDBObject(MONGODB_INC, (Object)new BasicDBObject(COUNTER_FIELD, (Object)ONE));
        boolean returnNew = true;
        DBObject idCounter = this.countersColl.findAndModify((DBObject)query, null, null, false, (DBObject)update, returnNew, false);
        if (idCounter == null) {
            throw new RuntimeException("Repository id counter not initialized");
        }
        return (Long)idCounter.get(COUNTER_FIELD);
    }

    public String generateNewId() {
        Long id = this.getNextUuidSeq();
        return "UUID_" + id;
    }

    public void createState(State state) throws DocumentException {
        DBObject ob = this.stateToBson(state, true);
        this.coll.insert(new DBObject[]{ob});
    }

    public State readState(String id) {
        BasicDBObject query = new BasicDBObject(COUNTER_NAME_UUID, (Object)id);
        return this.findOne((DBObject)query);
    }

    public List<State> readStates(List<String> ids) {
        BasicDBObject query = new BasicDBObject(COUNTER_NAME_UUID, (Object)new BasicDBObject("$in", ids));
        return this.findAll((DBObject)query, ids.size());
    }

    public void updateState(State state) throws DocumentException {
        String id = (String)state.get((Object)COUNTER_NAME_UUID);
        BasicDBObject query = new BasicDBObject(COUNTER_NAME_UUID, (Object)id);
        DBObject ob = this.stateToBson(state, false);
        this.coll.update((DBObject)query, ob);
    }

    public void deleteState(String id) throws DocumentException {
        BasicDBObject query = new BasicDBObject(COUNTER_NAME_UUID, (Object)id);
        WriteResult w = this.coll.remove((DBObject)query);
        if (w.getN() != 1) {
            log.error((Object)("Removed " + w.getN() + " docs for id: " + id));
        }
    }

    public State readChildState(String parentId, String name, Set<String> ignored) {
        DBObject query = this.getChildQuery(parentId, name, ignored);
        return this.findOne(query);
    }

    public boolean hasChild(String parentId, String name, Set<String> ignored) {
        DBObject query = this.getChildQuery(parentId, name, ignored);
        return this.coll.findOne(query, this.justPresenceField()) != null;
    }

    protected DBObject getChildQuery(String parentId, String name, Set<String> ignored) {
        BasicDBObject query = new BasicDBObject();
        query.put("ecm:parentId", (Object)parentId);
        query.put("ecm:name", (Object)name);
        this.addIgnoredIds((DBObject)query, ignored);
        return query;
    }

    protected void addIgnoredIds(DBObject query, Set<String> ignored) {
        if (!ignored.isEmpty()) {
            BasicDBObject notInIds = new BasicDBObject("$nin", new ArrayList<String>(ignored));
            query.put(COUNTER_NAME_UUID, (Object)notInIds);
        }
    }

    public List<State> queryKeyValue(String key, String value, Set<String> ignored) {
        BasicDBObject query = new BasicDBObject(key, (Object)value);
        this.addIgnoredIds((DBObject)query, ignored);
        return this.findAll((DBObject)query, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryKeyValueArray(String key, Object value, Set<String> ids, Map<String, String> proxyTargets, Map<String, Object[]> targetProxies, Set<String> ignored) {
        BasicDBObject query = new BasicDBObject(key, value);
        this.addIgnoredIds((DBObject)query, ignored);
        BasicDBObject fields = new BasicDBObject();
        fields.put(MONGODB_ID, (Object)ZERO);
        fields.put(COUNTER_NAME_UUID, (Object)ONE);
        fields.put("ecm:isProxy", (Object)ONE);
        fields.put("ecm:proxyTargetId", (Object)ONE);
        fields.put("ecm:proxyIds", (Object)ONE);
        try (DBCursor cursor = this.coll.find((DBObject)query, (DBObject)fields);){
            for (DBObject ob : cursor) {
                Object[] proxyIds;
                String id = (String)ob.get(COUNTER_NAME_UUID);
                ids.add(id);
                if (proxyTargets != null && Boolean.TRUE.equals(ob.get("ecm:isProxy"))) {
                    String targetId = (String)ob.get("ecm:proxyTargetId");
                    proxyTargets.put(id, targetId);
                }
                if (targetProxies == null || (proxyIds = (Object[])ob.get("ecm:proxyIds")) == null) continue;
                targetProxies.put(id, proxyIds);
            }
        }
    }

    public boolean queryKeyValuePresence(String key, String value, Set<String> ignored) {
        BasicDBObject query = new BasicDBObject(key, (Object)value);
        this.addIgnoredIds((DBObject)query, ignored);
        return this.coll.findOne((DBObject)query, this.justPresenceField()) != null;
    }

    protected State findOne(DBObject query) {
        return this.bsonToState(this.coll.findOne(query));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<State> findAll(DBObject query, int sizeHint) {
        try (DBCursor cursor = this.coll.find(query);){
            ArrayList<State> list = new ArrayList<State>(sizeHint);
            for (DBObject ob : cursor) {
                list.add(this.bsonToState(ob));
            }
            ArrayList<State> arrayList = list;
            return arrayList;
        }
    }

    protected DBObject justPresenceField() {
        return new BasicDBObject(MONGODB_ID, (Object)ONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartialList<State> queryAndFetch(Expression expression, DBSExpressionEvaluator evaluator, OrderByClause orderByClause, int limit, int offset, int countUpTo, boolean deepCopy, Set<String> ignored) {
        long totalSize;
        ArrayList<State> list;
        MongoDBQueryBuilder builder = new MongoDBQueryBuilder(evaluator.pathResolver);
        DBObject query = builder.walkExpression(expression);
        this.addIgnoredIds(query, ignored);
        this.addPrincipals(query, evaluator.principals);
        if (log.isTraceEnabled()) {
            log.trace((Object)("MongoDB: " + query + " offset " + offset + " limit " + limit));
        }
        try (DBCursor cursor = this.coll.find(query).skip(offset).limit(limit);){
            if (orderByClause != null) {
                BasicDBObject orderBy = new BasicDBObject();
                for (OrderByExpr ob : orderByClause.elements) {
                    Reference ref = ob.reference;
                    boolean desc = ob.isDescending;
                    String field = builder.walkReference((Reference)ref).field;
                    if (orderBy.containsField(field)) continue;
                    orderBy.put(field, (Object)(desc ? MINUS_ONE : ONE));
                }
                cursor = cursor.sort((DBObject)orderBy);
            }
            list = new ArrayList<State>();
            for (DBObject ob : cursor) {
                list.add(this.bsonToState(ob));
            }
            if (countUpTo == -1) {
                totalSize = limit == 0 ? (long)list.size() : (long)cursor.count();
            } else if (countUpTo == 0) {
                totalSize = -1L;
            } else {
                totalSize = limit == 0 ? (long)list.size() : (long)cursor.copy().limit(countUpTo + 1).count();
                if (totalSize > (long)countUpTo) {
                    totalSize = -2L;
                }
            }
        }
        if (log.isTraceEnabled() && list.size() != 0) {
            log.trace((Object)("MongoDB: -> " + list.size()));
        }
        return new PartialList(list, totalSize);
    }

    protected void addPrincipals(DBObject query, Set<String> principals) {
        if (principals != null) {
            BasicDBObject inPrincipals = new BasicDBObject("$in", new ArrayList<String>(principals));
            query.put("ecm:racl", (Object)inPrincipals);
        }
    }
}

