/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import java.util.concurrent.Callable;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepositoryFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class MongoDBRepositoryService
extends DefaultComponent {
    private static final String XP_REPOSITORY = "repository";
    protected RepositoryDescriptorRegistry registry = new RepositoryDescriptorRegistry();

    public void activate(ComponentContext context) {
        this.registry.clear();
    }

    public void deactivate(ComponentContext context) {
        this.registry.clear();
    }

    public void registerContribution(Object contrib, String xpoint, ComponentInstance contributor) {
        if (!XP_REPOSITORY.equals(xpoint)) {
            throw new RuntimeException("Unknown extension point: " + xpoint);
        }
        this.addContribution((MongoDBRepositoryDescriptor)contrib);
    }

    public void unregisterContribution(Object contrib, String xpoint, ComponentInstance contributor) {
        if (!XP_REPOSITORY.equals(xpoint)) {
            throw new RuntimeException("Unknown extension point: " + xpoint);
        }
        this.removeContribution((MongoDBRepositoryDescriptor)contrib);
    }

    protected void addContribution(MongoDBRepositoryDescriptor descriptor) {
        this.registry.addContribution(descriptor);
        this.updateRegistration(descriptor.name);
    }

    protected void removeContribution(MongoDBRepositoryDescriptor descriptor) {
        this.registry.removeContribution(descriptor);
        this.updateRegistration(descriptor.name);
    }

    protected void updateRegistration(String repositoryName) {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        MongoDBRepositoryDescriptor descriptor = this.registry.getRepositoryDescriptor(repositoryName);
        if (descriptor == null) {
            repositoryManager.removeRepository(repositoryName);
            return;
        }
        MongoDBRepositoryFactory repositoryFactory = new MongoDBRepositoryFactory();
        repositoryFactory.init(repositoryName);
        Repository repository = new Repository(repositoryName, descriptor.label, descriptor.isDefault(), (Callable)((Object)repositoryFactory));
        repositoryManager.addRepository(repository);
    }

    public MongoDBRepositoryDescriptor getRepositoryDescriptor(String name) {
        return this.registry.getRepositoryDescriptor(name);
    }

    protected static class RepositoryDescriptorRegistry
    extends SimpleContributionRegistry<MongoDBRepositoryDescriptor> {
        protected RepositoryDescriptorRegistry() {
        }

        public String getContributionId(MongoDBRepositoryDescriptor contrib) {
            return contrib.name;
        }

        public MongoDBRepositoryDescriptor clone(MongoDBRepositoryDescriptor orig) {
            return new MongoDBRepositoryDescriptor(orig);
        }

        public void merge(MongoDBRepositoryDescriptor src, MongoDBRepositoryDescriptor dst) {
            dst.merge(src);
        }

        public boolean isSupportingMerge() {
            return true;
        }

        public void clear() {
            this.currentContribs.clear();
        }

        public MongoDBRepositoryDescriptor getRepositoryDescriptor(String id) {
            return (MongoDBRepositoryDescriptor)this.getCurrentContribution(id);
        }
    }
}

