/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.binary.Binary;

public class CopyHelper {
    private CopyHelper() {
    }

    public static State deepCopy(State state) {
        state = new State(state);
        for (Map.Entry entry : state.entrySet()) {
            entry.setValue(CopyHelper.deepCopy((Serializable)entry.getValue()));
        }
        return state;
    }

    public static List<Serializable> deepCopy(List<Serializable> list) {
        list = new ArrayList<Serializable>(list);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, CopyHelper.deepCopy(list.get(i)));
        }
        return list;
    }

    public static Serializable deepCopy(Serializable value) {
        if (value instanceof State) {
            State state = (State)value;
            value = CopyHelper.deepCopy(state);
        } else if (value instanceof List) {
            List list = (List)((Object)value);
            value = (Serializable)((Object)CopyHelper.deepCopy(list));
        } else if (value instanceof Object[]) {
            value = (Serializable)((Object[])value).clone();
        } else if (!(value == null || value instanceof String || value instanceof Boolean || value instanceof Long || value instanceof Double || value instanceof Calendar || value instanceof Binary)) {
            throw new UnsupportedOperationException("Cannot deep copy: " + value.getClass().getName());
        }
        return value;
    }
}

