/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.dnd;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.core.schema.utils.DateParser;

@Name(value="dndFormActions")
@Scope(value=ScopeType.PAGE)
public class DndFormActionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Map<String, Map<String, Serializable>> metadataCollector;
    @Deprecated
    protected String currentSchema;
    @Deprecated
    protected String currentLayout;
    @RequestParameter
    @Deprecated
    protected String schema;
    @RequestParameter
    @Deprecated
    protected String layout;
    protected List<String> currentSchemas;
    protected String currentLayouts;
    @RequestParameter
    protected String schemas;
    @RequestParameter
    protected String layouts;

    @Deprecated
    public String getSchema() {
        if (this.schema != null && !this.schema.isEmpty()) {
            this.currentSchema = this.schema;
        }
        return this.currentSchema;
    }

    @Deprecated
    public String getLayout() {
        if (this.layout != null && !this.layout.isEmpty()) {
            this.currentLayout = this.layout;
        }
        return this.currentLayout;
    }

    public List<String> getSchemas() {
        this.currentSchemas = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)this.schemas)) {
            this.currentSchemas.addAll(Arrays.asList(this.schemas.split(",")));
        } else if (StringUtils.isNotBlank((String)this.schema)) {
            this.currentSchemas.add(this.schema);
        }
        return this.currentSchemas;
    }

    public String getLayouts() {
        if (StringUtils.isNotBlank((String)this.layouts)) {
            this.currentLayouts = this.layouts;
        } else if (StringUtils.isNotBlank((String)this.layout)) {
            this.currentLayouts = this.layout;
        }
        return this.currentLayouts;
    }

    @Factory(value="dataCollector", scope=ScopeType.PAGE)
    public Map<String, Map<String, Serializable>> getCollector() {
        if (this.metadataCollector == null) {
            this.metadataCollector = new HashMap<String, Map<String, Serializable>>();
            for (String schema : this.getSchemas()) {
                this.metadataCollector.put(schema, new HashMap());
            }
        }
        return this.metadataCollector;
    }

    public String save() throws JSONException {
        this.sendHtmlJSONResponse();
        return null;
    }

    public void sendHtmlJSONResponse() throws JSONException {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext econtext = context.getExternalContext();
        HttpServletResponse response = (HttpServletResponse)econtext.getResponse();
        response.setContentType("text/html");
        try {
            response.getWriter().write(this.getCollectedData());
            response.flushBuffer();
        }
        catch (IOException e) {
            // empty catch block
        }
        context.responseComplete();
    }

    public String getCollectedData() throws JSONException {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>\n");
        sb.append("<script>\n");
        sb.append("var collectedData= ");
        JSONObject jsonObject = new JSONObject();
        JSONObject formData = new JSONObject();
        for (String key : this.metadataCollector.keySet()) {
            for (String field : this.metadataCollector.get(key).keySet()) {
                Object data = this.metadataCollector.get(key).get(field);
                if (data instanceof Date) {
                    data = DateParser.formatW3CDateTime((Date)((Date)data));
                } else if (data instanceof Calendar) {
                    data = DateParser.formatW3CDateTime((Date)((Calendar)data).getTime());
                }
                formData.put(key + ":" + field, data);
            }
        }
        jsonObject.put("docMetaData", (Object)formData);
        sb.append(jsonObject.toString());
        sb.append(";\n");
        sb.append("//console.log(collectedData);\n");
        sb.append("window.parent.dndFormFunctionCB(collectedData);\n");
        sb.append("</script>\n");
        sb.append("</html>");
        return sb.toString();
    }
}

