/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.pattern.producer;

import java.util.concurrent.ThreadLocalRandom;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.message.BlobMessage;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.producer.AbstractProducer;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.producer.RandomDocumentMessageProducer;
import org.nuxeo.ecm.platform.importer.random.DictionaryHolder;
import org.nuxeo.ecm.platform.importer.random.HunspellDictionaryHolder;
import org.nuxeo.ecm.platform.importer.random.RandomTextGenerator;

public class RandomStringBlobMessageProducer
extends AbstractProducer<BlobMessage> {
    private static final String DEFAULT_MIME_TYPE = "plain/text";
    private final long nbBlobs;
    private final int averageSizeKB;
    private final ThreadLocalRandom rand;
    private long count = 0L;
    private static RandomTextGenerator gen;
    private final String mimetype;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomStringBlobMessageProducer(int producerId, long nbBlobs, String lang, int averageSizeKB) {
        super(producerId);
        this.nbBlobs = nbBlobs;
        this.averageSizeKB = averageSizeKB;
        this.mimetype = DEFAULT_MIME_TYPE;
        Class<RandomDocumentMessageProducer> clazz = RandomDocumentMessageProducer.class;
        synchronized (RandomDocumentMessageProducer.class) {
            if (gen == null) {
                gen = new RandomTextGenerator((DictionaryHolder)new HunspellDictionaryHolder(lang));
                gen.prefilCache();
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            this.rand = ThreadLocalRandom.current();
            return;
        }
    }

    public int getPartition(BlobMessage message, int partitions) {
        return (int)this.count % partitions;
    }

    public boolean hasNext() {
        return this.count < this.nbBlobs;
    }

    public BlobMessage next() {
        String filename = this.generateFilename();
        String content = this.generateContent();
        BlobMessage ret = new BlobMessage.StringMessageBuilder(content).setFilename(filename).setMimetype(this.mimetype).build();
        ++this.count;
        return ret;
    }

    private String generateFilename() {
        return gen.getRandomTitle(this.rand.nextInt(4) + 1).trim().replaceAll("\\W+", "-").toLowerCase() + ".txt";
    }

    private String generateContent() {
        return gen.getRandomText(this.averageSizeKB);
    }
}

